<?php
namespace App\Model\Table;

use App\Model\Entity\ItuPreventionBundle;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ItuPreventionBundles Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsTo $Screenings
 * @property \Cake\ORM\Association\HasMany $DailyItuPreventionBundles
 */
class ItuPreventionBundlesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('itu_prevention_bundles');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->belongsTo('Screenings', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('DailyItuPreventionBundles', [
            'foreignKey' => 'itu_prevention_bundle_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
        //->date('date_instalation')
        ->requirePresence('date_instalation', 'create')
            ->notEmpty('date_instalation');

        $validator
            ->requirePresence('type_of_device', 'create')
            ->notEmpty('type_of_device');

        $validator
            ->boolean('emergency')
            ->allowEmpty('emergency');

        $validator
            ->boolean('is_risk_of_bleeding_verified')
            ->allowEmpty('is_risk_of_bleeding_verified');

        $validator
            ->boolean('is_the_procedure_prescribed')
            ->allowEmpty('is_the_procedure_prescribed');

        $validator
            ->allowEmpty('device_observation');

        $validator
            ->boolean('proper_handwashing')
            ->allowEmpty('proper_handwashing');

        $validator
            ->boolean('use_of_paramentation')
            ->allowEmpty('use_of_paramentation');

        $validator
            ->boolean('use_of_antisepsis')
            ->allowEmpty('use_of_antisepsis');

        $validator
            ->boolean('use_of_field_with_maxium_barrier')
            ->allowEmpty('use_of_field_with_maxium_barrier');

        $validator
            ->boolean('use_of_sterile_gel')
            ->allowEmpty('use_of_sterile_gel');

        $validator
            ->boolean('suitable_catheter_progression')
            ->allowEmpty('suitable_catheter_progression');

        $validator
            ->boolean('urine_output_cauterization')
            ->allowEmpty('urine_output_cauterization');

        $validator
            ->boolean('adequate_catheter_fixation')
            ->allowEmpty('adequate_catheter_fixation');

        $validator
            ->boolean('confirmation_of_position_with_us')
            ->allowEmpty('confirmation_of_position_with_us');

        $validator
            ->integer('checklist_observation')
            ->allowEmpty('checklist_observation');

        $validator
            ->integer('number_of_retries')
            ->allowEmpty('number_of_retries');

        $validator
            ->boolean('single_procedure')
            ->allowEmpty('single_procedure');

        $validator
            ->integer('number_of_professionals')
            ->allowEmpty('number_of_professionals');

        $validator
            ->boolean('blood_on_catheter')
            ->allowEmpty('blood_on_catheter');

        $validator
            ->boolean('successful_integration')
            ->allowEmpty('successful_integration');

        $validator
            ->allowEmpty('immediate_complications');

        $validator
            ->date('date_of_withdrawal')
            ->allowEmpty('date_of_withdrawal');

        $validator
            ->date('withdrawal_time')
            ->allowEmpty('withdrawal_time');

        $validator
            ->boolean('accidental_removal')
            ->allowEmpty('accidental_removal');

        $validator
            ->allowEmpty('reason_for_inclusion');

        $validator
            ->time('reinsert_time')
            ->allowEmpty('reinsert_time');

        $validator
            ->date('reinsert_date')
            ->allowEmpty('reinsert_date');

        $validator
            ->boolean('citostimia')
            ->allowEmpty('citostimia');

        $validator
            ->allowEmpty('type');

        $validator
            ->boolean('degermacao_pele_clorohexidine')
            ->allowEmpty('degermacao_pele_clorohexidine');

        $validator
            ->boolean('antisepsia_pele_clorohexidine')
            ->allowEmpty('antisepsia_pele_clorohexidine');

        $validator
            ->boolean('asseptica_durante_procedimento')
            ->allowEmpty('asseptica_durante_procedimento');

        $validator
            ->boolean('ultrasom_durante_procedimento')
            ->allowEmpty('ultrasom_durante_procedimento');

        $validator
            ->boolean('troca_introducar_picc')
            ->allowEmpty('troca_introducar_picc');

        $validator
            ->boolean('curativo_tecnica_esteril')
            ->allowEmpty('curativo_tecnica_esteril');

        $validator
            ->boolean('verificado_risco_dificuldade')
            ->allowEmpty('verificado_risco_dificuldade');

        $validator
            ->allowEmpty('risco_de_dificuldade');

        $validator
            ->boolean('tci_preenchido')
            ->allowEmpty('tci_preenchido');

        $validator
            ->boolean('degermacao_da_genitalia')
            ->allowEmpty('degermacao_da_genitalia');

        $validator
            ->boolean('curativo_tecnica_steril')
            ->allowEmpty('curativo_tecnica_steril');

        $validator
            ->boolean('conectores_cvc')
            ->allowEmpty('conectores_cvc');

        $validator
            ->boolean('radiografia_de_controle')
            ->allowEmpty('radiografia_de_controle');

        $validator
            ->allowEmpty('apos_proce_observacao');

        $validator
            ->allowEmpty('pontuation');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        $rules->add($rules->existsIn(['screening_id'], 'Screenings'));
        return $rules;
    }
}
