<?php
namespace App\Model\Table;

use App\Model\Entity\DailyItuPreventionBundle;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * DailyItuPreventionBundles Model
 *
 * @property \Cake\ORM\Association\BelongsTo $ItuPreventionBundles
 */
class DailyItuPreventionBundlesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('daily_itu_prevention_bundles');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('ItuPreventionBundles', [
            'foreignKey' => 'itu_prevention_bundle_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('curativo')
            ->allowEmpty('curativo');

        $validator
            ->boolean('presenca_sangue')
            ->allowEmpty('presenca_sangue');

        $validator
            ->boolean('presenca_secrecao')
            ->allowEmpty('presenca_secrecao');

        $validator
            ->boolean('cateter_devidamente')
            ->allowEmpty('cateter_devidamente');

        $validator
            ->boolean('conector_exposto')
            ->allowEmpty('conector_exposto');

        $validator
            ->boolean('via_cateter')
            ->allowEmpty('via_cateter');

        $validator
            ->boolean('administracao')
            ->allowEmpty('administracao');

        $validator
            ->boolean('avaliado_a_retirada')
            ->allowEmpty('avaliado_a_retirada');

        $validator
            ->boolean('active')
            ->allowEmpty('active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['itu_prevention_bundle_id'], 'ItuPreventionBundles'));
        return $rules;
    }
}
