<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Log\Log;
use Cake\ORM\TableRegistry;

/**
 * ApacheIiScores Controller
 *
 * @property \App\Model\Table\ApacheIiScoresTable $ApacheIiScores
 */
class RelatoriosController extends AppController
{

    public function initialize()
    {
        parent::initialize();

        $this->loadComponent('RequestHandler');

        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Relatórios');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return true;
        return $this->Permission->hasPermission($user['role_name'], 'Relatorios', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $hospitalizations_id = $this->request->session()->read('selected-hospitalization');

        // $this->paginate = [
        //     'contain' => ['Hospitalizations'],
        // ];
        $this->paginate = [
            'contain'    => ['NasScores', 'ApacheIiScores', 'PreDeliricScores', 'SnapIiScores', 'SapsIiiScores', 'SofaEscores', 'CribScores'],
            'conditions' => ['Hospitalizations.id =' => $hospitalizations_id],

        ];
        $hospitalizations_table = TableRegistry::get('Hospitalizations');
        $scores                 = $this->paginate($hospitalizations_table);

        //$apacheIiScores = $this->paginate($this->ApacheIiScores);

        $this->set(compact('scores'));
        $this->set('_serialize', ['scores']);
    }

    public function dashboard()
    {

    }

    public function view($id = null)
    {
        $patient_table = TableRegistry::get('Patients');
        $patient       = $patient_table->get($id);
        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename'    => 'Patient' . $id,
            ],
        ]);
        $this->set('patient', $patient);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $apacheIiScore = $this->ApacheIiScores->newEntity();
        if ($this->request->is('post')) {
            $apacheIiScore = $this->ApacheIiScores->patchEntity($apacheIiScore, $this->request->data);
            if ($this->ApacheIiScores->save($apacheIiScore)) {
                $this->Flash->success(__('O registro foi salvo..'));
                return $this->redirect(['action' => 'index']);
            } else {
                Log::write('debug', $apacheIiScore);
                Log::write('debug', $apacheIiScore->errors());
                $this->Flash->error(__('O registro não foi salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->ApacheIiScores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('apacheIiScore', 'hospitalizations'));
        $this->set('_serialize', ['apacheIiScore']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Apache Ii Score id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $apacheIiScore = $this->ApacheIiScores->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $apacheIiScore = $this->ApacheIiScores->patchEntity($apacheIiScore, $this->request->data);
            if ($this->ApacheIiScores->save($apacheIiScore)) {
                $this->Flash->success(__('O registro foi salvo..'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não foi salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->ApacheIiScores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('apacheIiScore', 'hospitalizations'));
        $this->set('_serialize', ['apacheIiScore']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Apache Ii Score id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $apacheIiScore = $this->ApacheIiScores->get($id);
        if ($this->ApacheIiScores->delete($apacheIiScore)) {
            $this->Flash->success(__('O registro foi deletado'));
        } else {
            $this->Flash->error(__('O registro não foi deletado. Por favor, tente novamente.'));
        }
        return $this->redirect(['action' => 'index']);
    }

    public function nutritionalAssessments()
    {
        //$arr = [];
        $arr = [
            'cirurgica' => ['media_indice_nutricional' => 0, 'nutrition_evolution' => 0],
            'clinica'   => ['nutrition_evolution' => 0, 'media_indice_nutricional' => 0],
            'geral'     => ['nutrition_evolution' => 0, 'media_indice_nutricional' => 0],
        ];

        $hospital_ids = [];
        $session      = $this->request->session();
        $unit_id      = $session->read('selected-unit');
        $cont         = 0;

        $evolution = [
            'cirurgica' => [],
            'geral'     => [],
            'clinica'   => [],
        ];
        $evo = [
            'cirurgica' => [],
            'geral'     => [],
            'clinica'   => [],
        ];
        $nutrition = [];

        $hospitalizations_table = TableRegistry::get('Hospitalizations');
        $nutrition_table        = TableRegistry::get('NutritionalAssessments');

        $hospital_result = $hospitalizations_table
            ->find()
            // ->select(['id'])
            ->where(['Hospitalizations.unit_id =' => $unit_id])
            ->toArray()
        ;

        //pega o id das internações separando por tipo
        foreach ($hospital_result as $key => $value) {
            if ($value['type'] == "Clínica") {
                $hospital_ids['clinica'][] = $value['id'];
            }

            if ($value['type'] == "Cirúrgica") {
                $hospital_ids['cirurgica'][] = $value['id'];
            }
            $hospital_ids['geral'][] = $value['id'];
        }

        //cada tipo de internação(clinica, cirurgica)
        foreach ($hospital_ids as $type => $typeArr) {
            $cont             = 0;
            $nutrition[$type] = $nutrition_table
                ->find()
                ->where(['NutritionalAssessments.hospitalization_id IN' => $hospital_ids[$type]])
                ->order(['NutritionalAssessments.created' => 'DESC'])
                ->toArray()
            ;

            foreach ($nutrition[$type] as $key => $value) {
                $cont++;
                $arr[$type]['media_indice_nutricional'] += $value['nutric_score'];
                //array_push($arr, $value);
                //$arr[$type] = $value;

                if ($value['nutric_score'] == 1) {
                    $evolution[$type] = $value['hospitalization_id'];
                }
            }

            //checa se o infeliz evoluiu no quadro de nutric_score partindo do número 1
            foreach ($nutrition[$type] as $key => $value) {
                //como a função in_array não aceita arrays multidimensionais criei um
                //array para receber o indice do array multidimensional
                $dummyArrEvolution[] = $evolution[$type];
                $dummyArrEvo[]       = $evo[$type];

                if (
                    (in_array($value['hospitalization_id'], $dummyArrEvo) == false)
                    && (in_array($value['hospitalization_id'], $dummyArrEvolution))
                ) {

                    if ($value['nutric_score'] > 1) {
                        $arr[$type]['nutrition_evolution']++;
                        $evo[$type][] = $value['hospitalization_id'];
                    }
                }
            }

            //gera a media do indice(total / quantidade)
            if ($cont != 0) {
                $arr[$type]['media_indice_nutricional'] = $arr[$type]['media_indice_nutricional'] / $cont;
            } else {
                $arr[$type]['media_indice_nutricional'] = 0;
            }
        }

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename'    => 'Relatório de Nutrição',
            ],
        ]);

        $this->set('nutrition', $arr);
    }

    public function bundleCateterVesical()
    {

        $hospital_ids = [];
        $session      = $this->request->session();
        $unit_id      = $session->read('selected-unit');
        $cont         = 0;

        // $evolution = [
        //     'cirurgica' => [],
        //     'geral'     => [],
        //     'clinica'   => [],
        // ];
        // $evo = [
        //     'cirurgica' => [],
        //     'geral'     => [],
        //     'clinica'   => [],
        // ];
        // $nutrition = [];

        // $hospitalizations_table = TableRegistry::get('Hospitalizations');
        // $nutrition_table        = TableRegistry::get('NutritionalAssessments');

        // $hospital_result = $hospitalizations_table
        //     ->find()
        //     // ->select(['id'])
        //     ->where(['Hospitalizations.unit_id =' => $unit_id])
        //     ->toArray()
        // ;

        // //pega o id das internações separando por tipo
        // foreach ($hospital_result as $key => $value) {
        //     if ($value['type'] == "Clínica") {
        //         $hospital_ids['clinica'][] = $value['id'];
        //     }

        //     if ($value['type'] == "Cirúrgica") {
        //         $hospital_ids['cirurgica'][] = $value['id'];
        //     }
        //     $hospital_ids['geral'][] = $value['id'];
        // }

        // //cada tipo de internação(clinica, cirurgica)
        // foreach ($hospital_ids as $type => $typeArr) {
        //     $cont             = 0;
        //     $nutrition[$type] = $nutrition_table
        //         ->find()
        //         ->where(['NutritionalAssessments.hospitalization_id IN' => $hospital_ids[$type]])
        //         ->order(['NutritionalAssessments.created' => 'DESC'])
        //         ->toArray()
        //     ;

        //     foreach ($nutrition[$type] as $key => $value) {
        //         $cont++;
        //         $arr[$type]['media_indice_nutricional'] += $value['nutric_score'];
        //         //array_push($arr, $value);
        //         //$arr[$type] = $value;

        //         if ($value['nutric_score'] == 1) {
        //             $evolution[$type] = $value['hospitalization_id'];
        //         }
        //     }

        //     //checa se o infeliz evoluiu no quadro de nutric_score partindo do número 1
        //     foreach ($nutrition[$type] as $key => $value) {
        //         //como a função in_array não aceita arrays multidimensionais criei um
        //         //array para receber o indice do array multidimensional
        //         $dummyArrEvolution[] = $evolution[$type];
        //         $dummyArrEvo[]       = $evo[$type];

        //         if (
        //             (in_array($value['hospitalization_id'], $dummyArrEvo) == false)
        //             && (in_array($value['hospitalization_id'], $dummyArrEvolution))
        //         ) {

        //             if ($value['nutric_score'] > 1) {
        //                 $arr[$type]['nutrition_evolution']++;
        //                 $evo[$type][] = $value['hospitalization_id'];
        //             }
        //         }
        //     }

        //     //gera a media do indice(total / quantidade)
        //     $arr[$type]['media_indice_nutricional'] = $arr[$type]['media_indice_nutricional'] / $cont;
        // }

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename'    => 'Relatório de cateter vesical',
            ],
        ]);

        $this->set('nutrition', 'arr');
    }

    public function supportiveMeasures()
    {
        //array suporte 1
        $suporte_procedimento_1 = array('Aminas hipertensoras', 'Balão intra-aórtico', 'Bioimpedância', 'Cateter arterial', 'Cateter de artéria pulmonar', 'Cateter de átrio esquerda', 'Cateter de mensuração da SjVO2', 'Cateter de microdiálise', 'Cateter de monitorização da pressão intracraniana', 'Cateter de PtiO2', 'Cateter venoso central curta permanência', 'Cateter venoso central longa permanência', 'Cateter venoso para diálise', 'Cateter venoso periférico', 'Cateter vesical', 'Derivação ventricular externa', 'Drogas hipotensoras em BI', 'Drogas inotrópicas em BI', 'ECMO', 'Macronebulização', 'Marcapasso transcutâneo', 'Marcapasso transvenoso', 'Monitoração hemodinâmica minimamente invasiva', 'Traqueostomia', 'Ventilação mecânica invasiva', 'Ventilação não-invasiva');
        //array suporte 2
        $suporte_procedimento_2 = array('Abciximab', 'Albumina', 'Alteplase', 'Complemento', 'Complexo protrombínico', 'Concentrado de Fibrinogênio liofilizado', 'Concentrado de Hemácias', 'Concentrado de Plaquetas', 'Criopreciptado', 'Eptifibatide', 'Estreptoquinase', 'Fator IX', 'Fator VIIa', 'Fator VIII', 'Imunoglobulina', 'Plasma fresco', 'Tenecteplase', 'Tirofiban', 'Outros hemocomponentes');

        $arr     = [];
        $session = $this->request->session();
        $unit_id = $session->read('selected-unit');
        //echo "unit_id = " . $unit_id;

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename'    => 'Relatório de medidas de suporte',
            ],
        ]);

        $patients_table = TableRegistry::get('Patients');
        //Total de pacientes cadastrados
        $total_paciente = $patients = $patients_table->find()->count();

        $supportive_measures_table = TableRegistry::get('supportiveMeasures');
        //sql para buscar todo as medidas de suporte e procedimento
        $supportive_mesasure_patients = $supportive_measures_table->find('all', [
            'contain'    => ['Hospitalizations' => ['Patients']],
            'conditions' => ['Hospitalizations.unit_id' => $unit_id],
        ]);

        $arr2 = [];
        //cria o array, com o nome do procedimento e total de usuario de usaram o serviço
        $c = 0;
        //$d = 0;
        foreach ($supportive_mesasure_patients as $key => $supportive_mesasure_patient) {
            // verifica se pertence ao array de suporte 1 ou 2
            if (in_array($supportive_mesasure_patient['type'], $suporte_procedimento_1)) {
                if (isset($supportive_mesasure_patient['data_inicio']) && isset($supportive_mesasure_patient['data_termino'])) {

                    $d1    = explode("/", $supportive_mesasure_patient['data_inicio']);
                    $d2    = explode("/", $supportive_mesasure_patient['data_termino']);
                    $data1 = new \DateTime($d1['2'] . '-' . $d1['1'] . '-' . $d1['0']);
                    $data2 = new \DateTime($d2['2'] . '-' . $d2['1'] . '-' . $d2['0']);

                    $intervalo = $data1->diff($data2);
                    //echo "dias = " .$intervalo->d;
                    //total de dias e total de vezes que foi usado
                    if ($supportive_mesasure_patient['type']) {
                        if (!isset($arr2[0][$supportive_mesasure_patient['type']]['totalDia'])) {
                            $arr2[0][$supportive_mesasure_patient['type']]['totalDia']           = $intervalo->d;
                            $arr2[0][$supportive_mesasure_patient['type']]['totalVezesUtilizou'] = 1;
                        } else {
                            $arr2[0][$supportive_mesasure_patient['type']]['totalDia']           = $arr2[0][$supportive_mesasure_patient['type']]['totalDia'] + $intervalo->d;
                            $arr2[0][$supportive_mesasure_patient['type']]['totalVezesUtilizou'] = $arr2[0][$supportive_mesasure_patient['type']]['totalVezesUtilizou'] + 1;
                        }
                    }

                    //calculando minimo
                    if (!isset($arr2[0][$supportive_mesasure_patient['type']]['minimo'])) {
                        $arr2[0][$supportive_mesasure_patient['type']]['minimo'] = $intervalo->d;
                    } else {
                        if ($arr2[0][$supportive_mesasure_patient['type']]['minimo'] > $intervalo->d) {
                            $arr2[0][$supportive_mesasure_patient['type']]['minimo'] = $intervalo->d;
                        }
                    }

                    //calculando maximo
                    if (!isset($arr2[0][$supportive_mesasure_patient['type']]['maximo'])) {
                        $arr2[0][$supportive_mesasure_patient['type']]['maximo'] = $intervalo->d;
                    } else {
                        if ($arr2[0][$supportive_mesasure_patient['type']]['maximo'] < $intervalo->d) {
                            $arr2[0][$supportive_mesasure_patient['type']]['maximo'] = $intervalo->d;
                        }
                    }

                    //inserindo elementos no array para calcular a mediana
                    $arr2[0][$supportive_mesasure_patient['type']]['calcularMediana'][] = $intervalo->d;
                }

                $arr2[0][$supportive_mesasure_patient['type']]['nome'] = $supportive_mesasure_patient['type'];
                if (!isset($arr2[0][$supportive_mesasure_patient['type']]['ids'])) {
                    $arr2[0][$supportive_mesasure_patient['type']]['ids'] = [];
                    array_push($arr2[0][$supportive_mesasure_patient['type']]['ids'], $supportive_mesasure_patient['hospitalization']['patient']['id']);
                    $arr2[0][$supportive_mesasure_patient['type']]['total_paciente'] = 1;
                } else {
                    if (!in_array($supportive_mesasure_patient['hospitalization']['patient']['id'], $arr2[0][$supportive_mesasure_patient['type']]['ids'])) {
                        array_push($arr2[0][$supportive_mesasure_patient['type']]['ids'], $supportive_mesasure_patient['hospitalization']['patient']['id']);
                        $arr2[0][$supportive_mesasure_patient['type']]['total_paciente'] = $arr2[0][$supportive_mesasure_patient['type']]['total_paciente'] + 1;
                    }
                }
            } else {

                if (isset($supportive_mesasure_patient['data_inicio']) && isset($supportive_mesasure_patient['data_termino'])) {

                    $d1    = explode("/", $supportive_mesasure_patient['data_inicio']);
                    $d2    = explode("/", $supportive_mesasure_patient['data_termino']);
                    $data1 = new \DateTime($d1['2'] . '-' . $d1['1'] . '-' . $d1['0']);
                    $data2 = new \DateTime($d2['2'] . '-' . $d2['1'] . '-' . $d2['0']);

                    $intervalo = $data1->diff($data2);

                    //total de dias e total de vezes que foi usado
                    if ($supportive_mesasure_patient['type']) {
                        if (!isset($arr2[1][$supportive_mesasure_patient['type']]['totalDia'])) {
                            $arr2[1][$supportive_mesasure_patient['type']]['totalDia']           = $intervalo->d;
                            $arr2[1][$supportive_mesasure_patient['type']]['totalVezesUtilizou'] = 1;
                        } else {
                            $arr2[1][$supportive_mesasure_patient['type']]['totalDia']           = $arr2[1][$supportive_mesasure_patient['type']]['totalDia'] + $intervalo->d;
                            $arr2[1][$supportive_mesasure_patient['type']]['totalVezesUtilizou'] = $arr2[1][$supportive_mesasure_patient['type']]['totalVezesUtilizou'] + 1;
                        }
                    }

                    //calculando minimo
                    if (!isset($arr2[1][$supportive_mesasure_patient['type']]['minimo'])) {
                        $arr2[1][$supportive_mesasure_patient['type']]['minimo'] = $intervalo->d;
                    } else {
                        if ($arr2[1][$supportive_mesasure_patient['type']]['minimo'] > $intervalo->d) {
                            $arr2[1][$supportive_mesasure_patient['type']]['minimo'] = $intervalo->d;
                        }
                    }

                    //calculando maximo
                    if (!isset($arr2[1][$supportive_mesasure_patient['type']]['maximo'])) {
                        $arr2[1][$supportive_mesasure_patient['type']]['maximo'] = $intervalo->d;
                    } else {
                        if ($arr2[1][$supportive_mesasure_patient['type']]['maximo'] < $intervalo->d) {
                            $arr2[1][$supportive_mesasure_patient['type']]['maximo'] = $intervalo->d;
                        }
                    }

                    //inserindo elementos no array para calcular a mediana
                    $arr2[1][$supportive_mesasure_patient['type']]['calcularMediana'][] = $intervalo->d;
                }

                $arr2[1][$supportive_mesasure_patient['type']]['nome'] = $supportive_mesasure_patient['type'];
                if (!isset($arr2[1][$supportive_mesasure_patient['type']]['ids'])) {
                    $arr2[1][$supportive_mesasure_patient['type']]['ids'] = [];
                    array_push($arr2[1][$supportive_mesasure_patient['type']]['ids'], $supportive_mesasure_patient['hospitalization']['patient']['id']);
                    $arr2[1][$supportive_mesasure_patient['type']]['total_paciente'] = 1;
                } else {
                    if (!in_array($supportive_mesasure_patient['hospitalization']['patient']['id'], $arr2[1][$supportive_mesasure_patient['type']]['ids'])) {
                        array_push($arr2[1][$supportive_mesasure_patient['type']]['ids'], $supportive_mesasure_patient['hospitalization']['patient']['id']);
                        $arr2[1][$supportive_mesasure_patient['type']]['total_paciente'] = $arr2[1][$supportive_mesasure_patient['type']]['total_paciente'] + 1;
                    }
                }
            }
        }

        $relatorios_table = TableRegistry::get('Relatorios');

        foreach ($arr2 as $key => $arr) {
            foreach ($arr as $key2 => $value) {
                //total de pacientes
                $percentual = ($value['total_paciente'] * 100) / $total_paciente;
                //total de parcientes em percentual
                $arr2[$key][$key2]['percentual'] = number_format($percentual, 2, '.', '');

                $diasI = $arr2[$key][$key2]['totalDia'] / $arr2[$key][$key2]['totalVezesUtilizou'];
                $cs    = $diasI - (int) $diasI;
                if ($cs != 0) {
                    $cs                              = $cs * 24;
                    $arr2[$key][$key2]['totalMedia'] = floor($diasI) . " dias e " . $cs . "h";
                } else {
                    if ($diasI == 1) {
                        //$arr2[$key][$key2]['totalMedia'] = floor($diasI) . " dia";
                        $arr2[$key][$key2]['totalMedia'] = floor($diasI);
                    } else {
                        //$arr2[$key][$key2]['totalMedia'] = floor($diasI) . " dias ";
                        $arr2[$key][$key2]['totalMedia'] = floor($diasI);
                    }
                }

                $arr2[$key][$key2]['mediana'] = $relatorios_table->mediana($arr2[$key][$key2]['calcularMediana']);
            }
        }
        // echo "<pre>";
        // print_r($arr2);

        foreach (array_merge($suporte_procedimento_1, $suporte_procedimento_2) as $key => $value) {
            if (!in_array($value, $arr2)) {
                $dummyArray = [
                    $value => [
                        'totalDia'           => 0,
                        'totalVezesUtilizou' => 0,
                        'minimo'             => 0,
                        'maximo'             => 0,
                        'mediana'            => 0,
                        'totalMedia'         => 0,
                        'percentual'         => 0,

                    ],
                ];
                array_push($arr2, $dummyArray);
            }
        }

        $this->set('data', $arr2);
    }

    public function listarFuncionario()
    {

    }

    public function indicadoresUnidade()
    {
        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename'    => 'Indicadores da unidade',
            ],
        ]);
    }

    public function indicadoresSetor()
    {
        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename'    => 'Indicadores do setor',
            ],
        ]);
    }

    public function ccih()
    {
        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename'    => 'Relatório CCIH',
            ],
        ]);
    }

    public function sihdot()
    {
        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename'    => 'Relatório SIHDOT',
            ],
        ]);
    }

    public function bundlePav()
    {
        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename'    => 'Relatório Bundle de PAV',
            ],
        ]);
    }

    public function bundlePavDiario()
    {
        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename'    => 'Relatório Bundle de PAV diario',
            ],
        ]);
    }
    public function visualizationEmergency()
    {

        $screening_table = TableRegistry::get('Screenings');
        $screening = $screening_table->find('all', [
            'contain'    => [ "MedicalCares", "Admissions", 'Patients' => ['Diagnostics'], 'Professionals'=>["Users"]],

            'conditions' => ['Screenings.unit_id' => 1],
        ]);

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'landscape',
                'filename'    => 'Visualizacao da emergencia',
            ],
        ]);
        $screening->toArray();
        $this->set('data', $screening);

    }

    public function visualizationHospitalization()
    {

        $hospitalization_table = TableRegistry::get('Hospitalizations');
        $hospitalization = $hospitalization_table->find('all', [
            'contain'    => ["IdentificationOfRisks", 'Patients', 'HistoricPatientMovements' => ['Rooms'=>['Sectors']], 'Diagnostics'],

            'conditions' => ['Hospitalizations.unit_id' => 1],
        ]);

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'landscape',
                'filename'    => 'Visualizacao dos pacientes nas unidades de internacao',
            ],
        ]);
        $hospitalization->toArray();
        $this->set('data', $hospitalization);

    }
}
