<?php
namespace App\Controller\Component;

use Cake\Controller\Component;
use Cake\Log\Log;

/**
 * Authorization component
 */
class PermissionComponent extends Component
{
    public $allow = array(
        "Administrador"  => array
        (
            "users"       => array("add", "index", "view", "edit", "delete", "activate", "desactivate", "login", "addUserToUnit", "listUsersFromUnit"),
            "units"       => array("add", "index", "view", "edit", "delete", "activate", 'desactivate', 'listUsers', "attachUsers", "linkUserToUnit", "unlinkUserFromUnit"),
            "groups"      => array("add", "index", "view", "edit", "delete"),
            "signs"       => array("add", "index", "view", "edit", "delete"),
            "specialties" => array("index", "add", "view", "edit"),
        ),
        "Qualidade"      => array
        (
            "users"                    => array("index", "add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("view"),
            "signs"                    => array("index", 'add', "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", 'delete', "selectPatient", "selectPatientEmergency"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "rooms"                    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "professionals"            => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization', 'getProfessionals', 'search'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "HealthInsurancePlans"     => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "Origins"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'dashboard'),
            "CribScores"               => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "TciTypes"                 => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "Relatorios"               => array("view", 'dashboard', 'nutritionalAssessments', 'bundleVesicalCateter'),
            "FugulinBradenScales"      => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SkinIntegrities"          => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),

        )
        ,
        "Usuário"        => array
        (
            "users"                    => array("add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("index", "view"),
            "signs"                    => array("index", 'add', "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient", "selectPatientEmergency"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "rooms"                    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "professionals"            => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization', 'getProfessionals', 'search'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "HealthInsurancePlans"     => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "Origins"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "Signs"                    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'dashboard'),
            "CribScores"               => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "TciTypes"                 => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "Relatorios"               => array("view", 'dashboard', 'nutritionalAssessments', 'bundleVesicalCateter'),
            "FugulinBradenScales"      => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SkinIntegrities"          => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
        ),

        "Médico"         => array
        (
            "users"                    => array("add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("index", "view"),
            "signs"                    => array("index", 'add', "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "rooms"                    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "professionals"            => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "CribScores"               => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "TciTypes"                 => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "FugulinBradenScales"      => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'desactivate'),
            "SkinIntegrities"          => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
        ),

        "Farmacêutico"   => array
        (
            "users"                    => array("add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("index", "view"),
            "signs"                    => array("index", 'add', "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "rooms"                    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "professionals"            => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "CribScores"               => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "TciTypes"                 => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
        ),

        "Enfermeiro"     => array
        (
            "users"                    => array("add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("index", "view"),
            "signs"                    => array("index", 'add', "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "rooms"                    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "professionals"            => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "CribScores"               => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "TciTypes"                 => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
        ),

        "Fisioterapeuta" => array
        (
            "users"                    => array("add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("index", "view"),
            "signs"                    => array("index", 'add', "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "rooms"                    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "professionals"            => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "CribScores"               => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "TciTypes"                 => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
        ),

        "CCIH"           => array
        (
            "users"                    => array("add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("index", "view"),
            "signs"                    => array("index", 'add', "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "rooms"                    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "professionals"            => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "CribScores"               => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "TciTypes"                 => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
        ),

        "SIHDOT"         => array
        (
            "users"                    => array("add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("index", "view"),
            "signs"                    => array("index", 'add', "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "rooms"                    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "professionals"            => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "CribScores"               => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
        ),

        "Administrativo" => array
        (
            "users"                    => array("add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("index", "view"),
            "signs"                    => array("index", 'add', "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "rooms"                    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "professionals"            => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "CribScores"               => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete', "desactivate", "activate"),
        ),
    );

    public $allowEditUser = array(
        "Qualidade"     => array("Qualidade", "Médico", "Farmacêutico", "Executivo"),
        "Usuário"       => array("Usuário"),
        "Administrador" => array("Administrador", "Qualidade", "Médico", "Farmacêutico", "Executivo"),
    );

    //verifica se o usuario tem permissao pra acessar a action
    public function hasPermission($role_name, $controller, $action)
    {
        // Log::write('debug', $role_name);
        // Log::write('debug', $action);
        // Log::write('debug', $controller);

        if (in_array($action, $this->allow[$role_name][$controller])) {
            Log::write('debug', "hasPermission = true, controller = " . $controller . ", action = " .
                $action . ", role_name = " . $role_name);
            return true;
        } else {
            Log::write('debug', "hasPermission = false, controller = " . $controller . ", action = " .
                $action . ", role_name = " . $role_name);
            return false;
        }
    }

    //verifica se o usuario pode editar outro usuario
    public function canEditUser($user_role_name, $target_role_name)
    {
        if (in_array($target_role_name, $this->allowEditUser[$user_role_name])) {
            Log::write('debug', "canEditUser = true, user_role_name = " . $user_role_name . ", target_role_name = "
                . $target_role_name);
            return true;
        } else {
            Log::write('debug', "canEditUser = false, user_role_name = " . $user_role_name . ", target_role_name = "
                . $target_role_name);
            return false;
        }

    }
}
