<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Comorbidities Controller
 *
 * @property \App\Model\Table\ComorbiditiesTable $Comorbidities
 */
class ComorbiditiesController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $comorbidities = $this->paginate($this->Comorbidities);

        $this->set(compact('comorbidities'));
        $this->set('_serialize', ['comorbidities']);
    }

    /**
     * View method
     *
     * @param string|null $id Comorbidity id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $comorbidity = $this->Comorbidities->get($id, [
            'contain' => ['Diagnostics']
        ]);

        $this->set('comorbidity', $comorbidity);
        $this->set('_serialize', ['comorbidity']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $comorbidity = $this->Comorbidities->newEntity();
        if ($this->request->is('post')) {
            $comorbidity = $this->Comorbidities->patchEntity($comorbidity, $this->request->data);
            if ($this->Comorbidities->save($comorbidity)) {
                $this->Flash->success(__('The comorbidity has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The comorbidity could not be saved. Please, try again.'));
            }
        }
        $diagnostics = $this->Comorbidities->Diagnostics->find('list', ['limit' => 200]);
        $this->set(compact('comorbidity', 'diagnostics'));
        $this->set('_serialize', ['comorbidity']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Comorbidity id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $comorbidity = $this->Comorbidities->get($id, [
            'contain' => ['Diagnostics']
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $comorbidity = $this->Comorbidities->patchEntity($comorbidity, $this->request->data);
            if ($this->Comorbidities->save($comorbidity)) {
                $this->Flash->success(__('The comorbidity has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The comorbidity could not be saved. Please, try again.'));
            }
        }
        $diagnostics = $this->Comorbidities->Diagnostics->find('list', ['limit' => 200]);
        $this->set(compact('comorbidity', 'diagnostics'));
        $this->set('_serialize', ['comorbidity']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Comorbidity id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $comorbidity = $this->Comorbidities->get($id);
        if ($this->Comorbidities->delete($comorbidity)) {
            $this->Flash->success(__('The comorbidity has been deleted.'));
        } else {
            $this->Flash->error(__('The comorbidity could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
