<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Alerts Controller
 *
 * @property \App\Model\Table\AlertsTable $Alerts
 */
class AlertsController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Alertas');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        return true;
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'ApacheIiScores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Units'],
        ];
        $alerts = $this->paginate($this->Alerts);

        $this->set(compact('alerts'));
        $this->set('_serialize', ['alerts']);
    }

    /**
     * View method
     *
     * @param string|null $id Alert id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $alert = $this->Alerts->get($id, [
            'contain' => ['Units'],
        ]);

        $this->set('alert', $alert);
        $this->set('_serialize', ['alert']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $alert = $this->Alerts->newEntity();
        if ($this->request->is('post')) {
            $alert = $this->Alerts->patchEntity($alert, $this->request->data);
            if ($this->Alerts->save($alert)) {
                $this->Flash->success(__('The alert has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The alert could not be saved. Please, try again.'));
            }
        }
        $units = $this->Alerts->Units->find('list', ['limit' => 200]);
        // $targetControllers = $this->Alerts->TargetControllers->find('list', ['limit' => 200]);
        $this->set(compact('alert', 'units'));
        $this->set('_serialize', ['alert']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Alert id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $alert = $this->Alerts->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $alert = $this->Alerts->patchEntity($alert, $this->request->data);
            if ($this->Alerts->save($alert)) {
                $this->Flash->success(__('The alert has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The alert could not be saved. Please, try again.'));
            }
        }
        $units = $this->Alerts->Units->find('list', ['limit' => 200]);
        $this->set(compact('alert', 'units'));
        $this->set('_serialize', ['alert']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Alert id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $alert = $this->Alerts->get($id);
        if ($this->Alerts->delete($alert)) {
            $this->Flash->success(__('The alert has been deleted.'));
        } else {
            $this->Flash->error(__('The alert could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
