var totOfMedications = 0;
var culturesObj = {};
var systemMedicationsObj = {};

function initializeMedicationsCounter(n) {
  totOfMedications = (n) ? n : 0;
}

function initializeCulturesObj(c) {
  culturesObj = (c) ? c : {};
}

function initializeSystemMedicationsObj(m) {
  systemMedicationsObj = (m) ? m : {};
}

// select options initializations
var channels = [
   'CNG',
   'Enteral',
   'GTT',
   'IM',
   'IV',
   'Nasal',
   'NBZ',
   'Ocular',
   'Oral',
   'Retal',
   'SC',
   'Spray',
   'Tópico',
   'Tecal',
   'Intrauricular',
   'Intracavitária',
   'NSA'
];

frequencies =  [
     '1X SEM',
     'SEG QUA SEX',
     'TER QUI SAB',
     'DIAS ALTERNADOS',
     '1X DIA',
     '12/12 H',
     '8/8 H',
     '6/6 H',
     '4/4 H',
     '3/3 H',
     '2/2 H',
     '1/1 H',
     'ACM',
     'SOS',
     'BI',
     'NSA'
];

var scheduling = [
   "24H - 12H",
   "22H - 10H",
   "20H - 08H",
   "18H - 06H",
   "16H - 04H",
   "14H - 02H",
   "24H - 08H - 16H",
   "22H - 06H - 14H",
   "20H - 04H - 12H",
   "18H - 02H - 10H",
   "24H - 06H - 12H - 18H",
   "22H - 04H - 10H - 16 H",
   "20H - 02H - 08H - 14 H",
   "22H - 02H - 06H - 10H - 14H - 18H",
   "20H - 24H - 04H - 08H - 12H - 16H",
   "21H - 24H - 03H - 06H - 09H - 12H - 15H - 18H",
   "20H - 23H - 02H - 05H - 08H - 11H - 14H - 17H",
   "19H - 22H - 01H - 04H - 07H - 10H - 13H - 16H",
   "20H - 22H - 24H - 02H - 04H - 06H - 08H - 10H - 12H - 14H - 16H - 18H",
   "19H - 21H - 23H - 01H - 03H - 05H - 07H - 09H - 11H - 13H - 15H - 17H",
   "20H - 21H - 22H - 23H - 24H - 01H - 02H - 03H - 04H - 05H - 06H - 07H - 08H - 09H - 10H - 11H - 12H - 13H - 14H - 15H - 16H - 17H - 18H - 19H",
   "24H",
   "22H",
   "20H",
   "18H",
   "16H",
   "14H",
   "12H",
   "10H",
   "08H",
   "06H",
   "04H",
   "02H",
   "ACM",
   "SOS",
   "NO ALMOÇO",
   "EM JEJUM 06H",
   "NO JANTAR",
   "NAS REFEIÇÕES",
   "ESQUEMA",
   "EM BOMBA INFUSORA",
   "NAS 24 HORAS",
   "HOJE NÃO - DIA ALTERNADO",
   "500-500-500-500-500-500-500-500",
   "500-500-500-500-500-500-500",
   "500-500-500-500-500-500",
   "500-500-500-500-500",
   "500-500-500-500",
   "500-500-500",
   "500-500",
   "500"
];

var scheduling12per12 = [
  "24H - 12H",
  "22H - 10H",
  "20H - 08H",
  "18H - 06H",
  "16H - 04H",
  "14H - 02H"
];

var  scheduling8per8 = [
  "24H - 08H - 16H",
  "22H - 06H - 14H",
  "20H - 04H - 12H",
  "18H - 02H - 10H",
];

var scheduling6per6 = [
  "24H - 06H - 12H - 18H",
  "22H - 04H - 10H - 16H",
  "20H - 02H - 08H - 14H",
];

var scheduling4per4 = [
  "22H - 02H - 06H - 10H - 14H - 18H",
  "20H - 24H - 04H - 08H - 12H - 16H",
];

var scheduling3per3 = [
  "21H - 24H - 03H - 06H - 09H - 12H - 15H - 18H",
  "20H - 23H - 02H - 05H - 08H - 11H - 14H - 17H",
  "19H - 22H - 01H - 04H - 07H - 10H - 13H - 16H",
];

var scheduling2per2 = [
  "20H - 22H - 24H - 02H - 04H - 06H - 08H - 10H - 12H - 14H - 16H - 18H",
  "19H - 21H - 23H - 01H - 03H - 05H - 07H - 09H - 11H - 13H - 15H - 17H",
];

var scheduling1per1 = [
    "20H - 21H - 22H - 23H - 24H - 01H - 02H - 03H - 04H - 05H - 06H - 07H - 08H - 09H - 10H - 11H - 12H - 13H - 14H - 15H - 16H - 17H - 18H - 19H",
];

var schedulingDayPerDay = [
  "24H",
  "22H",
  "20H",
  "18H",
  "16H",
  "14H",
  "12H",
  "10H",
  "08H",
  "06H",
  "04H",
  "02H",
];


function deleteMedication(rowNumber)
{
  $('#medication-data-'+rowNumber).remove();
  $('#medication-modal-'+rowNumber).remove();
  totOfMedications = (totOfMedications > 0) ? totOfMedications - 1 : 0 ;
  orderItens();
}

function deleteDbMedication(trId,medicationId)
{

  $.ajax( "http://login.ghsistema.com/homologacao/prescriptions/deactivatePrescriptionMedication/"+medicationId)
      .done(function(data) {
        $('#'+trId).remove();
        totOfMedications = (totOfMedications > 0) ? totOfMedications - 1 : 0 ;
      })
      .fail(function() {})
      .always(function() {});
  orderItens();
}



$(document).on('change', 'select.select-sytem-medication', function() {

    var $selectInput  = $(this);
    var selectedMedId = $selectInput.val();
    if(selectedMedId) {
      $.ajax(`http://login.ghsistema.com/homologacao/prescriptions/getSelectedMedication/${selectedMedId}`)
          .done(function(data) {
            fillTrInputs(data,$selectInput.parents('tr'));
          })
          .fail(function(){})
          .always(function(){});
    }
    else {
      return false;
    }
});


function fillTrInputs(medication, $tr) {

   //hidden fields
   var isAntibiotic = (medication.is_antibiotic) ? 1 : 0;
   var surSign = medication.surveillance_signaling;

   if(isAntibiotic == 1) {
      $tr.find('.medication-justification textarea').prop('required',true);
   }
   else if(surSign == "Não Padronizada") {
      $tr.find('.medication-justification textarea').prop('required',true);
   }
   else {
      $tr.find('.medication-justification textarea').prop('required',false);
   }

  //  $tr.find('.medication-hidden-inputs .is-antibiotic').val(isAntibiotic);
   $tr.find('.medication-hidden-inputs .surveillance-signaling').val(surSign);


   //normal fields
   $tr.find('.medication-quantity input').val(medication.quantity);
   $tr.find('.medication-channel select').val(medication.channel).change();
   $tr.find('.medication-frequency select').val(medication.frequency).change();

   $tr.find('.custom-check > input.imediate-start-check').prop("checked", medication.imediate_start).change();
   $tr.find('.custom-check > input.select-schedule-check').prop("checked", medication.select_schedule).change();

   $tr.find('.medication-start-date input').val(medication.start_date);
   $tr.find('.medication-using-time input').val(medication.using_time);

   $tr.find('.medication-justification textarea').val(medication.antibiotic_justification);
   $tr.find('.medication-observation textarea').val(medication.observation);

}


function showTextAreaModal(modalId,dumbTextarea) {
  dumbTextarea.blur();
  $(modalId).modal('show');
  $(modalId).find('.medication-justification textarea').focus();
}

function closeTextareaModal(modalId) {

  var formJustificationId = $(modalId).find('.medication-justification textarea').attr('class');
  var formObservationId   = $(modalId).find('.medication-observation textarea').attr('class');

  var justification = $(modalId).find('.medication-justification > textarea').val();
  var observation   = $(modalId).find('.medication-observation > textarea').val();

  $('#'+formJustificationId).val(justification);
  $('#'+formObservationId).val(observation);

  $(modalId).modal("hide");


}

function createSelectOptions(options, indexAsValue) {
   var htmlOptions = '<option value=""></option>';
   options.forEach(function(item, index) {
       htmlOptions += '<option value="'+ item +'">'+ item +'</option>';
   });
   return htmlOptions;
}

function createSelectOptionsFromObj(obj) {
  var htmlOptions = '';
  for (var key in obj) {

       if (obj.hasOwnProperty(key)) { htmlOptions += '<option value="'+ key +'">'+ obj[key] +'</option>'; }
  }
  return htmlOptions;
}

function createSystemMedicationOptions(medications) {
  var htmlOptions = '';
  for (var m in medications) {
       if (medications.hasOwnProperty(m)) {
         if(medications[m].is_active) {
            htmlOptions += '<option value="'+ medications[m].id +'" >'+ medications[m].name +'</option>';
         }
         else {
            htmlOptions += '<option class="disable-select-option" value="" disabled>'+ medications[m].name +'</option>';
         }
       }
  }
  return htmlOptions;
}



function appendItem(formType) {

   var showScheduling = ($('input[name=inserir_aprazamento]:checked').val() == 0) ? true : false;
   var table_tds = '';

   if (formType == 'defaultPrescriptionsForm') {
     table_tds = getMinimalTds(totOfMedications, showScheduling);
   }
   else if (formType == 'commonPrescriptionsForm') {
     table_tds = getCompleteTds(totOfMedications, showScheduling);
   }

   var deleteButton = '<td><a href="#" class="btn btn-danger btn-xs" onclick="deleteMedication('+totOfMedications+')">Excluir</a></td>';

   $("#tbody").append('<tr id="medication-data-'+totOfMedications+'" class="input-row ">' + table_tds + deleteButton +'</tr>');
   $('select.select-sytem-medication').select2();
   totOfMedications++;

}


function getMinimalTds(counter) {

    var tds = '';

    tds += '<td class="medication-hidden-inputs">';
    tds +=    '<input class="is-antibiotic" type="hidden" name="prescription_medications['+ counter +'][is_antibiotic]" value="0">';
    tds +=    '<input class="surveillance-signaling" type="hidden" name="prescription_medications['+ counter +'][surveillance_signaling]" value="">';
    tds += '<input type="hidden" name="prescription_medications['+counter+'][print_order]" class="medication-print-order" value="'+ (counter+1) +'">';
    tds += '</td>';

    //normal inputs
    tds +='<td class="medication-name input-tds">';
    tds +='<select required="required" name="prescription_medications['+ counter +'][system_medication_id]" id="prescription-medications-'+ counter +'-system-medication-id" class="form-control select-sytem-medication">';
    tds += '<option value="">Selecione</option>';
    tds += createSystemMedicationOptions(systemMedicationsObj);
    tds +='</select>';
    tds +='</td>';


    tds += '<td class="medication-quantity input-tds">'+
       '<input type="number" name="prescription_medications['+ counter +'][quantity]" id="prescription-medications-'+ counter +'-quantity" class="form-control" >';
    tds += '</td>';


    tds +='<td class="medication-channel input-tds">';
    tds +='<select name="prescription_medications['+ counter +'][channel]" id="prescription-medications-'+ counter +'-channel" class="form-control">';
    tds += createSelectOptions(channels);
    tds +='</select>';
    tds +='</td>';


    tds +='<td class="medication-frequency input-tds">';
    tds +='<select name="prescription_medications['+ counter +'][frequency]" id="prescription-medications-'+ counter +'-frequency" class="form-control">';
    tds += createSelectOptions(frequencies);
    tds +='</select>';
    tds +='</td>';

    return tds;
}

function getCompleteTds(counter, showScheduling) {
  var tds = '';

  //hidden inputs
  tds += '<td class="medication-hidden-inputs">';
  tds +=    '<input class="is-antibiotic" type="hidden" name="prescription_medications['+ counter +'][is_antibiotic]" value="0">';
  tds +=    '<input class="surveillance-signaling" type="hidden" name="prescription_medications['+ counter +'][surveillance_signaling]" value="">';
  tds += '<input type="hidden" name="prescription_medications['+counter+'][print_order]" class="medication-print-order" value="'+ (counter+1) +'">';
  tds += '</td>';

  //normal inputs
  tds +='<td class="medication-name input-tds">';
  tds +='<select required="required" name="prescription_medications['+ counter +'][system_medication_id]" id="prescription-medications-'+ counter +'-system-medication-id" class="form-control select-sytem-medication">';
  tds += '<option value="">Selecione</option>';
  tds += createSystemMedicationOptions(systemMedicationsObj);
  tds +='</select>';
  tds +='</td>';

  tds += '<td class="medication-quantity input-tds">'+
     '<input type="number" name="prescription_medications['+ counter +'][quantity]" id="prescription-medications-'+ counter +'-quantity" class="form-control" >';
  tds += '</td>';


  tds +='<td class="medication-channel input-tds">';
  tds +='<select name="prescription_medications['+ counter +'][channel]" id="prescription-medications-'+ counter +'-channel" class="form-control">';
  tds += createSelectOptions(channels);
  tds +='</select>';
  tds +='</td>';


  tds +='<td class="medication-frequency input-tds">';
  tds +='<select name="prescription_medications['+ counter +'][frequency]" id="prescription-medications-'+ counter +'-frequency" class="form-control">';
  tds += createSelectOptions(frequencies);
  tds +='</select>';
  tds +='</td>';

  if(showScheduling) {
    tds +='<td style="display:block;" class="medication-scheduling hidden-table-item input-tds">';
  }
  else {
    tds +='<td class="medication-scheduling input-tds hidden-table-item">';
  }
  tds +='<select name="prescription_medications['+ counter +'][schedule]" id="prescription-medications-'+ counter +'-schedule" class="form-control">';
  tds += createSelectOptions(scheduling);
  tds +='</select>';
  tds +='</td>';


  tds += '<td class="medication-imediate-start check-tds input-tds">';
  tds += '<div class="custom-check">';
  tds += '<input type="hidden" name="prescription_medications['+ counter +'][imediate_start]" value="0">';
  tds += '<input type="checkbox" name="prescription_medications['+ counter +'][imediate_start]" value="1"  id="prescription-medications-'+ counter +'-imediate-start" class="form-control imediate-start-check" >';
  tds += '<label class="check-label" for ="prescription-medications-'+ counter +'-imediate-start"></label>';
  tds +='</div>';
  tds +='</td>';

  tds +='<td class="medication-select-schedule check-tds input-tds">';
  tds += '<div class="custom-check">';
  tds += '<input type="hidden" name="prescription_medications['+ counter +'][select_schedule]" value="0">';
  tds += '<input type="checkbox" name="prescription_medications['+ counter +'][select_schedule]" value="1" id="prescription-medications-'+ counter +'-select-schedule" class="form-control select-schedule-check" >';
  tds += '<label class="check-label" for ="prescription-medications-'+ counter +'-select-schedule"></label>';
  tds +='</div>';
  tds +='</td>';

  tds += '<td class="medication-start-date input-tds">';
  tds += '<input type="text" name="prescription_medications['+ counter +'][start_date]" class="date form-control" id="prescription-medications-'+ counter +'-start-date">';
  tds +='</td>';

  tds +='<td class="medication-using-time input-tds">'+
     '<input type="number" name="prescription_medications['+ counter +'][using_time]" id="prescription-medications-'+ counter +'-using-time" class="form-control">';
  tds +='</td>';

  tds += '<td class="medication-justification input-tds">'+
     '<textarea id="prescription-medications-'+counter+'-antibiotic-justification" name="prescription_medications['+counter+'][antibiotic-justification]" onclick="showTextAreaModal(\'#medication-modal-'+ counter+'\',this)" class="form-control" rows="3"></textarea>';
  tds += '</td>';

  tds +='<td class="medication-observation input-tds">'+
     '<textarea id="prescription-medications-'+counter+'-observation" name="prescription_medications['+counter+'][observation]" onclick="showTextAreaModal(\'#medication-modal-'+ counter+'\',this)" class="form-control" rows="3"></textarea>';
  tds +='</td>';

  $(".medication-modals").append(getModal(counter));
  $('.multiselect').multiselect();

  return tds;

}

// helper to order itens on draggin'
function orderItens() {

   //recalculate itens order
   $("#tbody tr").each(function(i, elm) {

      $elm = $(elm);
      var order = $elm.index("#tbody tr") + 1;
      var identifier = $elm.attr('id');

      //update order value in table column
      $elm.find('.order').text(order);

      //update print-order value in hidden form field
      $('#'+identifier).find('.medication-hidden-inputs > input.medication-print-order').attr('value', order);

   });
}


$(document).ready(function() {

   $("input[name='inserir_aprazamento']").on("change", function() {
       var inserir = $(this).val();
       if (inserir == 0) {
          $(".hidden-table-item").fadeIn();
       }
       else {
          $(".hidden-table-item").fadeOut();
       }

   });

   var fixHelper = function(e, ui) {
     ui.children().each(function() {
       $(this).width($(this).width());
     });
     return ui;
  };

  $("#tbody").sortable({
      helper: fixHelper,
      update: function(e, ui) {
       orderItens();
     }
  });

});

function getStartDate(){

    Date.prototype.toMysqlFormat = function () {
        function pad(n) { return n < 10 ? '0' + n : n }
        return pad(this.getDate()) +"/" + pad(1 + this.getMonth()) + "/" + this.getFullYear();
    };

    var TimeNow = new Date().toMysqlFormat();

    return TimeNow;
}

$(document).on('change', "input.imediate-start-check", function() {

    if ($(this).prop('checked'))  {
        var date = new Date;
        var minutes = date.getMinutes();
        if (minutes < 10){
                minutes = "0" + minutes;
        }

        var hour        = date.getHours();
        var startTime  = hour+":"+minutes;
        var startDate   = getStartDate();

        $(this).parents('tr').find("td.medication-start-date > input").val(startDate);
        $(this).val(1);

    } else {

        $(this).parents('tr').find("td.medication-start-date > input").val('');
        $(this).val(0);

    }

});


$(document).on('change', '.medication-frequency select', function() {
  $schedulingSelect = $(this).parents('tr').find('.medication-scheduling > select');
  var newOptions = getOptionsToFrequency($(this).val());
  $schedulingSelect
    .find('option')
    .remove()
    .end()
    .append(newOptions);
});

function getOptionsToFrequency(f) {

    switch (f) {

      case '12/12 H':
          return createSelectOptions(scheduling12per12);
        break;

      case '8/8 H':
          return createSelectOptions(scheduling8per8);
        break;

      case '6/6 H':
          return createSelectOptions(scheduling6per6);
        break;

      case '4/4 H':
          return createSelectOptions(scheduling4per4);
        break;

      case '3/3 H':
          return createSelectOptions(scheduling3per3);
        break;

      case '2/2 H':
          return createSelectOptions(scheduling2per2);
        break;

      case '1/1 H':
          return createSelectOptions(scheduling1per1);
        break;

      case '1X DIA':
          return createSelectOptions(schedulingDayPerDay);
        break;

      default:
          return createSelectOptions(scheduling);
        break;
    }
}

function getModal(counter) {
  return `<div id="medication-modal-${counter}" class="modal fade" role="dialog">
     <div class="modal-dialog">
        <div class="modal-content">
           <div class="modal-header">
              <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
              <h4 class="modal-title">Digite os textos nas caixas abaixo</h4>
           </div>
           <div class="modal-body">

                <div class="medication-justification">
                  <label>Justificativa:</label>
                  <textarea class="prescription-medications-${counter}-antibiotic-justification" rows="4"></textarea>
                </div>
                <br><br>

                <div class="medication-observation">
                  <label>Observação:</label>
                  <textarea class="prescription-medications-${counter}-observation" rows="4"></textarea>
                </div>
                <br><br>

                <label>Resultado de cultura:</label>
                <select multiple="multiple" name="prescription_medications[${counter}][cultures][_ids][]" class="multiselect form-control">
                  ${createSelectOptionsFromObj(culturesObj)}
                </select>

              </div>

           <br>
           <div class="modal-footer">
              <button class="btn btn-default" type="button" onclick="closeTextareaModal('#medication-modal-${counter}')" >Ok</button>
           </div>
        </div>
     </div>
  </div>`;
}


function getValidationModal(counter) {
  return `<div id="medication-modal-${counter}" class="modal fade" role="dialog">
     <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
           <div class="modal-header">
              <button type="button" class="close" data-dismiss="modal">&times;</button>
              <h4 class="modal-title">Digite seu texto na caixa abaixo</h4>
           </div>
           <div class="modal-body">
              <div class="content">
                 <textarea onKeyUp="updateTextarea(this.value,'#prescription-medications-${counter}-observation')" style="width:100%;min-height:200px;"></textarea>
              </div>
           </div>
           <br>
           <div class="modal-footer">
              <button class="btn btn-default" type="button" data-dismiss="modal">Ok</button>
           </div>
        </div>
     </div>
  </div>`;
}

function updateTextarea(v,fieldId) {
  $(fieldId).val(v);
}
