<div class="row">
<?php

if ($current_state == 'internacao') {
    echo $this->element('internacao-menu');
} else {
    echo $this->element('screening-menu');
}

?>
<div class="medications index col-md-9 columns content">
   <?= $this->Form->create('index', ['type'=>'get','class'=>'search-form']) ?>
         <div class="inline-items search-block">
            <?php
               echo $this->Form->input('q', [
                  'label'=>false,
                  'placeholder'=>'Buscar por nome, categoria, via de administração ou por sinalização',
                  'templates' => [
                     'inputContainer' => '<div class="search-field-div form-group {{type}}{{required}}">{{content}}</div>'
                  ],
               ]);
            ?>
            <?= $this->Form->button('Pesquisar', ['class'=>'search-button']) ?>
         </div>
   <?= $this->Form->end() ?>

   <div class="print-button-div">
      <?=$this->Html->link("Novo Item", [
            'controller' => 'system-medications',
            'action' => 'add',
            "_full" => true
         ],
         [
            "class" => "btn btn-success",
         ]);
      ?>
   </div>

   <div class="print-button-div">
      <h4>Resultado de busca</h4>
      <?=$this->Html->link("Imprimir", [
            'controller' => 'system-medications',
            'action' => 'printItems',
            "?" => ["q" => $printParam],
            "_full" => true
         ],
         [
            "class" => "pull-right btn btn-success",
            'target'=>'_blank',
         ]);
      ?>
   </div>

   <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('name','Item') ?></th>
                <th><?= $this->Paginator->sort('category','Categoria') ?></th>
                <th><?= $this->Paginator->sort('channel','Via de administração') ?></th>
                <th><?= $this->Paginator->sort('surveillance_signaling','Sinalização') ?></th>
                <th class="actions"><?= __('Ações') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($medications as $medication): ?>
            <tr>
                <td><?= h($medication->name) ?></td>
                <td><?= h($medication->category) ?></td>
                <td><?= h($medication->channel) ?></td>
                <td><?= h($medication->surveillance_signaling) ?></td>

                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('Editar'), ['action' => 'edit', $medication->id], ['class'=>'btn btn-primary btn-xs']) ?>

                    <?= $this->Form->postLink(__('Deletar'), ['action' => 'deactivate', $medication->id], ['confirm' => __('Tem certeza que deseja desabilitar o registro?', $medication->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>

            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <!-- <div class="paginator">
     <center>
         <ul class="pagination">
             <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
             <?= $this->Paginator->numbers(['escape'=>false]) ?>
             <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
         </ul>
         <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
      {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
      </center>
    </div> -->

</div>
</div>


</script>
<?php
if ($current_state == "internacao"): ?>
    <script>
        (function() {
           // your page initialization code here
           // the DOM will be available here
            var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',['controller' => 'Users', 'action' => 'login'],['class' => 'btn btn-default ', 'escape' => false]) ?>';

            var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var link3 =' <?=$this->Html->link('Internações', ['controller' => 'Hospitalizations', 'action' => 'index', $hospitalizationId, '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var html = '';
                html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                html+= link1;
                html+= link2;
                html+= link3;
                html+= '<a href="#" class="breadcumb-active btn btn-default">Itens</a>';
                html+= '</div>';
                    document.getElementById("breadcumb").innerHTML =html;
        })();
    </script>

<?php else: ?>
    <script >
        (function() {
           // your page initialization code here
           // the DOM will be available here
            var link1 =' <?=$this->Html->link(
        '<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
    ['controller' => 'Users', 'action' => 'login'],
        ['class' => 'btn btn-default ', 'escape' => false]
    )?> ';

            var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var link3 =' <?=$this->Html->link('Triagem', ['controller' => 'Screenings', 'action' => 'index', $screening_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var html = '';
                html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                html+= link1;
                html+= link2;
                html+= link3;
                html+= '<a href="#" class="breadcumb-active btn btn-default">Itens</a>';
                html+= '</div>';
                    document.getElementById("breadcumb").innerHTML =html;
        })();
    </script>
<?php endif;?>
