<div class="row">

<?php
    $firstVentilatoryPlan = false;
    echo $this->element( 'internacao-menu' );

    $data_arr = [];
    foreach ($hospitalizations as $hospitalization) {
        foreach ($hospitalization['ventilatory_care_plans'] as $value) {
            $value["tipo_tabela"] = "ventilatory_care_plans";

            if ( !array_key_exists( $value->created->format("Y-m-d"), $data_arr)) {
                $data_arr[$value->created->format("Y-m-d")] = [];
            }
            array_push($data_arr[$value->created->format("Y-m-d")], $value);
        }
        foreach ($hospitalization['strength_assessment_scales'] as $value) {
            $value["tipo_tabela"] = "strength_assessment_scales";

            if ( !array_key_exists( $value->created->format("Y-m-d"), $data_arr)) {
                $data_arr[$value->created->format("Y-m-d")] = [];
            }
            array_push($data_arr[$value->created->format("Y-m-d")], $value);
        }
        foreach ($hospitalization['barthel_indexes'] as $value) {
            $value["tipo_tabela"] = "barthel_indexes";

            if ( !array_key_exists( $value->created->format("Y-m-d"), $data_arr)) {
                $data_arr[$value->created->format("Y-m-d")] = [];
            }
            array_push($data_arr[$value->created->format("Y-m-d")], $value);
        }
        krsort($data_arr);
    }
?>
<div class="strengthAssessmentScales index col-md-8 columns content">

    <br>
    <div class="btn-group">
      <button type="button" class="btn btn-default dropdown-toggle bt-menu-margin" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">

        Nova Avaliação

        <span class="caret"></span>
          </button>
          <ul class="dropdown-menu">
            <li>
                <?php
                    echo $this->Html->link(
                        'Escala de Força Muscular',
                        ['controller' => 'strengthAssessmentScales', 'action' => 'add', '_full' => true]
                    );
                ?>
            </li>
            <li>
                <?php
                    echo $this->Html->link(
                        'Índice de Barthel',
                        ['controller' => 'barthelIndexes', 'action' => 'add', '_full' => true]
                    );
                ?>
            </li>
            <li>
                <?php
                    echo $this->Html->link(
                        'Plano de Cuidado Ventilatório',
                        ['controller' => 'ventilatoryCarePlans', 'action' => 'add', '_full' => true]
                    );
                ?>
            </li>

          </ul>
    </div>

    <br>

    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th>Tipo</th>
                <th>Data de Preenchimento</th>
                <th>Pontuação</th>

                <th class="actions"><?= __('Ações') ?></th>
            </tr>
        </thead>
        <tbody>
           <?php foreach ($data_arr as $key => $data_arr_val) {
                foreach ($data_arr_val as  $value) { ?>
                    <?php 
                        if ($value['tipo_tabela'] == "ventilatory_care_plans" && $firstVentilatoryPlan == false) { 
                        $ventilatory_care_plans = $value;  
                        $firstVentilatoryPlan = true;
                    ?>
                        <tr>
                            <td>Plano Ventilatório</td>
                            <td><?= $ventilatory_care_plans->created ?></td>
                            <td></td>


                            <td class="actions" style="white-space:nowrap">
                                <?= $this->Html->link(__('Editar'), ['controller'=>'VentilatoryCarePlans', 'action' => 'index', $ventilatory_care_plans->id], ['class'=>'btn btn-primary btn-xs']) ?>
                            </td>
                        </tr>
                    <?php } else if($value['tipo_tabela'] == "strength_assessment_scales") {
                        $strength_assessment_scales = $value; ?>
                        <tr>
                            <td>Escala de Avaliação da Força Muscular</td>
                            <td><?= $strength_assessment_scales->created ?></td>
                            <td><?= $strength_assessment_scales->pontuation ?></td>


                            <td class="actions" style="white-space:nowrap">
                                <?= $this->Html->link(__('Editar'), ['action' => 'edit', $strength_assessment_scales->id], ['class'=>'btn btn-primary btn-xs']) ?>
                            </td>
                        </tr>
                    <?php } else if($value['tipo_tabela'] == "barthel_indexes") {
                        $barthel_indexes = $value; ?>
                        <tr>
                            <td>
                            Barthel: <?= $barthel_indexes->typeBarthelIndexes($barthel_indexes); ?>
                            </td>
                            <td><?= $barthel_indexes->created ?></td>
                            <td><?= $barthel_indexes->somaBarthelIndexes($barthel_indexes); ?></td>


                            <td class="actions" style="white-space:nowrap">
                                <?= $this->Html->link(__('Editar'), ['controller'=>'BarthelIndexes', 'action' => 'edit', $barthel_indexes->id], ['class'=>'btn btn-primary btn-xs']) ?>
                            </td>
                        </tr>
                    <?php } 
                        }
                    }
                ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>

        </div>
    </center>
</div>
</div>


<script >
(function() {
   // your page initialization code here
   // the DOM will be available here
    var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
        array('controller' => 'Users', 'action' => 'login'), array('class'=>'btn btn-default ', 'escape' => false)) ?> ';

    var link2 =' <?= $this->Html->link('Pacientes',['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var link3 =' <?= $this->Html->link('Internações',['controller' => 'Hospitalizations', 'action' => 'index', $hospitalization_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var html = '';
        html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
        html+= link1;
        html+= link2;
        html+= link3;
        html+= '<a href="#" class="breadcumb-active btn btn-default">Fisioterapias</a>';
        html+= '</div>';
            document.getElementById("breadcumb").innerHTML =html;
})();
</script>