
<?php

if ($current_state == 'internacao')
{
    echo $this->element('internacao-menu');
}
else
{
    echo $this->element('screening-menu');
}

$desfecho = ["Alta", "Óbito", "Transferência"];
$caso_confirmado_como = ["Infecção", "Sepse", "Choque séptico", "Afastado infecção / sepse"];

$respiratorio_opt = ['>= 400' => '>= 400', '300 - 399' => '300 - 399', '200 - 299' => '200 - 299', '100 – 199 + Sup. Vent.' => '100 – 199 + Sup. Vent.', '< 100 + Sup. Vent.' => '< 100 + Sup. Vent.'];
$cardiovascular_opt = ['Sem hipotensão' => 'Sem hipotensão', 'PAM < 70 mmHg' => 'PAM < 70 mmHg', 'Em uso de Dobbuamina' => 'Em uso de Dobbuamina', 'Em uso de Nora < 0,1 mcg/kg/min' => 'Em uso de Nora < 0,1 mcg/kg/min', 'Em uso de Nora > 0,1 mcg/kg/min' => 'Em uso de Nora > 0,1 mcg/kg/min'];
$hematologico_opt = ['>= 150' => '>= 150', '100 - 149' => '100 - 149', '50 - 99' => '50 - 99', '20 – 49' => '20 – 49', '< 20' => '< 20'];
$renal_opt = ['< 1,2' => '< 1,2', '1,2 - 1,9' => '1,2 - 1,9', '2,0 - 3,4' => '2,0 - 3,4', '3,5 - 4,9 or < 500ml/24h' => '3,5 - 4,9 or < 500ml/24h', '>= 5,0 ou < 200ml/24h ou Suporte Renal' => '>= 5,0 ou < 200ml/24h ou Suporte Renal'];
$hepatico_opt = ['< 1.2' => '< 1.2', '1.2 – 1.9' => '1.2 – 1.9', '2.0 – 5.9' => '2.0 – 5.9', '6.0-11.9' => '6.0-11.9', '>= 12' => '>= 12'];
$neurologico_opt = ['15' => '15', '13 - 14' => '13 - 14', '10 - 12' => '10 - 12', '6 - 9' => '6 - 9', '< 6' => '< 6'];
?>
<div class="sepseProtocols form col-md-8 columns content">
    <?=$this->Form->create($sepseProtocol)?>
    <fieldset>
        <div class="tabbable-panel">
            <div class="tabbable-line">
                <div class="tab-content">
                    <?php 
                        echo '<legend class="big-title">Internação</legend>';
                    ?>
                    <div class="internacao_em ">
                        <br>

                         <?=$this->Form->input('sector_id', ['empty' => true, 'class' => '', 'label' => ['text' => 'Setor de destino:', 'class' => 'form-input'], 'required'])?>

                        <?=$this->Form->input('avaliacao_3_data', ['type' => 'text', 'class' => 'date', 'label' => ['text' => 'Data de saída:', 'class' => 'form-input']])?>
                        <?=$this->Form->input('avaliacao_3_hora', ['type' => 'text', 'class' => 'time', 'empty' => true, 'label' => ['text' => 'Hora de saída:', 'class' => 'form-input']])?>
                    </div>
                </div>
            </div>
        </div>
        <br>
        <div class="tabbable-panel">
            <div class="tabbable-line">
                <ul class="nav nav-tabs ">
                    <li class="active">
                        <a href="#tab_default_1" data-toggle="tab">
                         Sinais qSOFA
                        </a>
                    </li>
                    <li>
                        <a href="#tab_default_2" data-toggle="tab">
                        Avaliação 1
                        </a>
                    </li>
                    <li>
                        <a href="#tab_default_3" data-toggle="tab">
                        Avaliação 2
                        </a>
                    </li>
                    <li>
                        <a href="#tab_default_4" data-toggle="tab">
                        Avaliação 3
                        </a>
                    </li>
                    <li>
                        <a href="#tab_default_5" data-toggle="tab">
                        SOFA
                        </a>
                    </li>
                    <li>
                        <a href="#tab_default_6" data-toggle="tab">
                        Acompanhamento do protocolo
                        </a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="tab_default_1">
                        <?php
echo '<legend class="big-title">Assinale os sinais qSOFA presentes no paciente:</legend>';
echo $this->Form->input('qsofa_data', ['type' => 'text', 'class' => 'date', 'default' => date("d/m/Y"), 'label' => ['text' => 'Data da avaliação:', 'class' => 'form-input']]);
echo $this->Form->input('qsofa_hora', ['type' => 'text', 'class' => 'time', 'default' => date("H:i"), 'empty' => true, 'label' => ['text' => 'Hora da avaliação:', 'class' => 'form-input']]);

echo '<div class="funkyradio">';
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('hipotensao', ['id' => 'hipotensao']);
echo '<label for="hipotensao">Hipotensão (PA sistólica &lt; 100mmHg)</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('taquipneia', ['id' => 'taquipneia']);
echo '<label for="taquipneia">Taquipnéia &gt; 20 IRM</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('alteracao_estado_mental', ['id' => 'alteracao_estado_mental']);
echo '<label for="alteracao_estado_mental">Alteração do estado mental (sonolência, agitação, alteração comportamental)</label>';
echo "</div>";
echo "</div>";
?>
                    </div>

                    <div class="tab-pane" id="tab_default_2">
                        <legend class="big-title">Avaliação Médica 1 – paciente apresenta história sugestiva de infecção?</legend>
                        <?=$this->Form->input('avaliacao_1_data', ['type' => 'text', 'class' => 'date', 'default' => date("d/m/Y"), 'label' => ['text' => 'Data da avaliação:', 'class' => 'form-input']])?>
                        <?=$this->Form->input('avaliacao_1_hora', ['type' => 'text', 'class' => 'time', 'default' => date("H:i"), 'empty' => true, 'label' => ['text' => 'Hora da avaliação:', 'class' => 'form-input']])?>
                        <div class="funkyradio">
                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('pneumonia', ['id' => 'pneumonia'])?>
                                <label for="pneumonia">Pneumonia/Empiema</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('infeccao_urinaria', ['id' => 'infeccao_urinaria'])?>
                                <label for="infeccao_urinaria">Infecção urinária</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('infeccao_abdominal', ['id' => 'infeccao_abdominal'])?>
                                <label for="infeccao_abdominal">Infecção abdominal aguda</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('meningite', ['id' => 'meningite'])?>
                                <label for="meningite">Meningite</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('endocardite', ['id' => 'endocardite']);?>
                                <label for="endocardite">Endocardite</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('pele_partes_moles', ['id' => 'pele_partes_moles'])?>
                                <label for="pele_partes_moles">Pele e partes moles</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('infeccao_protese', ['id' => 'infeccao_protese'])?>
                                <label for="infeccao_protese">Infecção de prótese</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('infeccao_ossea', ['id' => 'infeccao_ossea'])?>
                                <label for="infeccao_ossea">Infecção óssea/articular</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('infeccao_ferida_operatoria', ['id' => 'infeccao_ferida_operatoria']);?>
                                 <label for="infeccao_ferida_operatoria">Infecção de ferida operatória</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('infeccao_corrente_sanguinea', ['id' => 'infeccao_corrente_sanguinea'])?>
                                <label for="infeccao_corrente_sanguinea">Infecção de corrente sanguínea associada ao cateter</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('sem_foco_definido', ['id' => 'sem_foco_definido'])?>
                            <label for="sem_foco_definido">Sem foco definido</label>
                            </div>
                        </div>
                        <br>

                        <?=$this->Form->input('outras_infeccoes', ['type' => 'textarea', 'class' => '', 'label' => ['text' => 'Outras infecções:', 'class' => 'form-input']])?>
                    </div>

                    <div class="tab-pane " id="tab_default_3">
                            <legend class="big-title">Avaliação Médica 2 – o paciente apresenta critérios para:</legend>
                            <?=$this->Form->input('avaliacao_2_data', ['type' => 'text', 'class' => 'date', 'default' => date("d/m/Y"), 'label' => ['text' => 'Data da avaliação:', 'class' => 'form-input']])?>
                            <?=$this->Form->input('avaliacao_3_hora', ['type' => 'text', 'class' => 'time', 'default' => date("H:i"), 'empty' => true, 'label' => ['text' => 'Hora da avaliação:', 'class' => 'form-input']])?>
                            <div class="funkyradio">
                                <div class="funkyradio-primary">
                                    <?=$this->Form->checkbox('infeccao_nao_complicada', ['id' => 'infeccao_nao_complicada'])?>
                                    <label for="infeccao_nao_complicada">Infecção não complicada</label>
                                </div>

                                <div class="funkyradio-primary">
                                    <?=$this->Form->checkbox('sepse', ['id' => 'sepse'])?>
                                    <label for="sepse">Sepse</label>
                                </div>

                                <div class="funkyradio-primary">
                                    <?=$this->Form->checkbox('choque_septico', ['id' => 'choque_septico'])?>
                                    <label for="choque_septico">Choque séptico</label>
                                </div>

                                <div class="funkyradio-primary">
                                    <?=$this->Form->checkbox('afastado_sepse', ['id' => 'afastado_sepse']);?>
                                    <label for="afastado_sepse">Afastado sepse / choque séptico</label>
                                </div>

                                <div class="funkyradio-primary">
                                    <?=$this->Form->checkbox('sepse_choque_septico', ['id' => 'sepse_choque_septico'])?>
                                    <label for="sepse_choque_septico">Sepse / choque séptico em cuidados de fim de vida sem conduta específica no momento</label>
                                </div>

                                <div class="funkyradio-primary">
                                    <?=$this->Form->checkbox('coletar_exame', ['id' => 'coletar_exame', 'class' => 'active_checked'])?>
                                    <label for="coletar_exame">Coletar exames do kit sepse</label>
                                </div>
                                <div class="hide-element coletar_exame">
                                    <br>
                                    <?=$this->Form->input('coletar_exame_data', ['type' => 'text', 'class' => 'date', 'label' => ['text' => 'Data:', 'class' => 'form-input']])?>
                                    <?=$this->Form->input('coletar_exame_hora', ['type' => 'text', 'class' => 'time', 'label' => ['text' => 'Hora:', 'class' => 'form-input']])?>
                                </div>

                                <div class="funkyradio-primary">
                                    <?=$this->Form->checkbox('preservar_antibio', ['id' => 'preservar_antibio', 'class' => 'active_checked'])?>
                                    <label for="preservar_antibio">Prescrever antibioticoterapia</label>
                                </div>
                                <div class="hide-element preservar_antibio">
                                    <br>
                                    <?=$this->Form->input('preservar_anti_data', ['type' => 'text', 'class' => 'date', 'label' => ['text' => 'Data:', 'class' => 'form-input']])?>
                                    <?=$this->Form->input('preservar_antibio_hora', ['type' => 'text', 'class' => 'time', 'label' => ['text' => 'Hora:', 'class' => 'form-input']])?>
                                </div>

                                <div class="funkyradio-primary">
                                    <?=$this->Form->checkbox('encerrar_atendimento', ['id' => 'encerrar_atendimento', 'class' => 'active_checked']);?>
                                     <label for="encerrar_atendimento">Encerrar o atendimento</label>
                                </div>
                                <div class="hide-element encerrar_atendimento">
                                    <br>
                                    <?=$this->Form->input('encerrar_atendimento_data', ['type' => 'text', 'class' => 'date', 'label' => ['text' => 'Data:', 'class' => 'form-input']])?>
                                    <?=$this->Form->input('encerrar_atendimento_hora', ['type' => 'text', 'class' => 'time', 'label' => ['text' => 'Hora:', 'class' => 'form-input']])?>
                                </div>
                            </div>
                    </div>
                    <div class="tab-pane" id="tab_default_4">
                        <legend class="big-title">
                            Avaliação Médica 3 - após exames, sinalize as disfunções orgânicas
                        </legend>
                        <div class="funkyradio">
                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('paciente_nao_tem_disfuncao', ['id' => 'paciente_nao_tem_disfuncao'])?>
                                <label for="paciente_nao_tem_disfuncao">Paciente não tinha disfunção orgânica, somente infecção</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('pas_menor_que_90', ['id' => 'pas_menor_que_90'])?>
                                <label for="pas_menor_que_90">PAS < 90 mmHg ou PAM 65 mmHg ou queda de PA 40 mmHg</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('relacao_pao', ['id' => 'relacao_pao'])?>
                                <label for="relacao_pao">Relação PaO 2 /FiO 2 300 ou necessidade de O 2 para manter SpO 2 90</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('rebaixamento_do_nivel', ['id' => 'rebaixamento_do_nivel']);?>
                                <label for="rebaixamento_do_nivel">Rebaixamento do nível de consciência</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('creatina', ['id' => 'creatina']);?>
                                <label for="creatina">Creatinina > 2,0 mg/dl ou diurese menor que 0,5ml/Kg/h nas últimas 2 horas</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('bilirrubina', ['id' => 'bilirrubina']);?>
                                <label for="bilirrubina">Bilirrubina > 2mg/dl</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('contagem_de_plaquetas', ['id' => 'contagem_de_plaquetas']);?>
                                <label for="contagem_de_plaquetas">Contagem de plaquetas < 100.000</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('lactato_acima_do_valor', ['id' => 'lactato_acima_do_valor', 'class' => 'active_checked']);?>
                                <label for="lactato_acima_do_valor">Lactato acima do valor de referência</label>
                            </div>
                            <div class="hide-element lactato_acima_do_valor">
                                <br>
                                <?=$this->Form->input('lactato', ['type' => 'text', 'class' => 'calculate-lactato', 'label' => ['text' => 'Lactato:', 'class' => 'form-input']])?>
                                <?=$this->Form->input('lactato_hora', ['type' => 'text', 'class' => 'time calculate-lactato', 'label' => ['text' => 'Horário:', 'class' => 'form-input']])?>
                                <?=$this->Form->input('lactato_data', ['type' => 'text', 'class' => 'date calculate-lactato', 'label' => ['text' => 'Data:', 'class' => 'form-input']])?>


                                <div class="funkyradio-primary">
                                    <?=$this->Form->checkbox('tem_segundo_lactato', ['id' => 'tem_segundo_lactato', 'class' => 'active_checked']);?>
                                    <label for="tem_segundo_lactato">Existe outro lactato</label>
                                </div>
                                <div class="hide-element tem_segundo_lactato">
                                    <br>
                                    <?=$this->Form->input('segundo_lactato', ['type' => 'text', 'class' => 'calculate-lactato', 'label' => ['text' => 'Segundo lactato:', 'class' => 'form-input']])?>
                                    <?=$this->Form->input('segundo_lactato_hora', ['type' => 'text', 'class' => 'time calculate-lactato', 'label' => ['text' => 'Horário:', 'class' => 'form-input']])?>
                                    <?=$this->Form->input('segundo_lactato_data', ['type' => 'text', 'class' => 'date calculate-lactato', 'label' => ['text' => 'Data:', 'class' => 'form-input']])?>
                                </div>
                            </div>

                            <br>
                            <?=$this->Form->input('data_primeira_disfuncao', ['type' => 'text', 'class' => 'date', 'label' => ['text' => 'Data da primeira disfunção orgânica:', 'class' => 'form-input']])?>
                            <?=$this->Form->input('hora_primeira_disfuncao', ['type' => 'text', 'class' => 'time', 'label' => ['text' => 'Hora da primeira disfunção orgânica:', 'class' => 'form-input']])?>
                            <?=$this->Form->input('caso_confirmado_como', ['options' => $caso_confirmado_como, 'class' => '', 'empty' => true, 'label' => ['text' => 'O caso ficou confirmado como:', 'class' => 'form-input']])?>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('coagulopatia', ['id' => 'coagulopatia']);?>
                                <label for="coagulopatia">Coagulopatia (RNI 1,5 ou TTPA 60 seg)</label>
                            </div>

                            <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('liberado_para_tratamento', ['id' => 'liberado_para_tratamento']);?>
                                <label for="liberado_para_tratamento">Liberado para tratamento ambulatorial, caso infecção não complicada</label>
                            </div>

                            <!-- <div class="funkyradio-primary">
                                <?=$this->Form->checkbox('internacao_em', ['id' => 'internacao_em', 'class' => 'active_checked']);?>
                                <label for="internacao_em">Internado*</label>
                            </div> -->


                        </div>
                    </div>
                    <div class="tab-pane" id="tab_default_5">
                        <?php
echo $this->Form->input('sofa_escore.respiratorio', ['class' => 'item1', 'empty' => true, 'options' => $respiratorio_opt, 'label' => ['text' => 'Respiratório (PaO2/FiO2)', 'class' => 'form-input']]);
echo $this->Form->input('sofa_escore.cardiovascular', ['class' => 'item2', 'empty' => true, 'options' => $cardiovascular_opt, 'label' => ['text' => 'Cardiovascular [Drogas Vasoativas (mcg/Kg/min)]', 'class' => 'form-input']]);

echo $this->Form->input('sofa_escore.hematologico', ['class' => 'item3', 'empty' => true, 'options' => $hematologico_opt, 'label' => ['text' => 'Hematológico (Plaquetas x 10³ /mm³)', 'class' => 'form-input']]);

echo $this->Form->input('sofa_escore.renal', ['class' => 'item4', 'empty' => true, 'options' => $renal_opt, 'label' => ['text' => 'Renal (Creatinina mg/dL ou Diurese ml/24h)', 'class' => 'form-input']]);

echo $this->Form->input('sofa_escore.hepatico', ['class' => 'item5', 'empty' => true, 'options' => $hepatico_opt, 'label' => ['text' => 'Hepático (Bilirrubinas Totais mg/dL) ', 'class' => 'form-input']]);

echo $this->Form->input('sofa_escore.neurologico', ['class' => 'item6', 'empty' => true, 'options' => $neurologico_opt, 'label' => ['text' => 'Neurológico (Pontos da Escala de Coma de Glasgow)', 'class' => 'form-input']]);

echo $this->Form->input('sofa_escore.data_de_realizacao', ['class' => 'date', 'default' => date('d/m/Y'), 'type' => 'text', 'label' => ['text' => 'Data de Realização:', 'class' => 'form-input']]);
echo $this->Form->hidden('sofa_escore.hospitalization_id', ['value' => $hospitalization_id]);
echo $this->Form->input('sofa_escore.pontuation', ['class' => "hide", 'label' => false, 'id' => 'pontuation-id']);
?>
                        <h3 id="pontuation">Pontuação Total:</h3>
                    </div>

                    <div class="tab-pane" id="tab_default_6">
                        <?=$this->Form->input('reconhecimento_sepse_data', ['type' => 'text', 'class' => 'date', 'label' => ['text' => 'Data de reconhecimento da sepse:', 'class' => 'form-input']])?>
                        <?=$this->Form->input('reconhecimento_sepse_hora', ['type' => 'text', 'class' => 'time', 'label' => ['text' => 'Hora de reconhecimento da sepse:', 'class' => 'form-input']])?>

                        <?=$this->Form->input('hemocultura_data', ['type' => 'text', 'class' => 'date', 'label' => ['text' => 'Data da hemocultura:', 'class' => 'form-input']])?>
                        <?=$this->Form->input('hemocultura_hora', ['type' => 'text', 'class' => 'time', 'label' => ['text' => 'Hora da hemocultura:', 'class' => 'form-input']])?>

                        <?=$this->Form->input('reconhecimento_sepse_data', ['type' => 'text', 'class' => 'date', 'label' => ['text' => 'Data da antibioticoterapia:', 'class' => 'form-input']])?>
                        <?=$this->Form->input('reconhecimento_sepse_data', ['type' => 'text', 'class' => 'time', 'label' => ['text' => 'Hora da antibioticoterapia:', 'class' => 'form-input']])?>

                        <?=$this->Form->input('data_lactato_inicial', ['type' => 'text', 'class' => 'date', 'label' => ['text' => 'Data do lactato inicial:', 'class' => 'form-input']])?>
                        <?=$this->Form->input('hora_lactato_inicial', ['type' => 'text', 'class' => 'time', 'label' => ['text' => 'Hora do lactato inicial:', 'class' => 'form-input']])?>

                        <?=$this->Form->input('data_lactato_final', ['type' => 'text', 'class' => 'date', 'label' => ['text' => 'Data do segundo lactato:', 'class' => 'form-input']])?>
                        <?=$this->Form->input('hora_lactato_final', ['type' => 'text', 'class' => 'time', 'label' => ['text' => 'Hora do segundo lactato:', 'class' => 'form-input']])?>

                        <?=$this->Form->input('classificacao', ['type' => 'text', 'class' => '', 'label' => ['text' => 'Classificação (Infecção / Sepse / Choque):', 'class' => 'form-input']])?>

                        <?=$this->Form->input('dummy', ['type' => 'text', 'class' => '', 'label' => ['text' => 'Pontuação mínima do SOFA Score na internação:', 'class' => 'form-input']])?>

                        <?=$this->Form->input('delta_de_cultura', ['type' => 'text', 'class' => '', 'label' => ['text' => 'Delta de cultura:', 'class' => 'form-input']])?>

                        <?=$this->Form->input('pontuacao_sofa_d1_score', ['type' => 'text', 'class' => '', 'label' => ['text' => 'Pontuação do SOFA D1 Score (primeira pontuação):', 'class' => 'form-input']])?>

                        <?=$this->Form->input('taxa_clareamento_lactato', ['type' => 'text', 'class' => '', 'label' => ['text' => 'Taxa de Clareamento do Lactato (2º Lactato / 1º Lactato ) x 100:', 'class' => 'form-input']])?>

                        <?=$this->Form->input('pontuacao_maxima_sofa', ['type' => 'text', 'class' => '', 'label' => ['text' => 'Pontuação Máxima do SOFA Score (máxima pontuação feita na internação) :', 'class' => 'form-input']])?>

                        <?=$this->Form->input('desfecho', ['type' => 'text', 'class' => '', 'options' => $desfecho, 'label' => ['text' => 'Desfecho:', 'class' => 'form-input']])?>


                        <?=$this->Form->input('delta_de_antibiotico', ['type' => 'text', 'class' => '', 'label' => ['text' => 'Delta de antibiótico:', 'class' => 'form-input']])?>

                        <?=$this->Form->input('data_alta_uti', ['type' => 'text', 'class' => 'date', 'label' => ['text' => 'Data de alta UTI:', 'class' => 'form-input']])?>
                        <?=$this->Form->input('data_alta_hospitalar', ['type' => 'text', 'class' => 'date', 'label' => ['text' => 'Data de alta hospitalar:', 'class' => 'form-input']])?>
                    </div>

                    <?php

if ($current_state == 'internacao')
{
    echo $this->Form->hidden('hospitalization_id', ['value' => $hospitalization_id, 'id' => 'hospitalization_id']);
}
else
{
    echo $this->Form->hidden('screening_id', ['value' => $screening_id, 'id' => 'screening_id']);
}

?>
                    <br><br><br><br>
                    <button type="button" class="btn btn-danger" onclick="goBack()">Cancelar</button>
                    <?=$this->Form->button(__('Salvar'))?>
                    <?=$this->Form->end()?>
                </div>
            </div>
        </div>

    </fieldset>
</div>

<script>
    $( document ).ready(function()
    {
        /*$("button[type='submit']").click(function()
        {
            console.log("a");
            var sector_id = $("#sector-id").val();
            var hospitalization_id = $("#hospitalization_id").val();

            if (sector_id === "" && hospitalization_id !== "")
            {
                $('a[href="#tab_default_4"]').tab('show');
                //alert("preencha campos obrigatórios");
                return false;
            }
            else
            {
                return true;
            }
        });*/
    });

    function calculateLactato()
    {
        var segundo_lactato = parseInt( $("#segundo-lactato").val() );
        var primeior_lactato = parseInt( $("#lactato").val() );

        if (!isNaN(segundo_lactato) && !isNaN(primeior_lactato))
        {

            var total = (segundo_lactato / primeior_lactato) * 100;
            $("#taxa-clareamento-lactato").val(total);
        }


        $("#data-lactato-inicial").val( $("#lactato-data").val() );
        $("#hora-lactato-inicial").val( $("#lactato-hora").val() );

        $("#hora-lactato-final").val( $("#segundo-lactato-hora").val() );
        $("#data-lactato-final").val( $("#segundo-lactato-data").val() );
    }

    $(".calculate-lactato").change(function()
    {
        calculateLactato();
    });

    $("#caso-confirmado-como").change(function()
    {
        $("#classificacao ").val($("#caso-confirmado-como option:selected").text());
    });

    $('select').change(function()
    {
    var pontuation = 0;
    //console.log($(elem).val());

    $( "select" ).each(function( index )
    {
        if ($( this ).hasClass( "item1" ))
        {
            switch($(this).val())
            {
              case '300 - 399':
                  pontuation += 1;
                  break;
              case '200 - 299':
                  pontuation += 2;
                  break;
              case '100 – 199 + Sup. Vent.':
                  pontuation += 3;
                  break;
              case '< 100 + Sup. Vent.':
                pontuation += 4;
                break;
            }
        }
        else if ($( this ).hasClass( "item2" ))
        {
            switch($(this).val())
            {
              case 'PAM < 70 mmHg':
                pontuation += 1;
                break;
             case 'Em uso de Dobbuamina':
                  pontuation += 3;
                  break;
              case 'Em uso de Nora < 0,1 mcg/kg/min':
                  pontuation += 2;
                  break;
              case 'Em uso de Nora > 0,1 mcg/kg/min':
                pontuation += 4;
                break;
            }
        }
        else if ($( this ).hasClass( "item3" ))
        {
            switch($(this).val())
            {
              case '100 - 149':
                pontuation += 1;
                break;
              case '50 - 99':
                  pontuation += 2;
                  break;
              case '20 – 49':
                  pontuation += 3;
                  break;
              case '< 20':
                pontuation += 4;
                break;

            }
        }
        else if ($( this ).hasClass( "item4" ))
        {
            switch($(this).val())
            {
              case '1,2 - 1,9':
                pontuation += 1;
                break;
              case '2,0 - 3,4':
                pontuation += 2;
                break;
              case '3,5 - 4,9 or < 500ml/24h':
                pontuation += 3;
                break;
              case '>= 5,0 ou < 200ml/24h ou Suporte Renal':
                pontuation += 4;
                break;
            }
        }
        else if ($( this ).hasClass( "item5" ))
        {
            switch($(this).val())
            {
              case '1,2 - 1,9':
                pontuation += 1;
                break;
              case '2.0 – 5.9':
                pontuation += 2;
                break;
              case '6.0-11.9':
                pontuation += 3;
                break;
              case '>= 12':
                pontuation += 4;
                break;
            }
        }
        else if ($( this ).hasClass( "item6" ))
        {
            switch($(this).val())
            {
              case '13 - 14':
                pontuation += 1;
                break;
              case '10 - 12':
                pontuation += 2;
                break;
              case '6 - 9':
                pontuation += 3;
                break;
              case '< 6':
                pontuation += 4;
                break;
            }
        }
    });

  $('#pontuation').text("Pontuação Total: "+ pontuation );
  $('#pontuacao').val(pontuation);
  $('#pontuation-id').val(pontuation);
});

</script>


<?php

if ($current_state == "internacao"): ?>
<script >
    (function() {
       // your page initialization code here
       // the DOM will be available here
        var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
    ['controller' => 'Users', 'action' => 'login'], ['class' => 'btn btn-default ', 'escape' => false])?> ';

        var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

        var link3 =' <?=$this->Html->link('Internação', ['controller' => 'Hospitalizations', 'action' => 'edit', $hospitalization_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

        var link4 =' <?=$this->Html->link('Protocolos', ['controller' => 'SepseProtocols', 'action' => 'index', $hospitalization_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

        var html = '';
            html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
            html+= link1;
            html+= link2;
            html+= link3;
            html+= link4;
            html+= '<a href="#" class="breadcumb-active btn btn-default">Protocolo de Sepse</a>';
            html+= '</div>';
                document.getElementById("breadcumb").innerHTML =html;
    })();
</script>

<?php else: ?>
<script >
    (function() {
       // your page initialization code here
       // the DOM will be available here
       var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
    ['controller' => 'Users', 'action' => 'login'], ['class' => 'btn btn-default ', 'escape' => false])?> ';

       var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

       var link3 =' <?=$this->Html->link('Triagem', ['controller' => 'Screenings', 'action' => 'edit', $screening_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

        var link4 =' <?=$this->Html->link('Protocolos', ['controller' => 'SepseProtocols', 'action' => 'index', $screening_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

        var html = '';
            html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
            html+= link1;
            html+= link2;
            html+= link3;
            html+= link4;
            html+= '<a href="#" class="breadcumb-active btn btn-default">Protocolo de Sepse</a>';
            html+= '</div>';
                document.getElementById("breadcumb").innerHTML =html;
    })();
</script>
<?php endif;?>
