<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('New Risk Factor'), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List Clinic Tev Protocols'), ['controller' => 'ClinicTevProtocols', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New Clinic Tev Protocol'), ['controller' => 'ClinicTevProtocols', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="riskFactors index large-9 medium-8 columns content">
    <h3><?= __('Risk Factors') ?></h3>
    <table cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('nome') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($riskFactors as $riskFactor): ?>
            <tr>
                <td><?= $this->Number->format($riskFactor->id) ?></td>
                <td><?= h($riskFactor->nome) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $riskFactor->id]) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $riskFactor->id]) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $riskFactor->id], ['confirm' => __('Are you sure you want to delete # {0}?', $riskFactor->id)]) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
        </ul>
        <p><?= $this->Paginator->counter() ?></p>
    </div>
</div>
