<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <?=  $this->Html->css('pdf', ['fullBase' => true]); ?>
        <?= $this->fetch('css') ?>
    </head>
    <body>
    <?= $this->element( 'header-logo', ['report_title'=>'Relatório de Centro Cirúrgico'] ); ?> 
       <div class="container">
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>  
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-right">Valor</th>                   
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td >Tempo médio de cadastro de cirurgia e liberação da cirurgia</td>
                        <td> <?= $surgeries['totalTempoMedia'] ?> </td>
                    </tr>
                    <tr>
                         <td class="title" style="font-weight: bold" colspan="2">Tempo médio de cadastro de cirurgia e liberação da cirurgia por tipo de cirurgia</td>
                         <!-- <td ></td> -->
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['tipoCirurgia'] as $key => $tipoCirurgia) {
                            $html .= '<tr class="tr-indent">';
                            $html .= '<td>&#8226; ' . $tipoCirurgia['nome'] . '</td>';
                            $html .= '<td>' . $tipoCirurgia['mediaTotalDiasTipo'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>
                    <tr>
                         <td class="title" style="font-weight: bold" colspan="2">Tempo médio de cadastro de cirurgia e liberação da cirurgia por porte de cirurgia</td>
                         <!-- <td ></td> -->
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['porte'] as $key => $porte) {
                            //echo 'porte = ' . $key;
                            //echo "<pre>";
                            //print_r($porte);
                            $html .= '<tr>';
                            $html .= '<td>&#8226; ' . $key . '</td>';
                            $html .= '<td>' . $porte['mediaDiasPorte'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>
                    <tr>
                         <td class="title" style="font-weight: bold" colspan="2">Tempo médio de cadastro de cirurgia e liberação da cirurgia por convênio</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['convenio'] as $key => $convenio) {
                            $html .= '<tr>';
                            $html .= '<td>&#8226; ' . $key . '</td>';
                            $html .= '<td>' . $convenio['totalDiasConvenio'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td >Tempo médio de cadastro de cirurgia e realização da cirurgia por cirurgia</td>
                        <td> <?= $surgeries['cirurgia_cadastro_realizado']['totalTempoMedia'] ?> </td>
                    </tr>
                    <tr>
                         <td class="title" style="font-weight: bold" colspan="2">Tempo médio de cadastro de cirurgia e realização da cirurgia por tipo de cirurgia</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['cirurgia_cadastro_realizado'] as $key => $cirurgia_cadastro_realizado) {
                            if($key == 'tipoCirurgia'){                                
                                foreach ($cirurgia_cadastro_realizado as $key2 => $tipoCirurgia) {
                                    $html .= '<tr>';
                                    $html .= '<td>&#8226; ' . $tipoCirurgia['nome'] . '</td>';
                                    $html .= '<td>' . $tipoCirurgia['media'] . '</td>';
                                    $html .= '</tr>';
                                }
                            }
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Tempo médio de cadastro de cirurgia e realização da cirurgia por porte de cirurgia</td>
                    </tr>

                    <?php 
                        $html = '';
                        foreach ($surgeries['cirurgia_cadastro_realizado'] as $key => $cirurgia_cadastro_realizado) {
                            if($key == 'porte'){                                
                                foreach ($cirurgia_cadastro_realizado as $key3 => $porte) {
                                    $html .= '<tr>';
                                    $html .= '<td>&#8226; ' . $key3 . '</td>';
                                    $html .= '<td>' . $porte['media'] . '</td>';
                                    $html .= '</tr>';
                                }
                            }
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Tempo médio de cadastro de cirurgia e realização da cirurgia por convenio</td>
                    </tr>

                    <?php 
                        $html = '';
                        foreach ($surgeries['cirurgia_cadastro_realizado'] as $key => $cirurgia_cadastro_realizado) {
                            if($key == 'convenio'){                                
                                foreach ($cirurgia_cadastro_realizado as $key4 => $convenio) {
                                    $html .= '<tr>';
                                    $html .= '<td>&#8226; ' . $key4 . '</td>';
                                    $html .= '<td>' . $convenio['media'] . '</td>';
                                    $html .= '</tr>';
                                }
                            }
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td >Taxa de cancelamento de cirurgia eletiva</td>
                        <td> <?= $surgeries['taxaCancelamentoCirurgia'] ?> </td>
                    </tr>
                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Cancelamento de cirurgia por tipo de cirurgia</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['tipoCirurgia'] as $key => $tipoCirurgia) {
                            $html .= '<tr class="tr-indent">';
                            $html .= '<td>&#8226; ' . $tipoCirurgia['nome'] . '</td>';
                            $html .= '<td>' . $tipoCirurgia['cancelamento'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>
                    
                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Cancelamento de cirurgia por porte de cirurgia</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['porte'] as $key => $porte) {
                            $html .= '<tr class="tr-indent">';
                            $html .= '<td>&#8226; ' . $key . '</td>';
                            $html .= '<td>' . $porte['cancelamento'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Cancelamento de cirurgia por convenio</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['convenio'] as $key => $convenio) {
                            $html .= '<tr class="tr-indent">';
                            $html .= '<td>&#8226; ' . $key . '</td>';
                            $html .= '<td>' . $convenio['cancelamento'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td >Taxa de atraso da cirurgia</td>
                        <td> <?= $surgeries['tempoTotalAtrasoCirurgia'] ?> </td>
                    </tr>

                    <tr>
                        <td >Tempo médio de atraso de cirurgia</td>
                        <td> <?= $surgeries['tempoMedioAtrasoCirurgia'] ?> </td>
                    </tr>
                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Tempo médio de atraso de cirurgia por porte de cirurgia</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['porte'] as $key => $porte) {
                            $html .= '<tr class="tr-indent">';
                            $html .= '<td>&#8226; ' . $key . '</td>';
                            $html .= '<td>' . $porte['tempoMedioAtrasoCirurgia'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Tempo médio de atraso de cirurgia por convenio</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['convenio'] as $key => $convenio) {
                            $html .= '<tr class="tr-indent">';
                            $html .= '<td>&#8226; ' . $key . '</td>';
                            $html .= '<td>' . $convenio['tempoMedioAtrasoCirurgia'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Tempo médio de atraso de cirurgia por tipo de cirurgia</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['tipoCirurgia'] as $key => $tipoCirurgia) {
                            $html .= '<tr class="tr-indent">';
                            $html .= '<td>&#8226; ' . $key . '</td>';
                            $html .= '<td>' . $porte['tempoMedioAtrasoCirurgia'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Tempo médio de atraso de cirurgia por dia de semana</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['diaDeSemana'] as $key => $diaDeSemana) {
                            $html .= '<tr class="tr-indent">';
                            $html .= '<td>&#8226; ' . $key . '</td>';
                            $html .= '<td>' . $diaDeSemana['media'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>

                <tbody>
            </table>
        </div>
    </body>
</html>