<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <?=$this->Html->css('pdf', ['fullBase' => true]);?>
        <?=$this->fetch('css')?>
</head>

<body>
    <?= $this->element('header-logo', ['report_title' => 'Relatório CCIH']) ;?>
        <div class="container">

            <table class="aileron_thin limit-first-td" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Valor</th>
                        <th class="title th-right">%</th>
                    </tr>
                </thead>

                <tbody>
                    <tr>
                        <td>Admissão com infecção</td>
                        <td>0</td>
                        <td>0% </td>
                    </tr>

                    <!-- <tr>
                        <td class="title" style="font-weight: bold" colspan="3">Gravidade das infecções</td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Sepse</td>
                        <td>
                            <?=$data['hospital']['gravidade_sepse']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gravidade_sepse']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Infecção</td>
                        <td>
                            <?=$data['hospital']['gravidade_infeccao']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gravidade_infeccao']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Choque</td>
                        <td>
                            <?=$data['hospital']['gravidade_choque']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gravidade_choque']?>% </td>
                    </tr> -->

                    <tr>
                        <td class="title" style="font-weight: bold" colspan="3">Tipo de infecções</td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Nosocomial</td>
                        <td>
                            <?=$data['hospital']['classificacao_nosocomial']?>
                        </td>
                        <td>
                            <?=$data['hospital']['classificacao_nosocomial']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Nosocomial de outra unidade</td>
                        <td>
                            <?=$data['hospital']['classificacao_nosocomial_de']?>
                        </td>
                        <td>
                            <?=$data['hospital']['classificacao_nosocomial_de']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Comunitária</td>
                        <td>
                            <?=$data['hospital']['classificacao_comunitaria']?>
                        </td>
                        <td>
                            <?=$data['hospital']['comprovacao_microbiologica_percentual']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Sem identificação</td>
                        <td>
                            <?=$data['hospital']['sem_identificacao']?>
                        </td>
                        <td>
                            <?=$data['hospital']['sem_identificacao']?>% </td>
                    </tr>


                    <!-- <tr>
                    <td colspan="3">
                        <table class="aileron_thin limit-first-td" style="width:100%">
                            <thead>
                                <tr>
                                    <th colspan="2">Tabela comprovação microbiológica por sítio</th>
                                </tr>
                                <tr>
                                    <th>Item</th>
                                    <th>Valor</th>
                                </tr>
                            </thead>

                            <tbody>
                                <tr>
                                    <td>Meningite</td>
                                    <td><?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?></td>
                                </tr>

                            </tbody>
                        </table>
                    </td>
                </tr> -->

                    <tr>
                        <td>Germe gram positivo</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Sitio encontrado (gram positivo)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Resistente sim (gram positivo)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>%</td>
                    </tr>

                    <tr>
                        <td>Germe gram negativo</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Sitio encontrado (gram negativo)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Resistente sim (gram negativo)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Multiresistente sim (gram negativo)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Germe fungo</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Sitio encontrado (germe fungo)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Resistente sim (germe fungo)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Vírus</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Sitio encontrado (vírus)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Tuberculose</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Sitio encontrado (tuberculose)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Resistente sim (tuberculose)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Paciente com mais de um germe na internação</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>


                </tbody>

                <?php
$arr = [

    "Tabela comprovação microbiológica por sítio",
    "Tabela comprovação microbiológica por gravidade de infecçòes",
    "Tabela comprovação microbiológica por tipo de infecçòes",
    "Tabela sitio e gravidade de infecção",
    "Tabela sitio e gravidade de infecção",
    "Tabela gravidade de tipo de infecção",
    "Tabela entre colunas os tipos de infecções e linha gram positivo",
    "Tabela entre colunas as gravidades de infecções e linha gram positivo",
    "Tabela  gram positivo resistente por origem de infecção",
    "Tabela  gram positivo resistente por tipo de infecção",
    "Tabela  gram positivo resistente por gravidade de infecção",
    "Tabela entre colunas os tipos de infecções e linha gram positivo",
    "Tabela entre colunas as gravidades de infecções e linha gram positivo",
    "Tabela  gram negativo resistente por origem de infecção",
    "Tabela  gram negativo resistente por tipo de infecção",
    "Tabela  gram negativo resistente por gravidade de infecção",
    "Tabela  gram negativo multiresistente por origem de infecção",
    "Tabela  gram negativo multiresistente por tipo de infecção",
    "Tabela  gram negativo multiresistente por gravidade de infecção",
    "Tabela entre colunas os tipos de infecções e linha fungos",
    "Tabela entre colunas as gravidades de infecções e linha fungos",
    "Tabela  fungos resistentes por origem de infecção",
    "Tabela  fungos resistentes por tipo de infecção",
    "Tabela  fungos resistentes por gravidade de infecção",
    "Tabela entre colunas os tipos de infecções e linha vírus",
    "Tabela entre colunas as gravidades de infecções e linha vírus",
    "Tabela entre colunas os tipos de infecções e linha tuberculose",
    "Tabela entre colunas as gravidades de infecções e linha tuberculose",
    "Cada tipo de germe gram positivo valor absoluto e percentual entre gram positivo",
    "Cada tipo de germe gram positivo multiresistente: valor absoluto e percentual entre gram positivo",
    "Tabela cada gram positivo e sitio de infecção",
    "Tabela cada gram positivo e tipo de infecção",
    "Tabela cada gram positivo e gravidade de infecção",
    "Tabela cada gram positivo resistente e sitio de infecção",
    "Tabela cada gram positivo resistente e tipo de infecção",
    "Tabela cada gram positivo resistente e gravidade de infecção",
    "Cada tipo de germe gram negativo valor absoluto e percentual entre gram negativo",
    "Cada tipo de germe gram negativo multiresistente: valor absoluto e percentual entre gram negativo",
    "Tabela cada gram negativo e sitio de infecção",
    "Tabela cada gram negativo e tipo de infecção",
    "Tabela cada gram negativo e gravidade de infecção",
    "Tabela cada gram negativo resistente e sitio de infecção",
    "Tabela cada gram negativo resistente e tipo de infecção",
    "Tabela cada gram negativo resistente e gravidade de infecção",
    "Tabela cada gram negativo multiresistente e sitio de infecção",
    "Tabela cada gram negativo multiresistente e tipo de infecção",
    "Tabela cada gram negativo multiresistente e gravidade de infecção",
    "Coinfecção: valor absoluto e percentual de infecções",
    "Paciente com mais de um germe na internação: valor absoluto de pacientes e percentual de pacientes com infecção",
    "Paciente com mais de um germe na internação: média de germes, valor máximo",
    "Paciente com mais de um germe na internação: tempo médio entre detecção dos germes, tempo máximo e tempo mínimo"];
?>

            </table>

        <div style="page-break-after:always;"></div>

        <!-- Gravidade de infecção  INIT -->
        <!-- <p style="text-align: center" class='title-dark f-size-32 underline_text'> Gravidade de infecção </p> -->
        <table class="aileron_thin limit-first-td" style="width:100%; border-collapse: collapse; border: 1px solid #fff;">
            <thead>
                <tr>
                    <th style="border-bottom: 1px solid #fff; background-color: #fff" colspan=3> Gravidade de infecção  </th>
                </tr>
                <tr>                    
                    <th class="title th-left">Item</th>
                    <th class="title th-middle">Valor</th>
                    <th class="title th-right">%</th>
                </tr>
            </thead>
            <tbody>
                <tr >
                    <td> Sepse</td>
                    <td>
                        <?=$data['hospital']['gravidade_sepse']?>
                    </td>
                    <td>
                        <?=$data['hospital']['gravidade_sepse']?>% </td>
                </tr>

                <tr >
                    <td>Infecção</td>
                    <td>
                        <?=$data['hospital']['gravidade_infeccao']?>
                    </td>
                    <td>
                        <?=$data['hospital']['gravidade_infeccao']?>% </td>
                </tr>

                <tr >
                    <td> Choque</td>
                    <td>
                        <?=$data['hospital']['gravidade_choque']?>
                    </td>
                    <td>
                        <?=$data['hospital']['gravidade_choque']?>% </td>
                </tr>
            </tbody>
        </table>
        
        <br><br>

        <table class="aileron_thin limit-first-td" style="width:100%; border-collapse: collapse; border: 0 solid #fff;">
            <thead>
                <tr >
                    <th style="border-bottom: 1px solid #fff; background-color: #fff" colspan="4">Tabela de gravidade por tipo de infecções</th>
                </tr >
                <tr>
                    <th class="title th-left">Item</th>
                    <th class="title th-right">Infecção</th>
                    <th class="title th-right">Sepse</th>
                    <th class="title th-right">Choque</th>
                </tr>
            </thead>

            <tbody>
                <tr>
                    <td>Meningite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['meningite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['meningite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Encefalite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['encefalite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['encefalite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['encefalite']?>
                    </td>
                </tr>
                <tr>
                    <td>Meningoencefalite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['meningoencefalite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['meningoencefalite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['meningoencefalite']?>
                    </td>
                </tr>
                <tr>
                    <td>Sinusite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['sinusite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['sinusite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['sinusite']?>
                    </td>
                </tr>
                <tr>
                    <td>Mastoidite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['mastoidite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['mastoidite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['mastoidite']?>
                    </td>
                </tr>
                <tr>
                    <td>Otite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['otite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['otite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['otite']?>
                    </td>
                </tr>
                <tr>
                    <td>Celulite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['celulite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['celulite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['celulite']?>
                    </td>
                </tr>
                <tr>
                    <td>Amigdalite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['amigdalite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['amigdalite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['amigdalite']?>
                    </td>
                </tr>
                <tr>
                    <td>Laringite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['laringite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['laringite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['laringite']?>
                    </td>
                </tr>
                <tr>
                    <td>TraqueÍte</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['traqueite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['traqueite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['traqueite']?>
                    </td>
                </tr>
                <tr>
                    <td>Pneumonia</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['pneumonia']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['pneumonia']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['pneumonia']?>
                    </td>
                </tr>
                <tr>
                    <td>Endocardite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['endocardite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['endocardite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['endocardite']?>
                    </td>
                </tr>
                <tr>
                    <td>Infecção de Corrente sanguínea</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['infeccao_corrente']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['infeccao_corrente']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['infeccao_corrente']?>
                    </td>
                </tr>
                <tr>
                    <td>Mediastinite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['mediastinite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['mediastinite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['mediastinite']?>
                    </td>
                </tr>
                <tr>
                    <td>Gastroenterite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['gastroenterite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['gastroenterite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['gastroenterite']?>
                    </td>
                </tr>
                <tr>
                    <td>Hepatite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['hepatite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['hepatite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['hepatite']?>
                    </td>
                </tr>
                <tr>
                    <td>Pancreatite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['pancreatite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['pancreatite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['pancreatite']?>
                    </td>
                </tr>
                <tr>
                    <td>Peritonite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['peritonite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['peritonite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['peritonite']?>
                    </td>
                </tr>
                <tr>
                    <td>Infecção urinária</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['infeccao_urinaria']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['infeccao_urinaria']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['infeccao_urinaria']?>
                    </td>
                </tr>
                <tr>
                    <td>Infecção pélvica</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['infeccao_pelvica']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['infeccao_pelvica']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['infeccao_pelvica']?>
                    </td>
                </tr>
                <tr>
                    <td>Piodermite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['piodermite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['piodermite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['piodermite']?>
                    </td>
                </tr>
                <tr>
                    <td>Foliculite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['foliculite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['foliculite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['foliculite']?>
                    </td>
                </tr>
                <tr>
                    <td>Fasciíte</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['fasciite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['fasciite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['fasciite']?>
                    </td>
                </tr>
                <tr>
                    <td>Úlcera Infectada</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['ulcera_infectada']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['ulcera_infectada']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['ulcera_infectada']?>
                    </td>
                </tr>
                <tr>
                    <td>Abcesso -> este solicitar o local</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['abcesso']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['abcesso']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['abcesso']?>
                    </td>
                </tr>
                <tr>
                    <td>Ostemielite</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['ostemielite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['ostemielite']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['ostemielite']?>
                    </td>
                </tr>
                <tr>
                    <td>Artrite séptica</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['artrite_septica']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['artrite_septica']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['artrite_septica']?>
                    </td>
                </tr>
                <tr>
                    <td>Tuberculose Pulmonar</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['tuberculose_pulmonar']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['tuberculose_pulmonar']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['tuberculose_pulmonar']?>
                    </td>
                </tr>
                <tr>
                    <td>Herpes Zoster</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['herpes_zoster']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['herpes_zoster']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['herpes_zoster']?>
                    </td>
                </tr>
                <tr>
                    <td>Outros</td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['infeccao']['outros']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['sepse']['outros']?>
                    </td>
                    <td>
                        <?=$data['hospital']['tab_gravidade_tipo']['choque']['outros']?>
                    </td>
                </tr>
            </tbody>
        </table>
        <!-- Gravidade de infecção  END -->

        <div style="page-break-after:always;"></div>
    

        <!-- Comprovação biológica INIT -->
        <p style="text-align: center" class='title-dark f-size-32 underline_text'> Comprovação biológica</p>
        <table class="aileron_thin limit-first-td" style="width:100%; border-collapse: collapse; border: 1px solid #fff;">
            <thead>
                <tr>
                    <th class="title th-left">Item</th>
                    <th class="title th-middle">Valor</th>
                    <th class="title th-right">%</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Comprovação microbiológica</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_total']?>
                    </td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_percentual']?>% </td>
                </tr>
            </tbody>
        </table>
        
        <br><br>

        <table class="aileron_thin limit-first-td" style="width:100%; border-collapse: collapse; border: 0 solid #fff;">
            <thead>
                <tr >
                    <th style="border-bottom: 1px solid #fff" colspan="2">Tabela de comprovação microbiológica por gravidade de infecções</th>
                </tr >
                <tr>
                    <th class="title th-left">Item</th>
                    <th class="title th-right">Valor</th>
                </tr>
            </thead>

            <tbody>
                <tr>
                    <td>Infecção</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_gravidade']['infeccao']?>
                    </td>
                </tr>
                <tr>
                    <td>Sepse</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_gravidade']['sepse']?>
                    </td>
                </tr>
                <tr>
                    <td>Choque</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_gravidade']['choque']?>
                    </td>
                </tr>
            </tbody>
        </table>        

        <br><br>

        <table class="aileron_thin limit-first-td" style="width:100%; border-collapse: collapse; border: 0 solid #fff;">
            <thead>
                <tr >
                    <th style="border-bottom: 1px solid #fff" colspan="2">Tabela de comprovação microbiológica por tipo de infecção</th>
                </tr >
                <tr>
                    <th class="title th-left">Item</th>
                    <th class="title th-right">Valor</th>
                </tr>
            </thead>

            <tbody>
                <tr>
                    <td>Meningite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Encefalite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['encefalite']?>
                    </td>
                </tr>
                <tr>
                    <td>Meningoencefalite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Sinusite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Mastoidite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Otite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Celulite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Amigdalite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Laringite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>TraqueÍte</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Pneumonia</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Endocardite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Infecção de Corrente sanguínea</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Gastroenterite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Hepatite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Pancreatite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Peritonite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Infecção urinária</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Infecção pélvica</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Piodermite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Foliculite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Fasciíte</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Úlcera Infectada</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Abcesso -> este solicitar o local</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Ostemielite</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Artrite séptica</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Tuberculose Pulmonar</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Herpes Zoster</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
                <tr>
                    <td>Outros</td>
                    <td>
                        <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                    </td>
                </tr>
            </tbody>
        </table>        

        <!-- Comprovação biológica END -->


    </div>
</body>
</html>