<?php

   if ($current_state == 'internacao') {
       echo $this->element('internacao-menu');
   } else {
       echo $this->element('screening-menu');
   }

   $from = $selected_patient_birthday;
   $to = new DateTime('today');
   $age = $from->diff($to)->y;
?>


<div  class="prescriptions form col-md-9 columns content">

         <div class="patient-info">
            <h4>Nome da Prescrição: <?= $prescription['name']; ?> </h4>
            <?php
              $sectors = '';
              foreach ($prescription['avaiable_sectors'] as $key => $sector) {
                $sectors .= ($key == 0) ? $sector['name'] : ' - '.$sector['name'];
              }
            ?>

            <h4>Setores: <?= $sectors ?> </h4>
         </div>

         <div style="margin-bottom:50px;">
            <table class="table table-striped table-hover" id="medications-table">

                  <thead>
                      <tr>
                          <th>Medicamento / Procedimento / Exame</th>
                          <th>Quantidade</th>
                          <th>Via de Administração</th>
                          <th>Frequência</th>
                      </tr>
                  </thead>

                  <tbody id='tbody'>

                        <?php
                           if (!empty($prescription['prescription_medications'])):
                              foreach ($prescription['prescription_medications'] as $key => $medication):

                        ?>
                              <tr class="medication-data-<?=$key?> input-row">

                                <td class="medication-name input-tds">
                                   <p><?= $medication['system_medication']['name']; ?></p>
                                </td>

                                <td class="medication-quantity input-tds">
                                   <p><?= $medication['quantity']; ?></p>
                                </td>

                                <td class="medication-channel input-tds">
                                   <p><?= $medication['channel']; ?></p>
                                 </td>

                                 <td class="medication-frequency input-tds">
                                    <p><?= $medication['frequency']; ?></p>
                                 </td>

                              </tr>

                        <?php
                              endforeach;
                           endif;
                        ?>

                  </tbody>
            </table>
         </div>
         <div class="action-buttons-div">
           <button type="button" class="btn btn-danger" onclick="goBack()">Voltar</button>
         </div>
</div>

<script>

   <?php

   if ($current_state == "internacao"): ?>
           (function() {
              // your page initialization code here
              // the DOM will be available here

              var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
                   ['controller' => 'Users', 'action' => 'login'],
                   ['class' => 'btn btn-default ', 'escape' => false]
               )?>';

              var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

              var link3 =' <?=$this->Html->link('Internação', ['controller' => 'hospitalizations', 'action' => 'edit', $hospitalization_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var link4 =' <?=$this->Html->link('Prescrições', ['controller' => 'Prescriptions', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var html = '';
                   html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                   html+= link1;
                   html+= link2;
                   html+= link3;
                   html+= link4;
                   html+= '<a href="#" class="breadcumb-active btn btn-default">Visualizar Prescrição</a>';
                   html+= '</div>';
                       document.getElementById("breadcumb").innerHTML =html;
           })();


   <?php else: ?>

           (function() {
              // your page initialization code here
              // the DOM will be available here

              var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
                ['controller' => 'Users', 'action' => 'login'],
                    ['class' => 'btn btn-default ', 'escape' => false]
               )?>';

              var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

              var link3 =' <?=$this->Html->link('Triagem', ['controller' => 'hospitalizations', 'action' => 'edit', $screening_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var link4 =' <?=$this->Html->link('Prescrições', ['controller' => 'Prescriptions', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var html = '';
                   html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                   html+= link1;
                   html+= link2;
                   html+= link3;
                   html+= link4;
                   html+= '<a href="#" class="breadcumb-active btn btn-default">Visualizar Prescrição</a>';
                   html+= '</div>';
                       document.getElementById("breadcumb").innerHTML =html;
           })();

   <?php endif;?>
</script>
