<?php

   if ($current_state == 'internacao') {
       echo $this->element('internacao-menu');
   } else {
       echo $this->element('screening-menu');
   }

   $from = $selected_patient_birthday;
   $to = new DateTime('today');
   $age = $from->diff($to)->y;
?>


<div  class="prescriptions form col-md-9 columns content">

         <div class="patient-info">
            <h4>Nome do paciente: <?= $patient_name; ?> </h4>
            <h4>Idade: <?= $age ?></h4>
            <h4>Prontuário: <?= $hospitalization->numero_do_prontuario; ?></h4>
            <h4>Data: <?= date('d/m/Y') ?></h4>
            <h4>Setor: <?= $hospitalization->sectorName($hospitalization['id']); ?></h4>
            <h4>Leito: <?= $hospitalization->roomName($hospitalization['id']); ?></h4>
            <h4>Alergia: 123</h4>
         </div>

         <div class="print-button-div">
            <span></span>
            <?=$this->Html->link("Imprimir", [
                  'controller' => 'prescriptions',
                  'action' => 'printPrescription',
                  $prescription->id
               ],
               [
                  "class" => "pull-right btn btn-success",
                  'target'=>'_blank',
               ]);
            ?>
         </div>

         <div style="overflow-x:scroll;margin-bottom:50px;">
            <table class="table table-striped table-hover" id="medications-table">

                  <thead>
                      <tr>
                          <th>Medicamento / Procedimento / Exame</th>
                          <th>Quantidade</th>
                          <th>Apresentação</th>
                          <th>Inicio imediato</th>
                          <th>Via de Administração</th>
                          <th>Frequência</th>
                          <th>Tempo de uso</th>
                          <th>Horario</th>
                      </tr>
                  </thead>

                  <tbody id='tbody'>

                        <?php
                           if (!empty($prescription['prescription_medications'])):
                              foreach ($prescription['prescription_medications'] as $key => $medication):

                        ?>
                              <tr class="medication-data-<?=$key?> input-row">

                                <td class="medication-name input-tds">
                                   <p><?= $medication['system_medication']['name']; ?></p>
                                   <p><?= $medication['observation']; ?></p>
                                </td>

                                <td class="medication-quantity input-tds">
                                   <p><?= $medication['quantity']; ?></p>
                                </td>

                                <td class="medication-presentation input-tds">
                                   <p><?= $medication['presentation']; ?></p>
                                </td>

                                <td class="medication-imadiate-start input-tds">
                                 <p><?= ($medication['imediate_start']) ? 'Sim' : 'Não'; ?></p>
                                </td>

                                <td class="medication-channel input-tds">
                                   <p><?= $medication['channel']; ?></p>
                                 </td>

                                 <td class="medication-frequency input-tds">
                                    <p><?= $medication['frequency']; ?></p>
                                 </td>

                                 <td class="medication-using-time  input-tds">
                                   <p><?= $medication['using_time']; ?></p>
                                 </td>

                                <td class="medication-select-schedule input-tds">
                                 <p><?= ($medication['scheduling']); ?></p>
                                </td>

                              </tr>

                        <?php
                              endforeach;
                           endif;
                        ?>

                  </tbody>
            </table>
         </div>
         <div class="action-buttons-div">
           <div style="text-align:center;">
            <p class="signing-line"></p>
                 <p><?= $prescription->professional['user']->name ?></p>
                 <p><?= $prescription->professional['concil_number'] ?></p>
           </div>
         </div>


</div>

<script>

   <?php

   if ($current_state == "internacao"): ?>
           (function() {
              // your page initialization code here
              // the DOM will be available here

              var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
                   ['controller' => 'Users', 'action' => 'login'],
                   ['class' => 'btn btn-default ', 'escape' => false]
               )?>';

              var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

              var link3 =' <?=$this->Html->link('Internação', ['controller' => 'hospitalizations', 'action' => 'edit', $hospitalization_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var link4 =' <?=$this->Html->link('Prescrições', ['controller' => 'Prescriptions', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var html = '';
                   html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                   html+= link1;
                   html+= link2;
                   html+= link3;
                   html+= link4;
                   html+= '<a href="#" class="breadcumb-active btn btn-default">Visualizar Prescrição</a>';
                   html+= '</div>';
                       document.getElementById("breadcumb").innerHTML =html;
           })();


   <?php else: ?>

           (function() {
              // your page initialization code here
              // the DOM will be available here

              var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
                ['controller' => 'Users', 'action' => 'login'],
                    ['class' => 'btn btn-default ', 'escape' => false]
               )?>';

              var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

              var link3 =' <?=$this->Html->link('Triagem', ['controller' => 'hospitalizations', 'action' => 'edit', $screening_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var link4 =' <?=$this->Html->link('Prescrições', ['controller' => 'Prescriptions', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var html = '';
                   html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                   html+= link1;
                   html+= link2;
                   html+= link3;
                   html+= link4;
                   html+= '<a href="#" class="breadcumb-active btn btn-default">Visualizar Prescrição</a>';
                   html+= '</div>';
                       document.getElementById("breadcumb").innerHTML =html;
           })();

   <?php endif;?>
</script>
