<?php

   $from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
   $to   = new DateTime('today');
   $age = null;
   $age = $from->diff($to)->y;

   $bairro = (!empty($patient['bairro'])) ? $patient['bairro'].', ' : '';
   $street = (!empty($patient['street'])) ? $patient['street'].', ' : '';
   $logradouro = (!empty($patient['logradouro'])) ? $patient['logradouro'].', ' : '';
   $address_number = (!empty($patient['address_number'])) ? $patient['address_number'].', ' : '';
   $city = (!empty($patient['city'])) ? $patient['city'].', ' : '';
   $country = (!empty($patient['country'])) ? $patient['country'].', ' : '';
   $cep = (!empty($patient['cep'])) ? $patient['cep'].', ' : '';

   $endereco = $bairro.$street.$logradouro.$address_number.$city.$country.$cep;
   $endereco = trim($endereco,', ');

   $dias_internacao = '';

   if (isset($hospitalization['discharges'][0]['data_saida_unidade'])) {

      $date_of_hospitalization    = new \DateTime($hospitalization['date_of_hospitalization']->format('Y-m-d'));
      $data_saida_unidade         = new \DateTime($hospitalization['data_saida_unidade']->format('Y-m-d'));
      $dias_internacao            = $date_of_hospitalization->diff($data_saida_unidade)->days;

   }else{

      $date_of_hospitalization    = new \DateTime($hospitalization['date_of_hospitalization']->format('Y-m-d'));
      $dataAtual                  = new \DateTime(date ("Y-m-d"));
      $dias_internacao            = $date_of_hospitalization->diff($dataAtual)->days;

   }


    // criar a string da medicação

    $m='';

    if(!empty($prescription['medications'])){

        foreach ($prescription['medications'] as $key => $medication) {
          $m.= $medication['name'].', ';
        }

        $m = trim($m,", ");

    }

    // criar a string da medicação

?>


<style>

    .receituario-paciente-table{
      border-top:unset!important;
    }
    
    .receituario-paciente-table td,tr{
      border-top:unset!important;
      border-bottom: 1px solid #ddd;
    }

    .espaco{
      min-height: 152px;
      min-width:200px;
    }

    .identificação-paciente-table td{
       padding-bottom: 2px!important;
    }

    .ass{
        width:100%;
        text-align:left;
        padding-left:1px;
        padding-right:0px;
    }

    .asFar{
      border-top:1px solid #ddd;
    }





</style>



<div class="page">

  <div class="row">

    <legend style="text-align:center;" class="big-title">RECEITUÁRIO CONTROLE ESPECIAL</legend>

    <div class="col-sm-6">

      <table  class="table-bordered identificação-paciente-table no-break">

            <tr>
              <th>IDENTIFICAÇÃO DO EMITENTE</th>
            </tr>
            <?php
              $isLogged['name'] = ($isLogged['name'] != '') ? $isLogged['name'] : '' ;
              $firstPart = substr($isLogged['name'], 0, 19);
              $secondPart = substr($isLogged['name'], 19);
            ?>
            <tr>
              <td><span><b>Nome Completo:</b><?= $firstPart?></span></td>
            </tr>

            <tr>
              <td><span>&nbsp;<?= $secondPart ?></span></td>
            </tr>

            <tr>
              <td>
              <span style="margin-right:100px;"><b>CRM:</b></span>
              <span style="margin-right:40px;"><b>UF:</b></span>
              <span><b>N°:</b></span>
              </td>
            </tr>

            <tr>  
              <td><span><b>Endereço Completo:&nbsp;</b></span></td>
            </tr>

            <tr>
              <td><span>&nbsp;</span></td>
            </tr>  

            <tr>
              <td><span style="margin-right:100px;" ><b>Cidade:</b></span><span><b>UF:</b></span></td>
            </tr>

            <tr>
              <td><span><b>Telefone:</b><?=$isLogged['phone_number']?></span></td>
            </tr>
          
        </table>

    </div>

    <div class="col-sm-4">
      <p><strong>1° Via Farmácia:</strong></p>
      <p><strong>2° Via Paciente:</strong></p>
    </div>

    <div class="col-sm-12">
        <br><br><br>
        <table   class="table receituario-paciente-table no-break">
          
            <tr>
              <td><span><b>Paciente</b>:&nbsp; <?= $patient->nome ?></span></td>
            </tr>

            <tr>  
              <td><span><b>Endereço:&nbsp;</b><?= $endereco ?></span></td>
            </tr>  

            <tr>
              <td><span><b>Prescrição:</b>&nbsp;<?= $m ?></span></td>
            </tr>
          
        </table>
        <br><br><br>
    
    </div>

    <div class="row">

    <div class="col-sm-6">

      <table  class="table-bordered identificação-paciente-table no-break">

            <tr>
              <th>IDENTIFICAÇÃO DO COMPRADOR</th>
            </tr>

            <tr>
              <td><span><b>Nome:</span></td>
            </tr>

            <tr>
              <td><span>&nbsp;</span></td>
            </tr>

            <tr>
              <td><span style="margin-right:100px;"><b>Ident:</b></span><span><b>Org. Emissor:</b></span></td>
            </tr>

            <tr>  
              <td><span><b>Endereço:&nbsp;</b></span></td>
            </tr>  

            <tr>
              <td><span style="margin-right:100px;" ><b>Cidade:</b></span><span><b>UF:</b></span></td>
            </tr>

            <tr>
              <td><span><b>Telefone:</b></span></td>
            </tr>
          
        </table>

    </div>

    <div class="col-sm-6">

      <table  class="table-bordered identificação-paciente-table no-break">

            <tr>
              <th colspan="2">IDENTIFICAÇÃO DO FORNECEDOR</th>
            </tr>

            <tr style="border-bottom:unset!important">

              <td style="border-bottom:unset!important" colspan="2">
                  <div class="espaco"></div>
              </td>

            </tr>

            <tr style="border-top:unset!important">
              
              <td style=" border-top:unset!important; " class="ass">
                  <div class="asFar" style="padding-right:55px;display:inline;font-size:14px;">Assinatura do farmacêutico</div>
                  <div style="display:inline;">Data___/___/___</div>
              </td>

            </tr>
          
        </table>


    </div>
  </div>

  </div>
  
</div>


<script type="text/javascript">


window.onload = setTimeout(function(){$.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});},1);
  
  (function(){
    $(".pad-top-20").removeClass('container');
    $(".pad-top-20").addClass('container-fluid');
    
    $("form :input").prop('readonly', true);
    $("form :input").css('readonly', true);
    $('nav').css('display','none');

    // definindo a função de Print
    function PrintPage() {
        window.print();
        setTimeout(function () {
          $.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});
          window.close();
        },900);
    }

    // chamando a função de imprimir
    setTimeout(function(){ 
      PrintPage();
    },600);

  })();
</script>
