<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Neonatal Checklist']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="neonatalChecklists index col-md-10 columns content">
    <h3>Neonatal Checklists</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('paridade') ?></th>
                <th><?= $this->Paginator->sort('enfermidades_atuais') ?></th>
                <th><?= $this->Paginator->sort('intercorren_pre_parto') ?></th>
                <th><?= $this->Paginator->sort('boletim_apgar') ?></th>
                <th><?= $this->Paginator->sort('necessidade_reanimacao') ?></th>
                <th><?= $this->Paginator->sort('apto_amamentacao') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($neonatalChecklists as $neonatalChecklist): ?>
            <tr>
                <td><?= $this->Number->format($neonatalChecklist->id) ?></td>
                <td><?= h($neonatalChecklist->paridade) ?></td>
                <td><?= h($neonatalChecklist->enfermidades_atuais) ?></td>
                <td><?= h($neonatalChecklist->intercorren_pre_parto) ?></td>
                <td><?= h($neonatalChecklist->boletim_apgar) ?></td>
                <td><?= h($neonatalChecklist->necessidade_reanimacao) ?></td>
                <td><?= h($neonatalChecklist->apto_amamentacao) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $neonatalChecklist->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $neonatalChecklist->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $neonatalChecklist->id], ['confirm' => __('Are you sure you want to delete # {0}?', $neonatalChecklist->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>