<?php $this->assign('title', $title); ?>

<div class="groups form col-md-10 columns content">
    <?= $this->Form->create($group, ['type' => 'file', 'onsubmit' => "return Validate(this);"]) ?>
    <fieldset>
        <?php
            echo $this->Form->input('name', ['label'=>['text'=>'Nome do Grupo:','class'=>'form-input']]);
            echo '<label for="is-active" class="form-input-inline">Ativo</label>&nbsp;&nbsp;';            
            echo $this->Form->checkbox('is_active', array('label'=> 'Status'));
            echo "<br><br>";
            echo "<p>Logotipo (as extensões permitidas são: jpg, jpeg e png) : </p>";
            echo $this->Form->file('uploadfile', ['multiple', 'id'=>'group-file']);            
        ?>
    </fieldset>
        
    <br><br>
    <?php echo $this->Html->image('uploads/'.h($group->filename), ['alt' => 'CakePHP', 'width'=>'400px', 'class'=>'img-thumbnail']); ?>
    <br><br><br><br><br><br>
    <button class="btn btn-danger" onclick="goBack()">Cancelar</button>
    <?php //echo $this->Form->button(__('Salvar', ['id'=>'group-submit'])) ?>
    <?php echo $this->Form->button("Salvar", ['id'=>'group-submit'])?>
    <?= $this->Form->end() ?>
</div>

<div class="units form col-md-10 columns content">    
    <br><br><br><br>
    <fieldset style="border:none">
         <legend class="big-title">Unidades vinculadas</legend>
        <table class="table table-striped table-hover">
        <thead>
            <tr>                
                <th><?= $this->Paginator->sort('Nome') ?></th>
                <th><?= $this->Paginator->sort('email', array( 'label' => 'E-mail')) ?></th>
                <th><?= $this->Paginator->sort('telefone') ?></th>
                <th><?= $this->Paginator->sort('is_active', array('label'=>'Status')) ?></th>
               <?php if ($isLogged['role_name'] == "Administrador")
                {
                    echo '<th class="actions"> Ações </th>';
                } 
                ?>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($units as $unit): ?>
            <tr>               
                <td><?= h($unit->name) ?></td>
                <td><?= h($unit->email) ?></td>
                <td><?= h($unit->telephone) ?></td>
                <td>
                <?= h($unit->is_active)? "Ativo" : "Suspenso"; ?>
                </td>
                <td class="actions" style="white-space:nowrap">
                    <?=
                         ( $isLogged['role_name'] == "Administrador" ?  $this->Html->link(__('Usuários'), ['controller'=>'Units','action' => 'list-users', $unit->id], ['class'=>'btn btn-warning btn-xs']) : '' )                                            
                     ?>                                    
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('Anterior'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('Próximo') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
        </div>
    </fieldset>
    <p></p>
    <p></p>
    <br><br>
    <p></p>
    <p></p>
</div>


<script>
$( document ).ready(function() {
    var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Home',
        array('controller' => 'Users', 'action' => 'login'), array('class'=>'btn btn-default ', 'escape' => false)) ?> ';

    var link2 =' <?= $this->Html->link('Grupos de Unidade',['controller' => 'Groups', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var html = '';
        html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
        html+= link1;
        html+= link2;
        html+= '<a href="#" class="breadcumb-active btn btn-default">Editar</a>';
        html+= '</div>';
    document.getElementById("breadcumb").innerHTML =html;
});
</script>