<?php    
	echo $this->element( 'internacao-menu' );

	$from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
	$to   = new DateTime('today');
	$age = null;
	$age = $from->diff($to)->y;
?>
<div class="apacheIiScores form col-md-9 columns content">
	<?= $this->Form->create($apacheIiScore) ?>
	<fieldset>        
		<?php
			$fio2 = ['fio2_maior_que_0_5_opt'=>'Fio2 >= 0,5', 'fio2_menor_que_0_5_opt'=>'Fio2 < 0,5'];
			$temperatura_retal_opt = ['< = 29,9 °C'=>'< = 29,9 °C', '30-31,9 °C'=>'30-31,9 °C', '32-33,9 °C'=>'32-33,9 °C', '34-35,9 °C'=>'34-35,9 °C', '36-38,4 °C'=>'36-38,4 °C', '38,5-38,9 °C'=>'38,5-38,9 °C', '39-40,9 °C'=>'39-40,9 °C', '> = 41 °C'=>'> = 41 °C' ];
			 $pressao_arterial_opt = ['<=  40'=>'<=  40', '50-69'=>'50-69', '70-109'=>'70-109', '110-129'=>'110-129', '139-159'=>'139-159', '> = 160'=>'> = 160' ];
			 $frequencia_cardiaca_opt = ['<  = 39'=>'<  = 39', '40-54'=>'40-54', '55-69'=>'55-69', '70-109'=>'70-109', '110-139'=>'110-139', '140-179'=>'140-179', '>  = 180'=>'>  = 180', ];
			 $frequencia_respiratoria_opt = ['<  =  5'=>'<  =  5', '6-9'=>'6-9', '10-11'=>'10-11', '12-24'=>'12-24', '25-34'=>'25-34', '35-49'=>'35-49', '>  = 50'=>'>  = 50' ];
			$fio2_maior_que_0_5_opt = ['< 200'=>'< 200', '200-349'=>'200-349', '350-499'=>'350-499', '> 500'=>'> 500'];
			$fio2_menor_que_0_5_opt = ['< 55'=>'< 55', '55-60'=>'55-60', '61-70'=>'61-70', '> 70'=>'> 70' ];
			$ph_arterial_opt = ['>  =  7,7'=>'>  =  7,7', '7,6 - 7,69'=>'7,6 - 7,69', '7,5 - 7,59'=>'7,5 - 7,59', '7,33 - 7,49'=>'7,33 - 7,49', '7,25 - 7,32'=>'7,25 - 7,32', '7,15 - 7,24'=>'7,15 - 7,24', '< 7,15'=>'< 7,15', ];
			$sodio_serico_opt = ['> = 180'=>'> = 180', '160 - 179'=>'160 - 179', '155 - 159'=>'155 - 159', '150 - 154'=>'150 - 154', '130 - 149'=>'130 - 149', '120 - 129'=>'120 - 129', '111 - 119'=>'111 - 119', '< = 110'=>'< = 110' ];
			$potassio_serico_opt = ['>  =  7'=>'>  =  7', '6 - 6,9'=>'6 - 6,9', '5,5 - 5,9'=>'5,5 - 5,9', '3,5 - 5,4'=>'3,5 - 5,4', '3 - 3,4'=>'3 - 3,4', '2,5 - 2,9'=>'2,5 - 2,9', '< 2,5'=>'< 2,5', ];
			 $creatinina_serica_opt = ['< 0,6'=>'< 0,6', '0,6-1,4'=>'0,6-1,4', '1,5-1,9'=>'1,5-1,9', '2-3,4'=>'2-3,4', '> 3,5'=>'> 3,5'];
			 $hematocrito_opt = ['<20'=>'<20', '20-29,9'=>'20-29,9', '30-45,9'=>'30-45,9', '46-49,9'=>'46-49,9', '50-59,9'=>'50-59,9', '>60'=>'>60' ];
			 $hc03_serico_opt = ['>  = 52'=>'>  = 52', '41 - 51,9'=>'41 - 51,9', '32 - 40,9'=>'32 - 40,9', '22 - 31,9'=>'22 - 31,9', '18 - 21,9'=>'18 - 21,9', '15 - 17,9'=>'15 - 17,9', '< 15'=>'< 15', ];
			 $w_b_c_opt = ['< 1'=>'< 1', '1 - 2,9'=>'1 - 2,9', '3 - 14,9'=>'3 - 14,9', '15 - 19,9'=>'15 - 19,9', '20 - 39,9'=>'20 - 39,9', '>  =  40'=>'>  =  40' ];
			 $cronica_opt = ['Paciente não operatório'=>'Paciente não operatório', 'Paciente pós operatório'=>'Paciente pós operatório', 'Paciente pós operatório eletivo'=>'Paciente pós operatório eletivo'];
 			$glasgow = ['15'=>'15', '14' =>'14', '13'=>'13', '12'=>'12', '11'=>'11', '10'=>'10', '9'=>'9', '8'=>'8', '7'=>'7', '6'=>'6', '5'=>'5', '4'=>'4', '3'=>'3'];

 			// $paciente_apresenta_insuficiencia_organica_severa_cronica_item = ['1'=>'Hepática: Cirrose comprovada por biópsia, hipertensão portal documentada; episódios passados de hemorragia gastrintestinal atribuídos à hipertensão portal; episódios anteriores de insuficiência hepática, encefalopatia ou coma', '2'=>'Cardíaca: Classificação funcional IV pela NYHA que dificultam as atividade habituais.', '3'=>'Respiratória: Doença crônica restritiva, obstrutiva ou vascular resultando em grave restrição ao exercício, isto é, incapaz de subir escadas ou fazer serviços domésticos; hipóxia crônica documentada, hipercapnia, policitemia secundária, hipertensão pulmonar grave (> 40 mmHg); dependência de prótese ventilatória.', '4'=>'Renal: em terapia de substituição renal'];

 			$paciente_apresenta_insuficiencia_organica_severa_cronica_item = ['1'=>'Hepática', '2'=>'Cardíaca', '3'=>'Respiratória', '4'=>'Renal'];

 			
 			$paciente_nao_operatorio = [
 			 'Insuficiência respiratória:'=>
 			 	[0=>'Asma/alergia', 1=>'DPOC', 'SDRA (SARA)', 3=>'Parada respiraória', 4=>'Aspiração/envenenamento/tóxico', 5=>'Embolia pulmonar', 6=>'Infecção', 7=>'Neoplasia'],
 			  'Insuficiência cardiovascular:'=>
 			  	[8=>'Hipertensão', 9=>'Distúrbio do ritmo', 10=>'Insuficiência cardíaca congestiva', 11=>'Choque hemorrágico/hipovolemia', 12=>'Doença coronariana arterial', 13=>'Sepse', 14=>'Choque cardiogênico', 15=>'Aneurisma dissecante torácido ou abdominal', 16=>'Parada cardíaca'],
 			  	'Trauma'=>[17=>'Trauma múltiplo', 18=>'Trauma craniano'],
 			  	'Neurológico'=>[19=>'Desordens convulsiva', 20=>'Hemorragia cerebral'],
 			  	'Outras'=>[21=>'Overdose de drogas', 22=>'Cetoacidose diabética', 23=>'Hemorragia gastrintestinal'],
 			  	'IMOS'=>[24=>'Metabólico/renal', 25=>'Respiratório', 26=>'Neurológico', 27=>'Cardiovascular', 28=>'Gastrintestinal']
			];

			$paciente_pos_operatorio = [
				0=>'Trauma múltiplo', 1=>'Admissão devida à doença cardiovascular crônica', 2=>'Cirurgia vascular periférica', 3=>'Cirurgia cardíaca valvular', 4 => 'Craniotomia por neoplasia', 5 => 'Cirurgia renal por neoplasia', 6 => 'Transplante renal', 'Traumatismo craniano', 7 => 'Cirurgia torácica por neoplasia', 8 => 'Craniotomia por hemorragia cerebral', 9 => 'Laminectomia e outras cirurgias da coluna vertebral', 10 => 'Choque hemorrágico', 11 => 'Hemorragia gastrintestinal', 12 => 'Cirurgia gastrintestinal por neoplasia', 13 => 'Insuficiência respiratória pós-cirurgia', 14 => 'Perfuração/obstrução abdominal', 15 => 'Sepse', 16 => 'Parada cardíaca', 17 => 'Parada respiratória',
				'Outros'=>[18 => 'Cardiovascular', 19 => 'Respiratório', 20 => 'Gastrintestinal', 21 => 'Metabólico/renal', 22 => 'Neurológico']
			];

			

			echo $this->Form->input('idade', ['class'=>'', 'disabled'=>true,'value'=>$age, 'label'=>['text'=>'Idade:', 'class'=>'form-input'] ]);
			echo $this->Form->input('tipo_internacao', ['class'=>'', 'disabled'=>true,'value'=>$hospitalization['type'], 'label'=>['text'=>'Tipo de internação:', 'class'=>'form-input'] ]);


			echo $this->Form->input('temperatura_retal', ['class'=>'item1','onchange' => "javascript:calculateApache(this, 1);", 'empty'=>true,'options'=>$temperatura_retal_opt, 'label'=>['text'=>'Temperatura retal (C):', 'class'=>'form-input'] ]);

			echo $this->Form->input('pressao_arterial_media_mmhg', ['class'=>'item2','onchange' => "javascript:calculateApache(this, 2);", 'empty'=>true,'options'=>$pressao_arterial_opt, 'label'=>['text'=>'Pressão arterial Média (mmHg):', 'class'=>'form-input'] ]);

			echo $this->Form->input('frequencia_cardiaca_bpm', ['class'=>'item3','onchange' => "javascript:calculateApache(this, 3);", 'empty'=>true,'options'=>$frequencia_cardiaca_opt, 'label'=>['text'=>'Frequência cardíaca (bpm):', 'class'=>'form-input'] ]);

			echo $this->Form->input('frequencia_respiratoria_irpm', ['class'=>'item4','onchange' => "javascript:calculateApache(this, 4);",  'empty'=>true,'options'=>$frequencia_respiratoria_opt, 'label'=>['text'=>'Frequência respiratória (irpm / ventilados ou não):', 'class'=>'form-input'] ]);

			echo $this->Form->input('fio2', ['class'=>'', 'empty'=>true,'options'=>$fio2, 'label'=>['text'=>'FiO2:', 'class'=>'form-input'] ]);
			echo "<div id='fio2_maior_que_0_5_opt' class='hide-element'>";
				echo $this->Form->input('fio2_maior_que_0_5_a_ado2', ['class'=>'item5','onchange' => "javascript:calculateApache(this, 5);",  'empty'=>true,'options'=>$fio2_maior_que_0_5_opt, 'label'=>['text'=>'FiO2 > 0,5 A-aDO2:', 'class'=>'form-input'] ]);
			echo "</div>";

			echo "<div id='fio2_menor_que_0_5_opt' class='hide-element'>";			
				echo $this->Form->input('fio2_menor_que_pao2', ['class'=>'item6','onchange' => "javascript:calculateApache(this, 6);",  'empty'=>true,'options'=>$fio2_menor_que_0_5_opt, 'label'=>['text'=>'FiO2< 0,5   PaO2:', 'class'=>'form-input'] ]);
			echo "</div>";

			echo $this->Form->input('ph_arterial', ['class'=>'item8','onchange' => "javascript:calculateApache(this, 8);",  'empty'=>true,'options'=>$ph_arterial_opt, 'label'=>['text'=>'pH arterial:', 'class'=>'form-input'] ]);

			echo $this->Form->input('sodio_serico', ['class'=>'item9','onchange' => "javascript:calculateApache(this, 9);",  'empty'=>true,'options'=>$sodio_serico_opt, 'label'=>['text'=>'Sódio sérico (mEq/L):', 'class'=>'form-input'] ]);

			echo $this->Form->input('potassio_serico', ['class'=>'item10','onchange' => "javascript:calculateApache(this, 10);",  'empty'=>true,'options'=>$potassio_serico_opt, 'label'=>['text'=>'Potássio sérico (mEq/L):', 'class'=>'form-input'] ]);

			echo '<div class="funkyradio">';                                     
            	echo '<div class="funkyradio-primary">';
                	echo $this->Form->checkbox('ira', ['id'=>'ira', 'class'=>'active_checked 23', 'onchange' => "javascript:calculateApache(this, 23);"]);
               		 echo '<label for="ira">IRA</label>';
                echo "</div>";  
            echo "</div><br>";  

			echo $this->Form->input('creatinina_serica_dobrar_pontos_se_ira', ['class'=>'item12','onchange' => "javascript:calculateApache(this, 12);",  'empty'=>true,'options'=>$creatinina_serica_opt, 'label'=>['text'=>'Creatinina Sérica (mg/dL) com IRA:', 'class'=>'form-input'] ]);

			 echo $this->Form->input('hematocrito', ['class'=>'item13','onchange' => "javascript:calculateApache(this, 13);",  'empty'=>true,'options'=>$hematocrito_opt, 'label'=>['text'=>'Hematócrito (%):', 'class'=>'form-input'] ]);

			 echo $this->Form->input('hc03_serico', ['class'=>'item7','onchange' => "javascript:calculateApache(this, 7);",  'empty'=>true,'options'=>$hc03_serico_opt, 'label'=>['text'=>'Bicarbonato sérico (mEq/L) (usar se não coletar gasometria):', 'class'=>'form-input'] ]);

			 echo $this->Form->input('w_b_c', ['class'=>'item14','onchange' => "javascript:calculateApache(this, 14);",  'empty'=>true,'options'=>$w_b_c_opt, 'label'=>['text'=>'Número de leucócitos:', 'class'=>'form-input'] ]);

			// echo $this->Form->input('cronica_Insuficiencia_de_orgaos_imunocomprometidos', ['class'=>'item16','onchange' => "javascript:calculateApache(this, 16);",  'empty'=>true,'options'=>$cronica_opt, 'label'=>['text'=>' Insuficiência Crônica de Órgãos  Imunocomprometidos:', 'class'=>'form-input'] ]);

				echo $this->Form->input('glasgow', ['class'=>'item15','onchange' => "javascript:calculateApache(this, 15);",  'empty'=>true,'options'=>$glasgow, 'label'=>['text'=>'Glasgow:', 'class'=>'form-input'] ]);

				echo $this->Form->input('pontuation', ['class'=>"hide", 'label'=>false, 'id'=>'pontuation-id']);
				echo $this->Form->hidden('apache_ii', ['id'=>'apache_ii']);
				echo $this->Form->hidden('probabilidade_de_obito', ['id'=>'probabilidade_de_obito']);
				echo $this->Form->hidden('hospitalization_id', ['value' => $hospitalization_id]);
				echo $this->Form->hidden('active', ['value'=>1]);

				echo '<div class="funkyradio">';                                     
                	echo '<div class="funkyradio-primary">';
	                	echo $this->Form->checkbox('paciente_apresenta_insuficiencia_organica_severa_cronica', ['id'=>'paciente_apresenta_insuficiencia_organica_severa_cronica', 'class'=>'active_checked item17', 'onchange' => "javascript:calculateApache(this, 17);"]);
	               		 echo '<label for="paciente_apresenta_insuficiencia_organica_severa_cronica">O paciente apresenta insuficiência orgânica severa e crônica</label>';
	                echo "</div>";  
	            echo "</div><br>";  

	            echo '<div class="funkyradio paciente_apresenta_insuficiencia_organica_severa_cronica hide-element">';
					echo $this->Form->input('paciente_apresenta_insuficiencia_organica_severa_cronica_item', ['class'=>'item18','empty'=>'Selecione um item', 'onchange' => "javascript:calculateApache(this, 18);", 'options'=>$paciente_apresenta_insuficiencia_organica_severa_cronica_item, 'label'=>['text'=>'', 'class'=>'form-input'] ]);
				echo "</div><br>";

				echo '<div class="funkyradio">';                                     
	                echo '<div class="funkyradio-primary">';
	                echo $this->Form->checkbox('paciente_recebido_cronicamente', ['id'=>'paciente_recebido_cronicamente', 'onchange' => "javascript:calculateApache(this, 19);", 'class'=>'item19']);

	                echo '<label for="paciente_recebido_cronicamente">Paciente tem recebido cronicamente ou recentemente, em altas doses, terapia que suprime a resistência à infecção (imunossupressores, quimioterapia, radioterapia ou corticóides) ou apresenta doença que é suficientemente avançada para suprimir a resistência à infecção (leucemia, linfoma ou AIDS).</label>';
	                echo "</div>";  
	            echo "</div><br>"; 
				
				if (strpos($hospitalization['type'], 'Cirúr') !== false) {
					echo $this->Form->input('coeficiente', ['class'=>'item21', 'onchange' => "javascript:calculateApache(this, 21);", 'empty'=>true,'options'=>$paciente_pos_operatorio, 'label'=>['text'=>'Coeficientes para pacientes pós-operatórios:', 'class'=>'form-input'] ]);
				}
				else {
					echo $this->Form->input('coeficiente', ['class'=>'item20', 'onchange' => "javascript:calculateApache(this, 21);", 'empty'=>true,'options'=>$paciente_nao_operatorio, 'label'=>['text'=>'Coeficientes para pacientes não-operatórios:', 'class'=>'form-input'] ]);
				}
				
				echo $this->Form->input('data_realizacao', ['class'=>'date','type' => 'text','label'=>['text'=>'Data de realização:', 'class'=>'form-input'] ]);

				?>
				
			<h3 id="apache" style="display:inline-block">Probabilidade de óbito: 0%  </h3>
			<span style="font-size:0.9em">&nbsp;&nbsp;(Probabilidade ajustada para a América Latina)</span>
			<h3 id="apache_ptos">Pontuação: 0</h3>
			<h3 id="apache_grupo"></h3>
			<br><br><br><br>
			
			<button type="button" class="btn btn-danger" onclick="goBack()">Cancelar</button>
			<?= $this->Form->button(__('Salvar')) ?>
			<?= $this->Form->end() ?>
			<br><br><br><br><br><br>
		</fieldset>
  <br><br><br><br><br><br>
</div>


<script >
var tipo_internacoes_5_arr = ['Clínica', 'Cirúrgica Emergencial', 'Pediátrica', 'Obstétrica'];
var tipo_internacoes_2_arr = ['Cirúrgica Eletiva'];

$( document ).ready(function() 
{
	calculateApache();
	setTimeout(function(){$(".active_checked").trigger("change");},1000);
});


$("#fio2").change(function() {
	console.log("fio2 val = " + $(this).val() );

	if ($(this).val() == 'fio2_maior_que_0_5_opt') {
		$("#fio2_maior_que_0_5_opt").slideDown();

		$("#fio2_menor_que_0_5_opt").slideUp();
		$("#fio2_menor_que_0_5_opt option:selected").prop("selected", false);
	} 
	else if ($(this).val() == 'fio2_menor_que_0_5_opt') {
		$("#fio2_menor_que_0_5_opt").slideDown();

		$("#fio2_maior_que_0_5_opt").slideUp();
		$("#fio2_maior_que_0_5_opt option:selected").prop("selected", false);
	} 
	else {
		$("#fio2_maior_que_0_5_opt").slideUp();
		$("#fio2_menor_que_0_5_opt").slideUp();
		$("#fio2_menor_que_0_5_opt option:selected").prop("selected", false);
		$("#fio2_maior_que_0_5_opt option:selected").prop("selected", false);
	}
});



function calculateApache(elem, item)
{
	var apache = 0;
	var apache_grupo = null;
	var coeficiente = 0;
	var tipo_internacao = '<?php if ( isset($hospitalization['type']) ) echo $hospitalization['type'] ?>'
	//console.log($(elem).val());

	if ( $("#paciente_apresenta_insuficiencia_organica_severa_cronica").is(":checked")
	 	|| $("#paciente_recebido_cronicamente").is(":checked") ) {
		if (inArray(tipo_internacao, tipo_internacoes_5_arr)) {
			apache += 5;
		}

		if (inArray(tipo_internacao, tipo_internacoes_2_arr)) {
			apache += 2;
		}
	}

	$( "select" ).each(function( index ) 
	{
		if ($( this ).hasClass( "item1" ))
		{
			console.log("temp retal = " + $(this).val());
			switch($(this).val()) 
				{
					case '34-35,9 °C':
							apache += 1;
							break;
					case '< = 29,9 °C':
							apache += 4;
							break;
					case '32-33,9 °C':
							apache += 2;
							break;
					case '38,5-38,9 °C':
						apache += 1;
						break;
					case '39-40,9 °C':
						apache += 3;
						break;
					case '> = 41 °C':
						apache += 4;
						break;
					case '30-31,9 °C':
						apache += 3;
						break;

											
				}
		}
		else if ($( this ).hasClass( "item2" ))
		{
				switch($(this).val()) 
				{
					case '<=  40':
						apache += 4;
						break;
					case '50-69':
						apache += 2;
						break;
					case '110-129':
						apache += 2;
						break;
					case '139-159':
						apache += 3;
						break;
					case '> = 160':
						apache += 4;
						break;
				}
		}
		else if ($( this ).hasClass( "item3" ))
		{
				switch($(this).val()) 
				{
					 case '<  = 39':
						apache += 3;
						break;   
					case '40-54':
						apache += 2;
						break;
					case '55-69':
						apache += 1;
						break;
					case '110-139':
						apache += 2;
						break;
					case '140-179':
						apache += 3;
						break;
					case '>  = 180':
						apache += 4;
						break;
				}
		}
		else if ($( this ).hasClass( "item4" ))
		{
				switch($(this).val()) 
				{
					case '<  =  5':
						apache += 3;
						break;                                     
					case '6-9':
						apache += 1;
						break;   
					case '10-11':
						apache += 0;
						break;                                     
					case '25-34':
						apache += 2;
						break;  
					case '35-49':
						apache += 3;
						break;   
					case '12-24':
						apache += 1;
						break;                                      
					case '>  = 50':
						apache += 4;
						break; 
				}
		}
		else if ($( this ).hasClass( "item5" ))
		{

				switch($(this).val()) 
				{
					 case '200-349':
						apache += 2;
						break;                                     
					case '350-499':
						apache += 3;
						break;          
					case '> 500':
						apache += 4;
						break; 
				}
		}
		else if ($( this ).hasClass( "item6" ))
		{
				switch($(this).val()) 
				{
					case '< 55':
						apache += 4;
						break;   
					case '55-60':
						apache += 3;
						break;                                     
					case '61-70':
						apache += 1;
						break; 
				}
		}
		else if ($( this ).hasClass( "item7" ))
		{
				switch($(this).val()) 
				{
					case '>  = 52':
						apache += 4;
						break;                                     
					case '41 - 51,9':
						apache += 3;
						break;  
					case '32 - 40,9':
						apache += 1;
						break;                                     
					case '18 - 21,9':
						apache += 2;
						break;                          
					case '15 - 17,9':
						apache += 3;
						break;  
					case '< 15':
						apache += 4;
						break;  
				}
		}
		else if ($( this ).hasClass( "item8" ))
		{
				switch($(this).val()) 
				{
					 case '>  =  7,7':
						apache += 4;
						break;  
					case '7,6 - 7,69':
						apache += 3;
						break;  
					case '7,5 - 7,59':
						apache += 1;
						break;  
					case '7,25 - 7,32':
						apache += 2;
						break;  
					case '7,15 - 7,24':
						apache += 3;
						break;                                                  
					case '< 7,15':
						apache += 4;
						break;  
				}
		}
		else if ($( this ).hasClass( "item9" ))
		{
				switch($(this).val()) 
				{
					case '> = 180':
						apache += 4;
						break;  
					case '160 - 179':
						apache += 3;
						break;  
					case '155 - 159':
						apache += 2;
						break;  
					case '150 - 154':
						apache += 1;
						break;  
					case '120 - 129':
						apache += 2;
						break;  
					case '111 - 119':
						apache += 3;
						break;  
					case '< = 110':
						apache += 4;
						break;  
				}
		}
		else if ($( this ).hasClass( "item10" ))
		{
				switch($(this).val()) 
				{
					case '>  =  7':
						apache += 4;
						break;                          
					case '6 - 6,9':
						apache += 3;
						break;  
					case '5,5 - 5,9':
						apache += 1;
						break;  
					case '3 - 3,4':
						apache += 1;
						break;  
					case '2,5 - 2,9':
						apache += 2;
						break;  
					case '< 2,5':
						apache += 4;
						break; 
				}
		}
				
		else if ($( this ).hasClass( "item11" ))
		{
				switch($(this).val()) 
				{
					 case '< 0,6':
						apache += 4;
						break;  
					case '1,5-1,9':
						apache += 4;
						break;  
					case '2-3,4':
						apache += 6;
						break;                          
					case '> 3,5':
						apache += 8;
						break;  
				}
		}

		else if ($( this ).hasClass( "item12" ))
		{
			if ( !$("#ira").is(":checked") ) {
				switch($(this).val()) 
				{
					case '< 0,6':
						apache += 2;
						break;  
					case '1,5-1,9':
						apache += 2;
						break;  
					case '2-3,4':
						apache += 3;
						break;  
					case '> 3,5':
						apache += 4;
						break;      
				}
			}
			else {
				switch($(this).val()) 
				{
					case '< 0,6':
						apache += 4;
						break;  
					case '1,5-1,9':
						apache += 4;
						break;  
					case '2-3,4':
						apache += 6;
						break;  
					case '> 3,5':
						apache += 8;
						break;      
				}
			}
				
		}
		else if ($( this ).hasClass( "item13" ))
		{
				switch($(this).val()) 
				{
					case '<20':
						apache += 4;
						break;  
					case '20-29,9':
						apache += 2;
						break;    
					case '46-49,9':
						apache += 1;
						break;                          
					case '50-59,9':
						apache += 2;
						break;  
					case '>60':
						apache += 4;
						break;  
				}
		}
				

		else if ($( this ).hasClass( "item14" ))
		{
				switch($(this).val()) 
				{
					case '< 1':
						apache += 4;
						break;  
					case '1 - 2,9':
						apache += 2;
						break;  
					case '15 - 19,9':
						apache += 1;
						break;  
					case '20 - 39,9':
						apache += 2;
						break;  
					case '>  =  40':
						apache += 4;
						break;        
				}
		}

		else if ($( this ).hasClass( "item15" ))
		{
				switch($(this).val()) 
				{
					case '14':
						apache += 1;
						break;  
					case '13':
						apache += 2;
						break;  
					case '13':
						apache += 3;
						break;  
					case '11':
						apache += 4;
						break;  
					case '10':
						apache += 5;
						break;  
					case '9':
						apache += 6;
						break;   
					case '8':
						apache += 7;
						break;                          
					case '7':
						apache += 8;
						break;   
					case '6':
						apache += 9;
						break;  
					case '5':
						apache += 10 ;
						break;  
					case '4':
						apache += 11;
						break;  
					case '3':
						apache += 12;
						break;                              
				}
		}       

		else if ($( this ).hasClass( "item16" ))
		{
			switch($(this).val()) 
			{                   
				case 'Paciente não operatório':
					apache += 5;
					break;  
				case 'Paciente pós operatório':
					apache += 5;
					break;   
				case 'Paciente pós operatório eletivo':
					apache += 2;
					break;   
			}
		}

		else if ($( this ).hasClass( "item20" ))
		{
			console.log('item20 = ' + $(this).val());
				switch($(this).val()) 
				{
					case '0':
						coeficiente = -2.108;
						break;  
					case '1':
						coeficiente = -0.367;
						break;  
					case '2':
						coeficiente = -0.215;
						break;      
					case '3':
						coeficiente = -0.168;
						break;  
					case '4':
						coeficiente = -0.142;
						break;                  
					case '5':
						coeficiente = -0.3120;
						break;  
					case '6':
						coeficiente = 0;
						break;  
					case '7':
						coeficiente = 0.891;
						break;      
					case '8':
						coeficiente = -1.798;
						break;  
					case '9':
						coeficiente = -1.368;
						break;
					case '10':
						coeficiente = -0.424;
						break;  
					case '11':
						coeficiente = 0.493;
						break;  
					case '12':
						coeficiente = -0.191;
						break;      
					case '13':
						coeficiente = 0.113;
						break;  
					case '14':
						coeficiente = -0.259;
						break;                  
					case '15':
						coeficiente = 0.731;
						break;  
					case '16':
						coeficiente = 0;
						break;  
					case '17':
						coeficiente = -1.228;
						break;      
					case '18':
						coeficiente = -0.517;
						break;  
					case '19':
						coeficiente = -0.584;
						break;   
					case '20':
						coeficiente = 0.723;
						break;      
					case '21':
						coeficiente = -3.353;
						break;  
					case '22':
						coeficiente = -1.507;
						break;                  
					case '23':
						coeficiente = 0.334;
						break;  
					case '24':
						coeficiente = -0.885;
						break;  
					case '25':
						coeficiente = -0.890;
						break;      
					case '26':
						coeficiente = -0.759;
						break;  
					case '27':
						coeficiente = 0.470;
						break; 
					case '28':
						coeficiente = 0.501;
						break; 
				}
		}

		else if ($( this ).hasClass( "item21" ))
		{
			console.log('item21 = ' + $(this).val());
				switch($(this).val()) 
				{
					case '0':
						coeficiente = -1.684;
						break;  
					case '1':
						coeficiente = -1.376;
						break;  
					case '2':
						coeficiente = -1.315;
						break;      
					case '3':
						coeficiente = -1.261;
						break;  
					case '4':
						coeficiente = -1.245;
						break;                  
					case '5':
						coeficiente = -1.204;
						break;  
					case '6':
						coeficiente = -1.042;
						break;  
					case '7':
						coeficiente = -0.955;
						break;      
					case '8':
						coeficiente = -0.802;
						break;  
					case '9':
						coeficiente = -0.788;
						break;
					case '10':
						coeficiente = -0.699;
						break;  
					case '11':
						coeficiente = -0.682;
						break;  
					case '12':
						coeficiente = -0.617;
						break;      
					case '13':
						coeficiente = -0.248;
						break;  
					case '14':
						coeficiente = 0.060;
						break;                  
					case '15':
						coeficiente = 0.113;
						break;  
					case '16':
						coeficiente = 0.393;
						break;  
					case '17':
						coeficiente = -0.168;
						break;      
					case '18':
						coeficiente = -0.797;
						break;  
					case '19':
						coeficiente = -0.610;
						break;   
					case '20':
						coeficiente = -0.613;
						break;   

					case '21':
						coeficiente = -0.196;
						break;   

					case '22':
						coeficiente = -1.150;
						break;      					
				}
		}

});
	//Logit = -3,517+( Apache II) * 0,146  
	var deathRate = 0;
	var logit =0;
	console.log("coeficiente = "+ coeficiente);
	console.log("total = "+ apache);


	if ( apache > 0)
	{
		logit = -3.517 + (apache * 0.146) + coeficiente;
		deathRate = Math.exp(logit) / (1 + Math.exp(logit));
		deathRate = deathRate*100;  
		deathRate = deathRate.toFixed(2);
	}

	if (apache <= 4) {
		apache_grupo = "Grupo 1 - A";

	} 
	else if (apache <= 9) {
		apache_grupo = "Grupo 1 - B";
	}
	else if (apache <= 14) {
		apache_grupo = "Grupo 2 - A";
	}
	else if (apache <= 19) {
		apache_grupo = "Grupo 2 - B";
	}

	else if (apache <= 24) {
		apache_grupo = "Grupo 3 - A";
	}

	else if (apache > 30) {
		apache_grupo = "Grupo 4 ";
	}

	$('#apache_grupo').text( apache_grupo );
	$('#apache_ptos').text("Pontuação: "+ apache);
	$('#apache').text("Probabilidade de óbito: "+ deathRate +"%");
	// $('#apache_ii').val(deathRate);
	$('#probabilidade_de_obito').val(deathRate);
	$('#pontuation').val(apache);
	$('#pontuation-id').val(apache);
}


(function() {
   // your page initialization code here
   // the DOM will be available here

   var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)', 
	array('controller' => 'Users', 'action' => 'login'), array('class'=>'btn btn-default ', 'escape' => false)) ?> ';

   var link2 =' <?= $this->Html->link('Pacientes',['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

   var link3 =' <?= $this->Html->link('Internação',['controller' => 'hospitalizations', 'action' => 'edit', $hospitalization_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

	var link4 =' <?= $this->Html->link('Escores',['controller' => 'ApacheIiScores', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

	var html = '';
		html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
		html+= link1;
		html+= link2;
		html+= link3;
		html+= link4;
		html+= '<a href="#" class="breadcumb-active btn btn-default">Editar Apache II</a>';        
		html+= '</div>';
			document.getElementById("breadcumb").innerHTML =html;
})();
</script>



