<?php
namespace App\Model\Table;

use App\Model\Entity\TypeOfAnesthesia;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * TypeOfAnesthesias Model
 *
 * @property \Cake\ORM\Association\BelongsToMany $PreAnestheticVisits
 * @property \Cake\ORM\Association\BelongsToMany $Surgeries
 */
class TypeOfAnesthesiasTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('type_of_anesthesias');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsToMany('PreAnestheticVisits', [
            'foreignKey' => 'type_of_anesthesia_id',
            'targetForeignKey' => 'pre_anesthetic_visit_id',
            'joinTable' => 'pre_anesthetic_visits_type_of_anesthesias'
        ]);

        $this->belongsToMany('Surgeries', [
            'foreignKey' => 'type_of_anesthesia_id',
            'targetForeignKey' => 'surgery_id',
            'joinTable' => 'type_of_anesthesias_surgeries'
        ]);

        $this->belongsToMany('SafeSurgeryBundles', [
            'foreignKey' => 'type_of_anesthesia_id',
            'targetForeignKey' => 'safe_surgery_bundle_id',
            'joinTable' => 'safe_surgery_bundles_type_of_anesthesias'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('nome', 'create')
            ->notEmpty('nome');

        return $validator;
    }
}
