<?php
namespace App\Model\Table;

use App\Model\Entity\SystemMedication;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SystemMedications Model
 *
 * @property \Cake\ORM\Association\BelongsTo $MedicationDescriptions
 * @property \Cake\ORM\Association\BelongsTo $Professionals
 */
class SystemMedicationsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('system_medications');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Professionals', [
            'foreignKey' => 'professional_id',
            'joinType' => 'INNER'
        ]);

        $this->hasMany('PrescriptionMedications', [
            'foreignKey' => 'system_medication_id',
            'joinType' => 'INNER'
        ]);

        $this->belongsToMany('RestrictedSectors', [
             'className' => 'Sectors',
             'foreignKey' => 'system_medication_id',
             'targetForeignKey' => 'sector_id',
             'joinTable' => 'system_medications_restricted_sectors'
        ]);

        $this->belongsToMany('RestrictedProfessionals', [
             'className' => 'Professionals',
             'foreignKey' => 'system_medication_id',
             'targetForeignKey' => 'professional_id',
             'joinTable' => 'system_medications_restricted_professionals'
        ]);

        $this->belongsToMany('RestrictedSpecialties', [
             'className' => 'Specialties',
             'foreignKey' => 'system_medication_id',
             'targetForeignKey' => 'specialty_id',
             'joinTable' => 'system_medications_restricted_specialties'
        ]);

    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['professional_id'], 'Professionals'));
        return $rules;
    }
}
