<?php
namespace App\Model\Table;

use App\Model\Entity\SystemMedicationRestrictedSector;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SystemMedicationRestrictedSectors Model
 *
 * @property \Cake\ORM\Association\BelongsTo $SystemMedications
 * @property \Cake\ORM\Association\BelongsTo $Sectors
 */
class SystemMedicationRestrictedSectorsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('system_medication_restricted_sectors');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('SystemMedications', [
            'foreignKey' => 'system_medication_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Sectors', [
            'foreignKey' => 'sector_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['system_medication_id'], 'SystemMedications'));
        $rules->add($rules->existsIn(['sector_id'], 'Sectors'));
        return $rules;
    }
}
