<?php
namespace App\Model\Table;

use App\Model\Entity\SofaEscore;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SofaEscores Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\HasMany $SepseProtocols
 */
class SofaEscoresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('sofa_escores');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType'   => 'INNER',
        ]);
        $this->hasMany('SepseProtocols', [
            'foreignKey' => 'sofa_escore_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('respiratorio');

        $validator
            ->allowEmpty('cardiovascular');

        $validator
            ->allowEmpty('hematologico');

        $validator
            ->allowEmpty('renal');

        $validator
            ->allowEmpty('hepatico');

        $validator
            ->allowEmpty('neurologico');

        $validator
        // ->date('data_de_realizacao')
        ->requirePresence('data_de_realizacao', 'create')
            ->notEmpty('data_de_realizacao');

        $validator
            ->boolean('active')
            ->allowEmpty('active');

        $validator
            ->allowEmpty('pontuation');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
