<?php
namespace App\Model\Table;

use App\Model\Entity\Sector;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Sectors Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Units
 * @property \Cake\ORM\Association\BelongsTo $Types
 * @property \Cake\ORM\Association\HasMany $Discharges
 * @property \Cake\ORM\Association\HasMany $Hospitalizations
 * @property \Cake\ORM\Association\HasMany $IndicatorsSectors
 * @property \Cake\ORM\Association\HasMany $MedicalOpinionRequests
 * @property \Cake\ORM\Association\HasMany $ProfessionalSectors
 * @property \Cake\ORM\Association\HasMany $Rooms
 */
class SectorsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('sectors');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Units', [
            'foreignKey' => 'unit_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Types', [
            'foreignKey' => 'type_id',
            'joinType'   => 'INNER',
        ]);
        $this->hasMany('Discharges', [
            'foreignKey' => 'sector_id',
        ]);
        $this->hasMany('Hospitalizations', [
            'foreignKey' => 'sector_id',
        ]);
        $this->hasMany('SepseProtocols', [
            'foreignKey' => 'sector_id',
        ]);
        $this->hasMany('IndicatorsSectors', [
            'foreignKey' => 'sector_id',
        ]);
        $this->hasMany('MedicalOpinionRequests', [
            'foreignKey' => 'sector_id',
        ]);
        $this->hasMany('ProfessionalSectors', [
            'foreignKey' => 'sector_id',
        ]);
        $this->hasMany('Rooms', [
            'foreignKey' => 'sector_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('tempo_de_descontaminacao_da_sala_cirurgica');

        $validator
            ->allowEmpty('tempo_de_descontaminacao_de_leito_da_UTI');

        $validator
            ->allowEmpty('tempo_de_descontaminacao_da_sala_cirurgica_contaminada');

        $validator
            ->allowEmpty('tempo_de_descontaminacao_de_leito_da_unidade_de_internacao');

        $validator
            ->allowEmpty('termo_de_consentimento_informado');

        $validator
            ->allowEmpty('modelo_de_boletim_medico_file');

        $validator
            ->allowEmpty('modelo_de_relatorio_medico_padrao_file');

        $validator
            ->allowEmpty('modelo_de_descricao_de_informacao_do_paciente_file');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->requirePresence('name', 'create')
            ->notEmpty('name');

        $validator
            ->integer('limit_of_rooms')
            ->requirePresence('limit_of_rooms', 'create')
            ->notEmpty('limit_of_rooms');

        $validator
            ->numeric('taxa_de_ocupacao')
            ->allowEmpty('taxa_de_ocupacao');

        $validator
            ->numeric('indice_de_giro_de_leito')
            ->allowEmpty('indice_de_giro_de_leito');

        $validator
            ->numeric('intervalo_de_substituicao')
            ->allowEmpty('intervalo_de_substituicao');

        $validator
            ->numeric('faixa_de_internacao_menor_que_24h')
            ->allowEmpty('faixa_de_internacao_menor_que_24h');

        $validator
            ->numeric('faixa_de_internacao_ate_7_dias')
            ->allowEmpty('faixa_de_internacao_ate_7_dias');

        $validator
            ->numeric('faixa_de_internacao_ate_21_dias')
            ->allowEmpty('faixa_de_internacao_ate_21_dias');

        $validator
            ->numeric('faixa_de_internacao_superior_28_dias')
            ->allowEmpty('faixa_de_internacao_superior_28_dias');

        $validator
            ->numeric('taxa_de_reinternacao')
            ->allowEmpty('taxa_de_reinternacao');

        $validator
            ->numeric('tempo_medio_decisao_de_alta_e_alta_efetiva')
            ->allowEmpty('tempo_medio_decisao_de_alta_e_alta_efetiva');

        $validator
            ->numeric('tempo_medio_permanencia_paciente_em_obito')
            ->allowEmpty('tempo_medio_permanencia_paciente_em_obito');

        $validator
            ->numeric('total_de_pacientes_no_mes')
            ->allowEmpty('total_de_pacientes_no_mes');

        $validator
            ->numeric('percentual_de_altas')
            ->allowEmpty('percentual_de_altas');

        $validator
            ->numeric('tempo_de_permanencia_minimo')
            ->allowEmpty('tempo_de_permanencia_minimo');

        $validator
            ->numeric('tempo_de_permanencia_medio')
            ->allowEmpty('tempo_de_permanencia_medio');

        $validator
            ->numeric('tempo_de_permanencia_maximo')
            ->allowEmpty('tempo_de_permanencia_maximo');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['unit_id'], 'Units'));
        $rules->add($rules->existsIn(['type_id'], 'Types'));
        return $rules;
    }
}
