<?php
namespace App\Model\Table;

use App\Model\Entity\PotentialOrgan;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PotentialOrgans Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Organs
 * @property \Cake\ORM\Association\BelongsTo $SuspectedMeProtocols
 */
class PotentialOrgansTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('organs');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsToMany('SuspectedMeProtocols', [
            'foreignKey' => 'organ_id',
            'targetForeignKey' => 'suspected_me_protocol_id',
            'joinTable' => 'potential_organs_suspected_me_protocols'
        ]);
    }


    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('nome');

        return $validator;
    }
}
