<?php
namespace App\Model\Table;

use App\Model\Entity\PavPreventionBundle;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * PavPreventionBundles Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsTo $Professionals
 */
class PavPreventionBundlesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */

    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->addBehavior('Timestamp');

        $this->table('pav_prevention_bundles');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Professionals', [
            'foreignKey' => 'professional_id',
            'joinType' => 'INNER',
        ]);

        $this->belongsTo('Screenings', [
            'foreignKey' => 'screening_id',
            'joinType' => 'INNER',
        ]);

        $this->hasMany('PavDiaryChecklists', [
            'foreignKey' => 'pav_prevention_bundle_id',
        ]);

        $this->belongsToMany('ImmediateComplications', [
            'foreignKey' => 'pav_prevention_bundle_id',
            'targetForeignKey' => 'immediate_complication_id',
            'joinTable' => 'immediate_complications_pav_prevention_bundles',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
        // ->date('data_da_instalacao')
        ->requirePresence('data_da_instalacao', 'create')
            ->notEmpty('data_da_instalacao');

        $validator
        // ->time('hora_da_instalacao')
        ->requirePresence('hora_da_instalacao', 'create')
            ->notEmpty('hora_da_instalacao');

        $validator
            ->requirePresence('tipo_de_dispositivo', 'create')
            ->notEmpty('tipo_de_dispositivo');

        $validator
            ->allowEmpty('tamanho_do_tot');

        $validator
            ->allowEmpty('mascara_laringea');

        $validator
            ->allowEmpty('traqueostomia');

        $validator
            ->boolean('verificado_o_risco_de_vad')
            ->allowEmpty('verificado_o_risco_de_vad');

        $validator
            ->boolean('tci_foi_preenchido')
            ->allowEmpty('tci_foi_preenchido');

        $validator
            ->boolean('procedimento_a_ser_realizado_foi_prescrito')
            ->allowEmpty('procedimento_a_ser_realizado_foi_prescrito');

        $validator
            ->allowEmpty('observacao');

        $validator
            ->boolean('higienizacao_adequada_das_maos')
            ->allowEmpty('higienizacao_adequada_das_maos');

        $validator
            ->boolean('uso_de_paramentacao_gorro')
            ->allowEmpty('uso_de_paramentacao_gorro');

        $validator
            ->boolean('esvaziamento_gastrico')
            ->allowEmpty('esvaziamento_gastrico');

        $validator
            ->boolean('uso_de_degermacao')
            ->allowEmpty('uso_de_degermacao');

        $validator
            ->boolean('uso_de_vni_previo_a_intubacao')
            ->allowEmpty('uso_de_vni_previo_a_intubacao');

        $validator
            ->boolean('pococionamento_adequado_do_paciente')
            ->allowEmpty('pococionamento_adequado_do_paciente');

        $validator
            ->boolean('uso_de_laringoscpio')
            ->allowEmpty('uso_de_laringoscpio');

        $validator
            ->boolean('utilizacao_de_bnm')
            ->allowEmpty('utilizacao_de_bnm');

        $validator
            ->boolean('intubacao_esofageana')
            ->allowEmpty('intubacao_esofageana');

        $validator
            ->allowEmpty('durante_procedimento_observacao');

        $validator
            ->allowEmpty('local_de_insercao');

        $validator
            ->boolean('intubacao_unica')
            ->allowEmpty('intubacao_unica');

        $validator
            ->integer('numero_de_tentativas')
            ->allowEmpty('numero_de_tentativas');

        $validator
            ->allowEmpty('uso_do_kit_vad');

        $validator
            ->allowEmpty('sucesso_na_insercao');

        $validator
            ->allowEmpty('controle_radiologico');

        $validator
            ->integer('numero_de_profissionais')
            ->allowEmpty('numero_de_profissionais');

        $validator
            ->allowEmpty('outra_informacao');

        $validator
            ->allowEmpty('complicacoes_imediatas');

        $validator
        // ->date('data_da_retirada')
        ->allowEmpty('data_da_retirada');

        $validator
        // ->time('hora_da_retirada')
        ->allowEmpty('hora_da_retirada');

        $validator
            ->boolean('retirada_acidental')
            ->allowEmpty('retirada_acidental');

        $validator
            ->allowEmpty('motivo_da_retirada_acidental');

        return $validator;
    }

    public function getRelatorioData($hospitalizations)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,
            'patient_ids' => [],
            'instalacao_por_paciente' => 0,
            'tamanho_do_tot' => [
                'val' => 0,
            ],
            'tentativa_unica' => [
                'percentual' => 0,
                'total' => 0,
            ],
            'numero_de_tentativas' => [
                'sum' => 0,
            ],
        ];
        $percentual = [];

        foreach ($hospitalizations as $hospitalization)
        {
            if (!in_array($hospitalization['patient_id'], $data['patient_ids']))
            {
                array_push($data['patient_ids'], $hospitalization['patient_id']);
            }

            //$data = $hospitalization["neonatal_checklists"];
            foreach ($hospitalization["pav_prevention_bundles"] as $key_1 => $neonatal)
            {
                $neonatal_arr = (array) $neonatal;
                $i = 0;

                $data['total_de_registros']++;

                foreach ($neonatal_arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            if (isset($data[$key]['arr']))
            {
                $marcados = 0;

                $len = count($data[$key]['arr']);

                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }

                if (isset($data[$key]['percentual']))
                {
                    $data[$key]['total'] = count($data[$key]['arr']);
                    $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                    $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                    $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                    $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
                }
            }
        }

        if (isset($data['tipo_de_dispositivo']))
        {
            $data['tipo_de_dispositivo']['orotraqueal'] = 0;
            $data['tipo_de_dispositivo']['nasotraqueal'] = 0;
            $data['tipo_de_dispositivo']['traqueostomia'] = 0;

            foreach ($data['tipo_de_dispositivo'] as $key_dispositivo => $dispositivo)
            {
                switch ($dispositivo)
                {
                    case 'Tubo Orotraqueal':
                        $data['tipo_de_dispositivo']['orotraqueal']++;
                        break;

                    case 'Tubo Nasotraqueal':
                        $data['tipo_de_dispositivo']['nasotraqueal']++;
                        break;

                    case 'Cânula de Traqueostomia':
                        $data['tipo_de_dispositivo']['traqueostomia']++;
                        break;
                }
            }

            if ($data['tipo_de_dispositivo']['orotraqueal'] > 0)
            {
                $data['tipo_de_dispositivo']['orotraqueal'] = ($data['tipo_de_dispositivo']['orotraqueal'] * 100) / $data['total_de_registros'];
            }

            if ($data['tipo_de_dispositivo']['nasotraqueal'] > 0)
            {
                $data['tipo_de_dispositivo']['nasotraqueal'] = ($data['tipo_de_dispositivo']['nasotraqueal'] * 100) / $data['total_de_registros'];
            }

            if ($data['tipo_de_dispositivo']['traqueostomia'] > 0)
            {
                $data['tipo_de_dispositivo']['traqueostomia'] = ($data['tipo_de_dispositivo']['traqueostomia'] * 100) / $data['total_de_registros'];
            }
        }

        if ($data['total_de_registros'] > 0 && count($data['patient_ids']) > 0)
        {
            $data['instalacao_por_paciente'] = round(($data['total_de_registros'] * 100) / count($data['patient_ids']), 2);
        }

        if (isset($data['tamanho_do_tot']['arr']) &&
            count($data['tamanho_do_tot']['arr']) > 0)
        {
            foreach ($data['tamanho_do_tot']['arr'] as $key => $value)
            {
                $data['tamanho_do_tot']['val'] += $value;
            }
        }

        if (isset($data['numero_de_tentativas']['arr']) &&
            count($data['numero_de_tentativas']['arr']) > 0)
        {
            $tot_tentativa_unica = 0;
            $sum_tentativa = count($data['numero_de_tentativas']['arr']);
            foreach ($data['numero_de_tentativas']['arr'] as $key => $value)
            {
                $data['numero_de_tentativas']['sum'] += $value;
                if ($value == 1)
                {
                    $tot_tentativa_unica++;
                }
            }
            $data['tentativa_unica']['total'] = $tot_tentativa_unica;
            $data['tentativa_unica']['percentual'] = round(($tot_tentativa_unica * 100) / $sum_tentativa, 2);
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        $rules->add($rules->existsIn(['professional_id'], 'Professionals'));
        return $rules;
    }
}
