<?php
namespace App\Model\Table;

use App\Model\Entity\MedicalCare;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * MedicalCares Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Screenings
 * @property \Cake\ORM\Association\HasMany $Diagnostics
 * @property \Cake\ORM\Association\HasMany $HabitualMedications
 * @property \Cake\ORM\Association\HasMany $Hpps
 * @property \Cake\ORM\Association\HasMany $MedicationReconciliations
 * @property \Cake\ORM\Association\HasMany $PhysicalExams
 * @property \Cake\ORM\Association\HasMany $RelevantComplementaryExams
 */
class MedicalCaresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('medical_cares');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Screenings', [
            'foreignKey' => 'screening_id',
            'joinType' => 'INNER'
        ]);
        $this->hasMany('Diagnostics', [
            'foreignKey' => 'medical_care_id'
        ]);
        $this->hasMany('HabitualMedications', [
            'foreignKey' => 'medical_care_id'
        ]);
        $this->hasMany('Hpps', [
            'foreignKey' => 'medical_care_id'
        ]);
        $this->hasMany('MedicationReconciliations', [
            'foreignKey' => 'medical_care_id'
        ]);
        $this->hasMany('PhysicalExams', [
            'foreignKey' => 'medical_care_id'
        ]);
        $this->hasMany('RelevantComplementaryExams', [
            'foreignKey' => 'medical_care_id'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->allowEmpty('hda');

        $validator
            ->boolean('isolamento')
            ->allowEmpty('isolamento');

        $validator
            ->allowEmpty('motivo_isolamento');

        $validator
            ->allowEmpty('hpp');

        $validator
            ->allowEmpty('outras_patologias');

        $validator
            ->allowEmpty('status');

        $validator
            ->allowEmpty('pre_deliric');

        $validator
            ->allowEmpty('glasgow');

        $validator
            ->allowEmpty('rass');

        $validator
            ->allowEmpty('cpot');

        $validator
            ->allowEmpty('sofa');

        $validator
            ->allowEmpty('plano_terapeutico');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['screening_id'], 'Screenings'));
        return $rules;
    }
}
