<?php
namespace App\Model\Table;

use App\Model\Entity\ListAntibioticsCulture;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ListAntibioticsCultures Model
 *
 * @property \Cake\ORM\Association\BelongsTo $ListAntibiotics
 * @property \Cake\ORM\Association\BelongsTo $Cultures
 */
class ListAntibioticsCulturesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('list_antibiotics_cultures');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('ListAntibiotics', [
            'foreignKey' => 'list_antibiotic_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Cultures', [
            'foreignKey' => 'culture_id',
            'joinType'   => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['list_antibiotic_id'], 'ListAntibiotics'));
        $rules->add($rules->existsIn(['culture_id'], 'Cultures'));
        return $rules;
    }
}
