<?php
namespace App\Model\Table;

use App\Model\Entity\ImmediateComplication;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ImmediateComplications Model
 *
 * @property \Cake\ORM\Association\BelongsToMany $Bundles
 */
class ImmediateComplicationsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('immediate_complications');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsToMany('Bundles', [
            'foreignKey' => 'immediate_complication_id',
            'targetForeignKey' => 'bundle_id',
            'joinTable' => 'bundles_immediate_complications'
        ]);

        $this->belongsToMany('PavPreventionBundles', [
            'foreignKey'       => 'immediate_complication_id',
            'targetForeignKey' => 'pav_prevention_bundle_id',
            'joinTable'        => 'immediate_complications_pav_prevention_bundles'
        ]);

        $this->belongsToMany('ItuPreventionBundles', [
            'foreignKey'       => 'immediate_complication_id',
            'targetForeignKey' => 'itu_prevention_bundle_id',
            'joinTable'        => 'immediate_complications_itu_prevention_bundles'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('nome', 'create')
            ->notEmpty('nome');

        return $validator;
    }
}
