<?php
namespace App\Model\Table;

use App\Model\Entity\IdentificationOfRisk;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * IdentificationOfRisks Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class IdentificationOfRisksTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('identification_of_risks');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->allowEmpty('alergia');

        $validator
            ->boolean('ignorancia')
            ->allowEmpty('ignorancia');

        $validator
            ->boolean('administracao')
            ->allowEmpty('administracao');

        $validator
            ->boolean('reconcializacao')
            ->allowEmpty('reconcializacao');

        $validator
            ->boolean('transporte_inseguro')
            ->allowEmpty('transporte_inseguro');

        $validator
            ->boolean('identificacao_errada_do_paciente')
            ->allowEmpty('identificacao_errada_do_paciente');

        $validator
            ->boolean('controle_inadequado')
            ->allowEmpty('controle_inadequado');

        $validator
            ->boolean('perda_da_passagem')
            ->allowEmpty('perda_da_passagem');

        $validator
            ->boolean('que_do_leito')
            ->allowEmpty('que_do_leito');

        $validator
            ->boolean('turnover')
            ->allowEmpty('turnover');

        $validator
            ->boolean('absenteismo')
            ->allowEmpty('absenteismo');

        $validator
            ->boolean('nao_parametrizacao_da_monitorizacao')
            ->allowEmpty('nao_parametrizacao_da_monitorizacao');

        $validator
            ->boolean('contaminacao_de_culturas')
            ->allowEmpty('contaminacao_de_culturas');

        $validator
            ->boolean('coleta_inadequada_de_culturas')
            ->allowEmpty('coleta_inadequada_de_culturas');

        $validator
            ->boolean('broncoaspiracao')
            ->allowEmpty('broncoaspiracao');

        $validator
            ->boolean('infeccao_de_corrente')
            ->allowEmpty('infeccao_de_corrente');

        $validator
            ->boolean('pneumonia')
            ->allowEmpty('pneumonia');

        $validator
            ->boolean('infeccao_de_trato')
            ->allowEmpty('infeccao_de_trato');

        $validator
            ->boolean('reacao_transfusional')
            ->allowEmpty('reacao_transfusional');

        $validator
            ->boolean('nao_acompanhamento')
            ->allowEmpty('nao_acompanhamento');

        $validator
            ->boolean('reinteracao')
            ->allowEmpty('reinteracao');

        $validator
            ->boolean('extubacao_acidental')
            ->allowEmpty('extubacao_acidental');

        $validator
            ->boolean('feblite')
            ->allowEmpty('feblite');

        $validator
            ->boolean('dor')
            ->allowEmpty('dor');

        $validator
            ->boolean('troca_de_pacientes')
            ->allowEmpty('troca_de_pacientes');

        $validator
            ->boolean('fornecimento_de_medicamentos_incorretos')
            ->allowEmpty('fornecimento_de_medicamentos_incorretos');

        $validator
            ->boolean('nao_administracao_de_dietas')
            ->allowEmpty('nao_administracao_de_dietas');

        $validator
            ->boolean('administracao_inadequada_de_dieta')
            ->allowEmpty('administracao_inadequada_de_dieta');

        $validator
            ->boolean('diarreia')
            ->allowEmpty('diarreia');

        $validator
            ->boolean('nao_fornecimento_de_materiais')
            ->allowEmpty('nao_fornecimento_de_materiais');

        return $validator;
    }

    public function getRelatorioData($hospitalizations)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,
        ];
        $percentual = [];

        foreach ($hospitalizations as $hospitalization)
        {
            //$data = $hospitalization["neonatal_checklists"];
            foreach ($hospitalization["identification_of_risks"] as $key_1 => $neonatal)
            {
                $neonatal_arr = (array) $neonatal;
                $i = 0;

                $data['total_de_registros']++;

                foreach ($neonatal_arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;

            $len = count($data[$key]['arr']);

            for ($i = 0; $i < $len; $i++)
            {
                if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                {
                    $marcados++;
                }
            }

            if (isset($data[$key]['percentual']))
            {
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
