<?php
namespace App\Model\Table;

use App\Model\Entity\Echocardiogram;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Echocardiograms Model
 *
 * @property \Cake\ORM\Association\BelongsToMany $ChestPainProtocols
 */
class EchocardiogramsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('echocardiograms');
        $this->displayField('name');
        $this->primaryKey('id');

        $this->belongsToMany('ChestPainProtocols', [
            'foreignKey' => 'echocardiogram_id',
            'targetForeignKey' => 'chest_pain_protocol_id',
            'joinTable' => 'chest_pain_protocols_echocardiograms'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('name');

        return $validator;
    }
}
