<?php
namespace App\Model\Table;

use App\Model\Entity\DailySafetyChecklist;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * DailySafetyChecklists Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\HasMany $Procedures
 */
class DailySafetyChecklistsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('daily_safety_checklists');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
        $this->hasMany('Procedures', [
            'foreignKey' => 'daily_safety_checklist_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('cabeceira_de_leito_elevado');

        $validator
            ->allowEmpty('prevenção_de_lesao_aguda_de_mucosa_gastrica');

        $validator
            ->allowEmpty('profilaxia_de_tev');

        $validator
            ->allowEmpty('suporte_nutricional');

        $validator
            ->boolean('protocolo_de_controle_glicemico')
            ->allowEmpty('protocolo_de_controle_glicemico');

        $validator
            ->allowEmpty('total_de_insulina_sub_cutanea_nas_24_horas');

        $validator
            ->boolean('fez_insulina_venosa')
            ->allowEmpty('fez_insulina_venosa');

        $validator
            ->allowEmpty('total_de_insulina_venosa_nas_24_horas');

        $validator
            ->integer('total_glicemias_menor_que_60')
            ->allowEmpty('total_glicemias_menor_que_60');

        $validator
            ->boolean('sedacao')
            ->allowEmpty('sedacao');

        $validator
            ->boolean('sob_analgesia')
            ->allowEmpty('sob_analgesia');

        $validator
            ->boolean('delirium')
            ->allowEmpty('delirium');

        $validator
            ->boolean('teve_dor_nas_ultimas_24_horas')
            ->allowEmpty('teve_dor_nas_ultimas_24_horas');

        $validator
            ->boolean('ventilacao_mecanica_invasiva')
            ->allowEmpty('ventilacao_mecanica_invasiva');

        $validator
            ->boolean('pa2_fio2_menor_que_300')
            ->allowEmpty('pa2_fio2_menor_que_300');

        $validator
            ->boolean('volume_corrente_menor_que_8')
            ->allowEmpty('volume_corrente_menor_que_8');

        $validator
            ->boolean('pressao_de_plato_menor_que_30')
            ->allowEmpty('pressao_de_plato_menor_que_30');

        $validator
            ->boolean('iniciar_desmane')
            ->allowEmpty('iniciar_desmane');

        $validator
            ->boolean('iniciar_peca_t')
            ->allowEmpty('iniciar_peca_t');

        $validator
            ->boolean('cateter_venoso_central')
            ->allowEmpty('cateter_venoso_central');

        $validator
            ->boolean('cateter_venoso_central_can_be_removed')
            ->allowEmpty('cateter_venoso_central_can_be_removed');

        $validator
            ->boolean('cateter_vesical_de_demora')
            ->allowEmpty('cateter_vesical_de_demora');

        $validator
            ->boolean('cateter_vesical_de_demora_can_be_removed')
            ->allowEmpty('cateter_vesical_de_demora_can_be_removed');

        $validator
            ->boolean('antibioticos')
            ->allowEmpty('antibioticos');

        $validator
            ->boolean('antibioticos_can_be_removed')
            ->allowEmpty('antibioticos_can_be_removed');

        $validator
            ->boolean('corticoesteroides')
            ->allowEmpty('corticoesteroides');

        $validator
            ->boolean('corticoesteroides_can_be_removed')
            ->allowEmpty('corticoesteroides_can_be_removed');

        $validator
            ->boolean('cateter_arterial_can_be_removed')
            ->allowEmpty('cateter_arterial_can_be_removed');

        $validator
            ->boolean('cateter_arterial')
            ->allowEmpty('cateter_arterial');

        $validator
            ->boolean('total_de_afericoes')
            ->allowEmpty('total_de_afericoes');

        $validator
            ->boolean('afericoes_maior_180')
            ->allowEmpty('afericoes_maior_180');

        $validator
            ->boolean('fez_insulina_ultimas_24_h')
            ->allowEmpty('fez_insulina_ultimas_24_h');

        $validator
            ->allowEmpty('total_insulina_ultimas_24_h');

        $validator
            ->boolean('total_afericoes_glicemicas')
            ->allowEmpty('total_afericoes_glicemicas');

        $validator
            ->integer('total_glicemias_menor_que_60')
            ->allowEmpty('total_glicemias_maior_que_180');

        $validator
            ->boolean('protocolo_glicemico')
            ->allowEmpty('protocolo_glicemico');

        $validator
            ->boolean('uso_de_sedacao')
            ->allowEmpty('uso_de_sedacao');

        $validator
            ->boolean('sedacao_dentro_da_meta')
            ->allowEmpty('sedacao_dentro_da_meta');

        $validator
            ->allowEmpty('interrupcao_sedacao');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->boolean('protocolo_higienico_oral')
            ->allowEmpty('protocolo_higienico_oral');

        $validator
            ->boolean('aspiracao_da_secrecao')
            ->allowEmpty('aspiracao_da_secrecao');

        $validator
            ->allowEmpty('necessidade_de_profilaxia');

        $validator
            ->boolean('atingiu_vet_pleno')
            ->allowEmpty('atingiu_vet_pleno');

        $validator
            ->allowEmpty('via_de_nutricao');

        $validator
            ->boolean('avaliacao_delirium_pelo_camicu')
            ->allowEmpty('avaliacao_delirium_pelo_camicu');

        $validator
            ->boolean('paciente_sob_ventilacao_espontanea')
            ->allowEmpty('paciente_sob_ventilacao_espontanea');

        return $validator;
    }

    public function getRelatorioData($hospitalizations)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,

            'clinica' => [
                'arr' => [],
                'total' => 0,
            ],

            'cirurgica' => [
                'arr' => [],
                'total' => 0,
            ],

            'eletiva' => [
                'arr' => [],
                'total' => 0,
            ],

            'geral' => [
                'arr' => [],
                'total' => 0,
            ],
        ];
        $percentual = [];

        foreach ($hospitalizations as $hospitalization)
        {
            //calcula total de pacientes
            $hospitalization_type = null;
            if (strpos($value['type'], 'Clínica') !== false)
            {
                $hospitalization_type = 'clinica';
            }

            if (strpos($value['type'], 'Cirúr') !== false)
            {
                $hospitalization_type = 'cirurgica';
            }

            if (strpos($value['type'], 'letiva') !== false)
            {
                $hospitalization_type = 'eletiva';
            }

            //verifica se o id do paciente já existe no array
            if (in_array($data[$hospitalization_type]['arr'], $arr['patients_id']) == false)
            {
                array_push($data[$hospitalization_type]['arr'], $hospitalization['patient_id']);
                $data[$hospitalization_type]['total']++;
                $data['geral']['total']++;
            }

            foreach ($hospitalization["daily_safety_checklists"] as $key_1 => $neonatal)
            {
                $neonatal_arr = (array) $neonatal;
                $i = 0;

                $data['total_de_registros']++;

                foreach ($neonatal_arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }

            foreach ($hospitalization["daily_safety_checklists"] as $key_1 => $neonatal)
            {
                $neonatal_arr = (array) $neonatal;
                $i = 0;

                $data['total_de_registros']++;

                foreach ($neonatal_arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            $this->formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;

            $len = count($data[$key]['arr']);

            for ($i = 0; $i < $len; $i++)
            {
                if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                {
                    $marcados++;
                }
            }

            if (isset($data[$key]['percentual']))
            {
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }

            if (count($data['geral']['total']) > 0)
            {
                if ($data['clinica']['total'] > 0)
                {
                    $data['clinica']['percentual'] = ($data['clinica']['total'] * 100) / $data['geral']['total'];
                }

                if ($data['eletiva']['total'] > 0)
                {
                    $data['eletiva']['percentual'] = ($data['eletiva']['total'] * 100) / $data['geral']['total'];
                }

                if ($data['cirurgica']['total'] > 0)
                {
                    $data['cirurgica']['percentual'] = ($data['cirurgica']['total'] * 100) / $data['geral']['total'];
                }
            }
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
