<?php
namespace App\Model\Table;

use App\Model\Entity\ChangeTypeOfAnesthesia;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ChangeTypeOfAnesthesias Model
 *
 * @property \Cake\ORM\Association\BelongsToMany $Surgeries
 */
class ChangeTypeOfAnesthesiasTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('change_type_of_anesthesias');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsToMany('Surgeries', [
            'foreignKey' => 'change_type_of_anesthesia_id',
            'targetForeignKey' => 'surgery_id',
            'joinTable' => 'change_type_of_anesthesias_surgeries'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('nome', 'create')
            ->notEmpty('nome');

        return $validator;
    }
}
