<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Sector Entity.
 *
 * @property int $id
 * @property string $tempo_de_descontaminacao_da_sala_cirurgica
 * @property string $tempo_de_descontaminacao_de_leito_da_UTI
 * @property string $tempo_de_descontaminacao_da_sala_cirurgica_contaminada
 * @property string $tempo_de_descontaminacao_de_leito_da_unidade_de_internacao
 * @property string $termo_de_consentimento_informado
 * @property string $modelo_de_boletim_medico_file
 * @property string $modelo_de_relatorio_medico_padrao_file
 * @property string $modelo_de_descricao_de_informacao_do_paciente_file
 * @property int $unit_id
 * @property \App\Model\Entity\Unit $unit
 * @property int $type_id
 * @property \App\Model\Entity\Type $type
 * @property bool $is_active
 * @property string $name
 * @property int $limit_of_rooms
 * @property float $taxa_de_ocupacao
 * @property float $indice_de_giro_de_leito
 * @property float $intervalo_de_substituicao
 * @property float $faixa_de_internacao_menor_que_24h
 * @property float $faixa_de_internacao_ate_7_dias
 * @property float $faixa_de_internacao_ate_21_dias
 * @property float $faixa_de_internacao_superior_28_dias
 * @property float $taxa_de_reinternacao
 * @property float $tempo_medio_decisao_de_alta_e_alta_efetiva
 * @property float $tempo_medio_permanencia_paciente_em_obito
 * @property float $total_de_pacientes_no_mes
 * @property float $percentual_de_altas
 * @property float $tempo_de_permanencia_minimo
 * @property float $tempo_de_permanencia_medio
 * @property float $tempo_de_permanencia_maximo
 * @property \App\Model\Entity\IndicatorsSector[] $indicators_sectors
 * @property \App\Model\Entity\Professional[] $professionals
 * @property \App\Model\Entity\Room[] $rooms
 * @property \App\Model\Entity\MedicalOpinionRequest[] $medical_opinion_requests
 * @property \App\Model\Entity\Hospitalization[] $hospitalizations
 */
class Sector extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];

    public function redirectSector($type_id = null){
        $emergencia = ['1', '2', '3'];
        $unidade_internacao = ['7','8'];
        $terapia_intensiva = ['12', '13', '14'];
        $centro_cirurgico = ['4'];
        $value = '/Sectors/listSectorPatients/';

        if(in_array($type_id, $emergencia)){
            $value = '/Sectors/listSectorPatientsEmergency/';
        }
        else if(in_array($type_id, $unidade_internacao)){
            $value = '/Sectors/listSectorPatientsHospitalizationUnits/';
        }
        else if(in_array($type_id, $terapia_intensiva)){
            $value = '/Sectors/listSectorPatientsIntensiveCareUnits/';
        }
        else if(in_array($type_id, $centro_cirurgico)){
            $value = '/Sectors/listSectorPatientsSurgeries/';
        }

        return $value;
        //$sector = $this->Sectors->get($id);
        //return $sector;
    }
}
