<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Screening Entity.
 *
 * @property int $id
 * @property \Cake\I18n\Time $created
 * @property int $patient_id
 * @property \App\Model\Entity\Patient $patient
 * @property bool $is_active
 * @property int $unit_id
 * @property \App\Model\Entity\Unit $unit
 * @property string $pas
 * @property string $temp
 * @property string $sato2
 * @property string $fc
 * @property string $fr
 * @property string $glicemia
 * @property bool $parada_cardiaca_ou_suspeita
 * @property string $fraquesa_muscular
 * @property string $fraquesa_muscular_tipo
 * @property string $perda_sensorial
 * @property string $perda_sensorial_tipo
 * @property string $alteracao_consciencia
 * @property string $queixa_principal
 * @property bool $tem_alergia
 * @property string $alergias
 * @property bool $uso_medicacao_regular
 * @property string $medicacao_regular
 * @property string $resumo_da_queixa
 * @property string $localizacao_da_dor
 * @property string $aparecimento_da_dor
 * @property bool $dor_toracica_em_aperto
 * @property bool $dor_toracica_dispineia
 * @property bool $dor_toracica_assimetria_dos_pulsos
 * @property bool $dor_toracica_historico_de_coronariopatia
 * @property bool $dor_toracica_historico_de_avc
 * @property bool $dor_toracica_trauma_toracico_antecedente
 * @property bool $dor_abdominal_historico_de_trauma
 * @property bool $dor_abdominal_diarreia
 * @property bool $dor_abdominal_nausea
 * @property bool $dor_abdominal_vomitos
 * @property bool $cefaleia_rigidez_da_nuca
 * @property bool $cefaleia_vomitos
 * @property bool $cefaleia_episodio_de_crise_convulsiva
 * @property bool $ceruicalgia_historico_progresso_calculo_renal
 * @property bool $ceruicalgia_transplatandos_e_em_quimioterapia
 * @property bool $ceruicalgia_alteracao_de_esfincter
 * @property bool $dispneia_desconforto
 * @property bool $dispneia_cianose
 * @property bool $dispneia_utilizacao_da_musculatura
 * @property bool $dispneia_dificuldade_para_falar
 * @property bool $dispneia_historico_de_asma
 * @property bool $dispneia_alteracao_na_ausculta
 * @property bool $diarreia_sinais_de_desidratacao
 * @property bool $diarreia_dor_abdominal
 * @property bool $diarreia_nausea_e_vomito
 * @property bool $diarreia_sinais_vitais_normais
 * @property bool $tosse_dispneia
 * @property bool $tosse_historico_de_hemoptise
 * @property bool $tosse_dor_toracica_ausente
 * @property bool $hemorragia_historico_de_enterorragia
 * @property bool $hemorragia_antecedente_de_cirrose
 * @property bool $queixa_cronica_nao_agudizada
 * @property bool $lesoes_de_pele_escabiose
 * @property bool $lesoes_de_pele_eczema
 * @property bool $lesoes_de_pele_outras_lesoes
 * @property string $intensidade_da_dor
 * @property bool $alt_estado_mental_ausencia_de_resposta
 * @property bool $alt_estado_mental_alteracao_consciencia
 * @property bool $deficit_motor_inicio_subito
 * @property bool $febre_alteracao_nivel_consciencia
 * @property bool $febre_dispneia
 * @property bool $febre_imunossupressao
 * @property bool $hiperglicemia_associada_alteracao
 * @property bool $hipoglicemia_glicemia_capilar
 * @property string $glasgow
 * @property string $classificacao_sugerida
 * @property string $pad
 * @property string $classificacao_selecionada
 * @property bool $portador_necessidas_especiais
 * @property bool $esta_gestente_ou_suspeita
 * @property bool $obstetricia
 * @property int $professional_id
 * @property \App\Model\Entity\Professional $professional
 * @property bool $classificacao_obstetrica
 * @property bool $desmaio_nao_responsivo
 * @property bool $desmaio_choque
 * @property bool $desmaio_saturacao
 * @property bool $desmaio_nao_vermelho
 * @property bool $desmaio_alteracao_consciencia
 * @property bool $desmaio_padrao_respiratorio
 * @property string $desmaio_pas
 * @property bool $desmaio_pa
 * @property bool $desmaio_prelatorio_diabetes
 * @property bool $desmaio_febre
 * @property bool $desmaio_pacientes_imunodeprimidas
 * @property bool $desmaio_encaminhamento_centro
 * @property bool $desmaio_atendimento_nao_prioritario
 * @property bool $abdominal_periodo_expulsivo
 * @property bool $abdominal_prolapso
 * @property bool $abdominal_exteriorizacao
 * @property bool $abdominal_sinais_choque
 * @property string $abdominal_dor
 * @property bool $abdominal_contracoes
 * @property bool $abdominal_hipertonia
 * @property bool $abdominal_pa
 * @property bool $abdominal_perda_liquido
 * @property bool $abdominal_portadora
 * @property bool $abdominal_portadora_hiv
 * @property bool $abdominal_pos_parto
 * @property bool $abdominal_dor_lombar
 * @property bool $abdominal_contracoes_intervalo
 * @property bool $abdominal_ausencia
 * @property bool $abdominal_vitima
 * @property bool $abdominal_febril
 * @property bool $abdominal_perda_liquido_pequena
 * @property bool $abdominal_encaminhamento
 * @property bool $abdominal_atendimento_prioritario
 * @property string $ocular
 * @property string $verbal
 * @property string $motora
 * @property bool $dor_cabeca_apneia
 * @property bool $dor_cabeca_choque
 * @property string $dor_cabeca_alteracao_consciencia
 * @property string $dor_cabeca_pas
 * @property bool $dor_cabeca_pa_maior_140
 * @property bool $dor_cabeca_dor_intensa
 * @property bool $dor_cabeca_disturbios
 * @property bool $dor_cabeca_hipertermia
 * @property bool $dor_cabeca_dor_forte
 * @property bool $dor_cabeca_febre
 * @property bool $dor_cabeca_febril
 * @property bool $dor_cabeca_atendimento
 * @property string $falta_ar_saturacao
 * @property bool $falta_ar_estridor
 * @property bool $falta_ar_choque
 * @property bool $falta_ar_padrao
 * @property string $falta_ar_pas
 * @property bool $cefaleia_inicio_subito
 * @property bool $cefaleia_deficit_motor_agudo
 * @property bool $dor_toracica_dor_precordial
 * @property bool $dor_toracica_irradiacao
 * @property bool $parada_ausecia_pulso
 * @property bool $parada_ausecia_movimentos
 * @property bool $parada_inconsciencia
 * @property \App\Model\Entity\Admission[] $admissions
 * @property \App\Model\Entity\Bundle[] $bundles
 * @property \App\Model\Entity\ClinicTevProtocol[] $clinic_tev_protocols
 * @property \App\Model\Entity\Hospitalization[] $hospitalizations
 * @property \App\Model\Entity\ItuPreventionBundle[] $itu_prevention_bundles
 * @property \App\Model\Entity\MedicalCare[] $medical_cares
 * @property \App\Model\Entity\PavPreventionBundle[] $pav_prevention_bundles
 * @property \App\Model\Entity\SafeSurgeryBundle[] $safe_surgery_bundles
 * @property \App\Model\Entity\SepseProtocol[] $sepse_protocols
 * @property \App\Model\Entity\SurgicalTevProtocol[] $surgical_tev_protocols
 * @property \App\Model\Entity\PainCharacteristic[] $pain_characteristics
 */
class Screening extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
