<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * NeonatalChecklist Entity.
 *
 * @property int $id
 * @property bool $paridade
 * @property bool $enfermidades_atuais
 * @property bool $intercorren_pre_parto
 * @property bool $boletim_apgar
 * @property bool $necessidade_reanimacao
 * @property bool $apto_amamentacao
 * @property string $placenta_peso
 * @property bool $coloracao_odor_alterado
 * @property bool $relacao_do_peso_placenta
 * @property bool $cordao_umbilical_presente
 * @property string $ao_nascer_peso
 * @property string $ao_nascer_comprimento
 * @property bool $ao_nascer_classificacao_rn
 * @property bool $iluminacao_aquecimento_adequado
 * @property bool $ictericia
 * @property bool $palidez
 * @property bool $descamacao_fisiologica
 * @property bool $icitose_congenita
 * @property bool $nevos_pgmentosus
 * @property bool $linfomas_cisticos
 * @property bool $escleredema
 * @property bool $petequias_e_purpuras
 * @property bool $hemangioma
 * @property bool $pele_espessa
 * @property bool $visibilidade_vasos_sulcos
 * @property bool $lanugem
 * @property bool $superficie_plantar
 * @property float $distancia_antero_posterior
 * @property float $distancia_biauricular
 * @property string $perimetro_cefalico
 * @property float $indice_cefalico
 * @property string $cranio_classificacao
 * @property bool $hidrocefalia
 * @property bool $craniossinostose
 * @property bool $cefalo_hematoma
 * @property bool $bossa_serossanguinea
 * @property bool $fontanelas_adequadas
 * @property bool $cranio_tabes
 * @property bool $ruidos_intracranianos
 * @property bool $encefalocele
 * @property bool $cartilagem_da_orelha
 * @property bool $face_simetria
 * @property bool $aparencia_sindromica
 * @property bool $implantacao_das_orelhas
 * @property string $distancia_entre_os_olhos
 * @property bool $tamanho_do_queixo
 * @property bool $reflexo_luz_vermelha
 * @property bool $hemorragia_subconjuntival
 * @property bool $estrabismo
 * @property bool $pupila_branca
 * @property bool $opacificacao_cornea
 * @property bool $secrecao_ocular_presente
 * @property bool $forma_tamanho_implantacao
 * @property bool $permeabilidade_nasal
 * @property bool $canal_nasolacrimal
 * @property bool $secrecao_nasal
 * @property bool $coloracao_dos_labios
 * @property bool $alteracao_integridade
 * @property bool $fenda_palatina
 * @property bool $lingua_com_tamanho
 * @property bool $dentes_congenitos
 * @property bool $ranula
 * @property bool $perolas_de_epstein
 * @property bool $uvula_bifida
 * @property bool $retrognatia
 * @property bool $arqueamento_do_palato
 * @property bool $ausencia_de_massas
 * @property bool $torcicolo_congenito
 * @property bool $teratoma_cervical
 * @property bool $higroma_cistico
 * @property bool $bocio_congenito
 * @property string $perimetro_toracico
 * @property bool $torax_simetria
 * @property bool $retracoes_sub_intercostais
 * @property bool $retracoes_supra_claviculares
 * @property bool $ausencia_claviculas
 * @property bool $disostose_cleido
 * @property bool $fraturas
 * @property bool $assimetria
 * @property bool $distancia_intermamilar
 * @property bool $presencao_de_mamilos
 * @property string $inspecao
 * @property bool $pulsos_sincronia
 * @property bool $pulsos_equivalentes
 * @property bool $palpacao_precordio
 * @property string $pressao_pulsatil
 * @property bool $desdobramento_de_b1
 * @property bool $reducao_intensidade
 * @property bool $aumento_intensidade_b1
 * @property bool $desdobramento_amplo_b2
 * @property bool $hiperfonese_b2
 * @property bool $presenca_de_b3
 * @property bool $presenca_de_b4
 * @property bool $presenca_de_estalido_abertura
 * @property bool $presenca_de_sopro
 * @property string $gemencia
 * @property string $batimento_de_asa_nariz
 * @property string $tiragem_intercostal
 * @property string $retracao_esternal
 * @property string $balancim
 * @property bool $sinal_dancarina_ventre
 * @property bool $presenca_cripitacao_pulmonar
 * @property bool $presenca_de_roncos
 * @property bool $diminuicao_murmurio_vesicular
 * @property bool $abdome_escavado
 * @property bool $abdome_abaulado
 * @property bool $abdomen_abaulamento
 * @property bool $presenca_circulacao_colateral
 * @property bool $presenca_ondas_peristalticas
 * @property bool $dastase_musculos_reto
 * @property bool $ascite
 * @property bool $visceromegalias
 * @property bool $distencao_gasosa
 * @property bool $presenca_de_massa_palpavel
 * @property bool $ausencia_de_ruidos
 * @property bool $genitalia_ambigua
 * @property string $anomalias_anonetai
 * @property bool $comprimento_do_penis_adequado
 * @property string $orificio_uretral
 * @property bool $prepucio_sem_restricao
 * @property string $testiculos
 * @property bool $presenca_de_hemias
 * @property bool $presenca_de_hidroceles
 * @property bool $tamanho_do_clitoris_adequado
 * @property bool $fusao_dos_grandes_labios
 * @property bool $orificio_da_vagina_e_uretra
 * @property bool $distancia_anovulvar
 * @property bool $presenca_de_fistulas
 * @property bool $presenca_de_tumores
 * @property bool $fossetas_hipertricose
 * @property bool $seio_pilonidal
 * @property bool $meningomielocele
 * @property bool $teratoma_sacroroccigeo
 * @property bool $simetira_proprocoes
 * @property bool $paralisia_membros_superiores
 * @property bool $paralisia_membros_inferiores
 * @property bool $artogripose
 * @property bool $pe_torto_congenito
 * @property bool $prega_palmar_unica
 * @property bool $osteocondrodisplasia
 * @property bool $luxacao_congenita
 * @property bool $manobra_ortolani
 * @property bool $manobra_barlow
 * @property bool $urina_nas_primeiras
 * @property bool $ausencia_eleminacao_intestinal
 * @property string $estado_de_sono
 * @property bool $postura_em_flexao
 * @property bool $movimentacao_espontanea
 * @property bool $emissao_de_sons
 * @property bool $tonus_passivo_e_ativo
 * @property bool $manobra_do_arrasto
 * @property bool $rotacao_da_cabeca_em_prono
 * @property bool $manobra_de_tobler
 * @property bool $manobra_do_cachecol
 * @property bool $reflexos_superficiais
 * @property bool $reflexos_arcaicos
 * @property bool $teste_de_voracidade
 * @property bool $teste_de_succao
 * @property bool $preensao_reflexa_artelhos
 * @property bool $piscamento
 * @property bool $retirada_a_estimulacao
 * @property bool $cutaneo_plantar
 * @property bool $extensao_cruzada
 * @property bool $preensao_palmar
 * @property bool $manobra_do_rasto
 * @property bool $reflexo_de_moro
 * @property bool $reflexo_tonico_cervical_assimetrico
 * @property bool $apoio_plantar
 * @property bool $marcha_reflexa
 * @property bool $rotacao_da_cabeca
 * @property bool $reflexo_de_galant
 * @property bool $reflexos_de_landau
 * @property bool $teste_do_nervo_optico
 * @property bool $teste_dos_olhos_de_boneca
 * @property bool $reflexo_vestibulo_coclear
 * @property bool $reflexo_cocleo_palpebral
 * @property bool $reflexos_miotaticos
 * @property bool $teste_de_sensibilidade
 * @property \Cake\I18n\Time $created
 * @property bool $is_active
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 */
class NeonatalChecklist extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
