<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * IndicatorsUnit Entity.
 *
 * @property int $id
 * @property float $taxa_de_ocupacao
 * @property float $indice_de_giro_de_leito
 * @property float $intervalo_de_substituicao
 * @property float $consumo_medio
 * @property float $consumo_diario
 * @property float $consumo_diario_por_paciente
 * @property float $ticket_medio
 * @property float $ticket_diario
 * @property float $ticket_diario_por_paciente
 * @property float $ticket_por_internacao
 * @property float $glossa_total
 * @property float $glossa_por_paciente
 * @property float $faixa_de_internacao_menor_que_24h
 * @property float $taxa_de_reinternacao
 * @property int $unit_id
 * @property \App\Model\Entity\Unit $unit
 * @property float $taxa_internacoes
 * @property int $taxa_internacoes_advertencia
 * @property int $taxa_de_ocupacao_advertencia
 * @property int $indice_de_giro_de_leito_advertencia
 * @property int $intervalo_de_substituicao_advertencia
 * @property int $consumo_medio_advertencia
 * @property int $consumo_diario_advertencia
 * @property int $consumo_diario_por_paciente_advertencia
 * @property int $ticket_medio_advertencia
 * @property int $ticket_diario_advertencia
 * @property int $ticket_diario_por_paciente_advertencia
 * @property int $ticket_por_internacao_advertencia
 * @property int $glossa_total_advertencia
 * @property int $glossa_por_paciente_advertencia
 * @property int $faixa_de_internacao_menor_que_24h_advertencia
 * @property int $taxa_de_reinternacao_advertencia
 * @property float $tempo_medio_permanencia
 * @property int $tempo_medio_permanencia_advertencia
 * @property \Cake\I18n\Time $tempo_cesariana
 * @property int $tempo_cesariana_advertencia
 * @property float $taxa_saida_hospitalar
 * @property int $taxa_saida_hospitalar_advertencia
 * @property float $taxa_mortalidade
 * @property int $taxa_mortalidade_advertencia
 * @property float $taxa_mortalidade_neonatal
 * @property int $taxa_mortalidade_neonatal_advertencia
 * @property float $taxa_mortalidade_pos_ope
 * @property int $taxa_mortalidade_pos_ope_advertencia
 * @property float $taxa_mortalidade_operatoria
 * @property int $taxa_mortalidade_operatoria_advertencia
 * @property float $taxa_letalidade
 * @property string $taxa_letalidade_advertencia
 * @property float $taxa_infeccao_corrente
 * @property int $taxa_infeccao_corrente_advertencia
 * @property float $densidade_cateter_vascular
 * @property int $densidade_cateter_vascular_advertencia
 * @property float $taxa_infeccao_trato
 * @property int $taxa_infeccao_trato_advertencia
 * @property float $densidade_cateter_vesical
 * @property int $densidade_cateter_vesical_advertencia
 * @property float $taxa_pneumonia
 * @property int $taxa_pneumonia_advertencia
 * @property float $densidade_venti_mecanica
 * @property int $densidade_venti_mecanica_advertencia
 * @property float $taxa_infeccao_sitio
 * @property int $taxa_infeccao_sitio_advertencia
 * @property float $taxa_cirurgia_risco
 * @property int $taxa_cirurgia_risco_advertencia
 * @property float $taxa_captacao_morte
 * @property int $taxa_captacao_morte_advertencia
 * @property float $relacao_head_bed
 * @property int $relacao_head_bed_advertencia
 */
class IndicatorsUnit extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
