<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;

/**
 * ItuPreventionBundles Controller
 *
 * @property \App\Model\Table\ItuPreventionBundlesTable $ItuPreventionBundles
 */
class ItuPreventionBundlesController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Bundle - ITU');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);

        $current_state = $session->read('current-state');
        $this->set('current_state', $current_state);

        $screening_id = $session->read('screening_id');
        $this->set('screening_id', $screening_id);

    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Bundles', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations', 'Screenings'],
        ];
        $ituPreventionBundles = $this->paginate($this->ItuPreventionBundles);

        $this->set(compact('ituPreventionBundles'));
        $this->set('_serialize', ['ituPreventionBundles']);
    }

    /**
     * View method
     *
     * @param string|null $id Itu Prevention Bundle id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $ituPreventionBundle = $this->ItuPreventionBundles->get($id, [
            'contain' => ['Hospitalizations', 'Screenings', 'DailyItuPreventionBundles'],
        ]);

        $this->set('ituPreventionBundle', $ituPreventionBundle);
        $this->set('_serialize', ['ituPreventionBundle']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $ituPreventionBundle = $this->ItuPreventionBundles->newEntity();
        if ($this->request->is('post')) {
            $ituPreventionBundle = $this->ItuPreventionBundles->patchEntity($ituPreventionBundle, $this->request->data);
            if ($this->ItuPreventionBundles->save($ituPreventionBundle)) {
                $this->Flash->success(__('The itu prevention bundle has been saved.'));
                return $this->redirect(['controller'=>'Bundles', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The itu prevention bundle could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->ItuPreventionBundles->Hospitalizations->find('list', ['limit' => 200]);
        $screenings       = $this->ItuPreventionBundles->Screenings->find('list', ['limit' => 200]);
        $immediateComplications = $this->ItuPreventionBundles->ImmediateComplications->find('list', ['limit' => 200, 'fields' => ['id', 'nome']])->where(["ImmediateComplications.type <> '1'"]);
        $this->set(compact('ituPreventionBundle', 'hospitalizations', 'screenings', 'immediateComplications'));
        $this->set('_serialize', ['ituPreventionBundle']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Itu Prevention Bundle id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $ituPreventionBundle = $this->ItuPreventionBundles->get($id, [
            'contain' => ['ImmediateComplications'],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $ituPreventionBundle = $this->ItuPreventionBundles->patchEntity($ituPreventionBundle, $this->request->data);
            if ($this->ItuPreventionBundles->save($ituPreventionBundle)) {
                $this->Flash->success(__('The itu prevention bundle has been saved.'));
                return $this->redirect(['controller'=>'Bundles', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The itu prevention bundle could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->ItuPreventionBundles->Hospitalizations->find('list', ['limit' => 200]);
        $screenings       = $this->ItuPreventionBundles->Screenings->find('list', ['limit' => 200]);
        $immediateComplications = $this->ItuPreventionBundles->ImmediateComplications->find('list', ['limit' => 200, 'fields' => ['id', 'nome']])->where(["ImmediateComplications.type <> '1'"]);
        $this->set(compact('ituPreventionBundle', 'hospitalizations', 'screenings', 'immediateComplications'));
        $this->set('_serialize', ['ituPreventionBundle']);
    }

    public function printView($id = null)
    {
        $is_print_view = true;
        $units_table = TableRegistry::get('Units');
        $session     = $this->request->session();

        $unit_id     = $session->read('selected-unit');
        $unit        = $units_table->get($unit_id);


        $ituPreventionBundle = $this->ItuPreventionBundles->get($id, [
            'contain' => ['ImmediateComplications'],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $ituPreventionBundle = $this->ItuPreventionBundles->patchEntity($ituPreventionBundle, $this->request->data);
            if ($this->ItuPreventionBundles->save($ituPreventionBundle)) {
                $this->Flash->success(__('The itu prevention bundle has been saved.'));
                return $this->redirect(['controller'=>'Bundles', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The itu prevention bundle could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->ItuPreventionBundles->Hospitalizations->find('list', ['limit' => 200]);
        $screenings       = $this->ItuPreventionBundles->Screenings->find('list', ['limit' => 200]);
        $immediateComplications = $this->ItuPreventionBundles->ImmediateComplications->find('list', ['limit' => 200, 'fields' => ['id', 'nome']])->where(["ImmediateComplications.type <> '1'"]);
        $this->set(compact('is_print_view','unit','ituPreventionBundle', 'hospitalizations', 'screenings', 'immediateComplications'));
        $this->set('_serialize', ['ituPreventionBundle']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Itu Prevention Bundle id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $ituPreventionBundle = $this->ItuPreventionBundles->get($id);
        if ($this->ItuPreventionBundles->delete($ituPreventionBundle)) {
            $this->Flash->success(__('The itu prevention bundle has been deleted.'));
        } else {
            $this->Flash->error(__('The itu prevention bundle could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
