<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * DischargesSpecialties Controller
 *
 * @property \App\Model\Table\DischargesSpecialtiesTable $DischargesSpecialties
 */
class DischargesSpecialtiesController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Specialties', 'Discharges']
        ];
        $dischargesSpecialties = $this->paginate($this->DischargesSpecialties);

        $this->set(compact('dischargesSpecialties'));
        $this->set('_serialize', ['dischargesSpecialties']);
    }

    /**
     * View method
     *
     * @param string|null $id Discharges Specialty id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $dischargesSpecialty = $this->DischargesSpecialties->get($id, [
            'contain' => ['Specialties', 'Discharges']
        ]);

        $this->set('dischargesSpecialty', $dischargesSpecialty);
        $this->set('_serialize', ['dischargesSpecialty']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $dischargesSpecialty = $this->DischargesSpecialties->newEntity();
        if ($this->request->is('post')) {
            $dischargesSpecialty = $this->DischargesSpecialties->patchEntity($dischargesSpecialty, $this->request->data);
            if ($this->DischargesSpecialties->save($dischargesSpecialty)) {
                $this->Flash->success(__('The discharges specialty has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The discharges specialty could not be saved. Please, try again.'));
            }
        }
        $specialties = $this->DischargesSpecialties->Specialties->find('list', ['limit' => 200]);
        $discharges = $this->DischargesSpecialties->Discharges->find('list', ['limit' => 200]);
        $this->set(compact('dischargesSpecialty', 'specialties', 'discharges'));
        $this->set('_serialize', ['dischargesSpecialty']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Discharges Specialty id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $dischargesSpecialty = $this->DischargesSpecialties->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $dischargesSpecialty = $this->DischargesSpecialties->patchEntity($dischargesSpecialty, $this->request->data);
            if ($this->DischargesSpecialties->save($dischargesSpecialty)) {
                $this->Flash->success(__('The discharges specialty has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The discharges specialty could not be saved. Please, try again.'));
            }
        }
        $specialties = $this->DischargesSpecialties->Specialties->find('list', ['limit' => 200]);
        $discharges = $this->DischargesSpecialties->Discharges->find('list', ['limit' => 200]);
        $this->set(compact('dischargesSpecialty', 'specialties', 'discharges'));
        $this->set('_serialize', ['dischargesSpecialty']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Discharges Specialty id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $dischargesSpecialty = $this->DischargesSpecialties->get($id);
        if ($this->DischargesSpecialties->delete($dischargesSpecialty)) {
            $this->Flash->success(__('The discharges specialty has been deleted.'));
        } else {
            $this->Flash->error(__('The discharges specialty could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
