<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;

/**
 * Discharges Controller
 *
 * @property \App\Model\Table\DischargesTable $Discharges
 */
class DischargesController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Alta Hospitalar');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        return true;
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'ApacheIiScores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $discharges = $this->paginate($this->Discharges);

        $this->set(compact('discharges'));
        $this->set('_serialize', ['discharges']);
    }

    /**
     * View method
     *
     * @param string|null $id Discharge id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $discharge = $this->Discharges->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('discharge', $discharge);
        $this->set('_serialize', ['discharge']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $discharge = $this->Discharges->newEntity();
        if ($this->request->is('post')) {
            $discharge = $this->Discharges->patchEntity($discharge, $this->request->data);
            if ($this->Discharges->save($discharge)) {
                $this->Flash->success(__('The discharge has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The discharge could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->Discharges->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('discharge', 'hospitalizations'));
        $this->set('_serialize', ['discharge']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Discharge id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $hospitalizations      = null;
        $hospitalization_table = TableRegistry::get('Hospitalizations');
        $discharge_exist       = $hospitalization_table->Discharges->find('all',
            ['limit' => 200])->first();

        if ($discharge_exist) {
            $discharge = $this->Discharges->get($discharge_exist->id, [
                'contain' => ['Sectors'],
            ]);
            $hospitalizations = $this->Discharges->Hospitalizations->find('list', ['limit' => 200]);

        } else {
            $discharge = $this->Discharges->newEntity();
        }

        if ($this->request->is(['patch', 'post', 'put'])) {
            $discharge = $this->Discharges->patchEntity($discharge, $this->request->data);
            if ($this->Discharges->save($discharge)) {
                $this->Flash->success(__('The discharge has been saved.'));
                return $this->redirect(['controller' => 'HistoricPatientMovements', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The discharge could not be saved. Please, try again.'));
            }
        }

        $sectors = $this->Discharges->Sectors->find('list', ['fields' => ['id', 'name'], 'limit' => 200]);
        $this->set(compact('discharge', 'hospitalizations', 'sectors'));
        $this->set('_serialize', ['discharge']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Discharge id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $discharge = $this->Discharges->get($id);
        if ($this->Discharges->delete($discharge)) {
            $this->Flash->success(__('The discharge has been deleted.'));
        } else {
            $this->Flash->error(__('The discharge could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
