<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Admissions Controller
 *
 * @property \App\Model\Table\AdmissionsTable $Admissions
 */
class AdmissionsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Escores');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);

        $screening_id = $this->request->session()->read('screening_id');
        $this->set('screening_id', $screening_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'ApacheIiScores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Screenings'],
        ];
        $admissions = $this->paginate($this->Admissions);

        $this->set(compact('admissions'));
        $this->set('_serialize', ['admissions']);
    }

    /**
     * View method
     *
     * @param string|null $id Admission id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $admission = $this->Admissions->get($id, [
            'contain' => ['Screenings', 'HabitualMedications', 'Hpps', 'PhysicalExams', 'RelevantComplementaryExams'],
        ]);

        $this->set('admission', $admission);
        $this->set('_serialize', ['admission']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $admission = $this->Admissions->newEntity();
        if ($this->request->is('post')) {
            $admission = $this->Admissions->patchEntity($admission, $this->request->data);
            if ($this->Admissions->save($admission)) {
                $this->Flash->success(__('The admission has been saved.'));
                return $this->redirect(['controller' => 'Screenings', 'action' => 'index']);
            } else {
                $this->Flash->error(__('O registro foi salvo.'));
            }
        }
        $screenings = $this->Admissions->Screenings->find('list', ['limit' => 200]);
        $this->set(compact('admission', 'screenings'));
        $this->set('_serialize', ['admission']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Admission id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $admission = $this->Admissions->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $admission = $this->Admissions->patchEntity($admission, $this->request->data);
            if ($this->Admissions->save($admission)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['controller' => 'Screenings', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The admission could not be saved. Please, try again.'));
            }
        }
        $screenings = $this->Admissions->Screenings->find('list', ['limit' => 200]);
        $this->set(compact('admission', 'screenings'));
        $this->set('_serialize', ['admission']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Admission id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $admission = $this->Admissions->get($id);
        if ($this->Admissions->delete($admission)) {
            $this->Flash->success(__('The admission has been deleted.'));
        } else {
            $this->Flash->error(__('The admission could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
