<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Sofa Escore']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="sofaEscores index col-md-10 columns content">
    <h3>Sofa Escores</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('respiratorio') ?></th>
                <th><?= $this->Paginator->sort('cardiovascular') ?></th>
                <th><?= $this->Paginator->sort('hematologico') ?></th>
                <th><?= $this->Paginator->sort('renal') ?></th>
                <th><?= $this->Paginator->sort('hepatico') ?></th>
                <th><?= $this->Paginator->sort('neurologico') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($sofaEscores as $sofaEscore): ?>
            <tr>
                <td><?= $this->Number->format($sofaEscore->id) ?></td>
                <td><?= h($sofaEscore->respiratorio) ?></td>
                <td><?= h($sofaEscore->cardiovascular) ?></td>
                <td><?= h($sofaEscore->hematologico) ?></td>
                <td><?= h($sofaEscore->renal) ?></td>
                <td><?= h($sofaEscore->hepatico) ?></td>
                <td><?= h($sofaEscore->neurologico) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $sofaEscore->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $sofaEscore->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $sofaEscore->id], ['confirm' => __('Are you sure you want to delete # {0}?', $sofaEscore->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>