<?php
namespace App\Model\Table;

use App\Model\Entity\MedicalOpinionRequest;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * MedicalOpinionRequests Model
 *
 * @property \Cake\ORM\Association\BelongsTo $RequestedSpecialties
 * @property \Cake\ORM\Association\BelongsTo $Professionals
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\HasMany $MedicalOpinionAnswer
 */
class MedicalOpinionRequestsTable extends Table {

	/**
	 * Initialize method
	 *
	 * @param array $config The configuration for the Table.
	 * @return void
	 */
	public function initialize(array $config) {
		parent::initialize($config);

		$this->table('medical_opinion_requests');
		$this->displayField('id');
		$this->primaryKey('id');

		$this->addBehavior('Timestamp');
		$this->belongsTo('Specialties', [
			'foreignKey' => 'specialty_id',
			'joinType' => 'INNER',
		]);
		$this->belongsTo('Users', [
			'foreignKey' => 'user_id',
			'joinType' => 'INNER',
		]);
		$this->belongsTo('Hospitalizations', [
			'foreignKey' => 'hospitalization_id',
			'joinType' => 'INNER',
		]);
		$this->hasMany('MedicalOpinionAnswers', [
			'foreignKey' => 'medical_opinion_request_id',
		]);
	}

	/**
	 * Default validation rules.
	 *
	 * @param \Cake\Validation\Validator $validator Validator instance.
	 * @return \Cake\Validation\Validator
	 */
	public function validationDefault(Validator $validator) {
		$validator
			->integer('id')
			->allowEmpty('id', 'create');

		$validator
			->requirePresence('motive', 'create')
			->notEmpty('motive');

		return $validator;
	}

	/**
	 * Returns a rules checker object that will be used for validating
	 * application integrity.
	 *
	 * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
	 * @return \Cake\ORM\RulesChecker
	 */
	public function buildRules(RulesChecker $rules) {
		$rules->add($rules->existsIn(['specialty_id'], 'Specialties'));
		$rules->add($rules->existsIn(['user_id'], 'Users'));
		$rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
		return $rules;
	}
}
