<?php
namespace App\Model\Table;

use App\Model\Entity\Hospitalization;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Hospitalizations Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Patients
 * @property \Cake\ORM\Association\BelongsTo $Screenings
 * @property \Cake\ORM\Association\BelongsTo $Origins
 * @property \Cake\ORM\Association\BelongsTo $Units
 * @property \Cake\ORM\Association\BelongsTo $Sectors
 * @property \Cake\ORM\Association\BelongsTo $MedicalCares
 * @property \Cake\ORM\Association\HasMany $ApacheIiScores
 * @property \Cake\ORM\Association\HasMany $BarthelIndexes
 * @property \Cake\ORM\Association\HasMany $BradenScales
 * @property \Cake\ORM\Association\HasMany $Bundles
 * @property \Cake\ORM\Association\HasMany $CardiacSurgeryChecklists
 * @property \Cake\ORM\Association\HasMany $ChestPainProtocols
 * @property \Cake\ORM\Association\HasMany $Comorbidities
 * @property \Cake\ORM\Association\HasMany $CribScores
 * @property \Cake\ORM\Association\HasMany $Cultures
 * @property \Cake\ORM\Association\HasMany $CurbScores
 * @property \Cake\ORM\Association\HasMany $DailySafetyChecklists
 * @property \Cake\ORM\Association\HasMany $Diagnostics
 * @property \Cake\ORM\Association\HasMany $Discharges
 * @property \Cake\ORM\Association\HasMany $FugulinBradenScales
 * @property \Cake\ORM\Association\HasMany $HistoricPatientMovements
 * @property \Cake\ORM\Association\HasMany $IdentificationOfRisks
 * @property \Cake\ORM\Association\HasMany $Infections
 * @property \Cake\ORM\Association\HasMany $InformedConsentForms
 * @property \Cake\ORM\Association\HasMany $Malformations
 * @property \Cake\ORM\Association\HasMany $MedicalBulletins
 * @property \Cake\ORM\Association\HasMany $MedicalOpinionRequests
 * @property \Cake\ORM\Association\HasMany $NasScores
 * @property \Cake\ORM\Association\HasMany $NutritionalAssessments
 * @property \Cake\ORM\Association\HasMany $ObstetricSurgeryChecklists
 * @property \Cake\ORM\Association\HasMany $PavPreventionBundles
 * @property \Cake\ORM\Association\HasMany $PreAnestheticVisits
 * @property \Cake\ORM\Association\HasMany $PreDeliricScores
 * @property \Cake\ORM\Association\HasMany $Prescriptions
 * @property \Cake\ORM\Association\HasMany $SafeSurgeryBundles
 * @property \Cake\ORM\Association\HasMany $SapsIiiScores
 * @property \Cake\ORM\Association\HasMany $SepseProtocols
 * @property \Cake\ORM\Association\HasMany $SkinIntegrities
 * @property \Cake\ORM\Association\HasMany $SnapIiScores
 * @property \Cake\ORM\Association\HasMany $SofaEscores
 * @property \Cake\ORM\Association\HasMany $StrengthAssessmentScales
 * @property \Cake\ORM\Association\HasMany $SupportiveMeasures
 * @property \Cake\ORM\Association\HasMany $Surgeries
 * @property \Cake\ORM\Association\HasMany $SurgicalChecklists
 * @property \Cake\ORM\Association\HasMany $SurgicalTevProtocols
 * @property \Cake\ORM\Association\HasMany $SuspectedMeProtocols
 * @property \Cake\ORM\Association\HasMany $VentilatoryCarePlans
 * @property \Cake\ORM\Association\BelongsToMany $SystemicDiagnosis
 */
class HospitalizationsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('hospitalizations');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Patients', [
            'foreignKey' => 'patient_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Screenings', [
            'foreignKey' => 'screening_id',
        ]);
        $this->belongsTo('Origins', [
            'foreignKey' => 'origin_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Units', [
            'foreignKey' => 'unit_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Sectors', [
            'foreignKey' => 'sector_id',
        ]);
        $this->belongsTo('MedicalCares', [
            'foreignKey' => 'medical_care_id',
        ]);
        $this->hasMany('ApacheIiScores', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('BarthelIndexes', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('BradenScales', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('Bundles', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('CardiacSurgeryChecklists', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('ChestPainProtocols', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('Comorbidities', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('CribScores', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('Cultures', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('CurbScores', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('DailySafetyChecklists', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('Diagnostics', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('Discharges', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('FugulinBradenScales', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('HistoricPatientMovements', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('IdentificationOfRisks', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('Infections', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('InformedConsentForms', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('Malformations', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('MedicalBulletins', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('MedicalOpinionRequests', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('NasScores', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('NutritionalAssessments', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('ObstetricSurgeryChecklists', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('PavPreventionBundles', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('PreAnestheticVisits', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('PreDeliricScores', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('Prescriptions', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('SafeSurgeryBundles', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('SapsIiiScores', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('SepseProtocols', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('SkinIntegrities', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('SnapIiScores', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('SofaEscores', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('StrengthAssessmentScales', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('SupportiveMeasures', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('Surgeries', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('SurgicalChecklists', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('SurgicalTevProtocols', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('ClinicTevProtocols', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('SuspectedMeProtocols', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->hasMany('VentilatoryCarePlans', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->belongsToMany('SystemicDiagnosis', [
            'foreignKey'       => 'hospitalization_id',
            'targetForeignKey' => 'systemic_diagnosi_id',
            'joinTable'        => 'hospitalizations_systemic_diagnosis',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('health_care_number');

        $validator
            ->allowEmpty('type');

        $validator
            ->allowEmpty('complementary_health');

        $validator
        //->date('expected_discharge_day')
        ->allowEmpty('expected_discharge_day');

        $validator
            ->boolean('readmission_to_hospital_until_30_days')
            ->allowEmpty('readmission_to_hospital_until_30_days');

        $validator
            ->boolean('rehospitalization_up_24')
            ->allowEmpty('rehospitalization_up_24');

        $validator
            ->numeric('weight')
            ->allowEmpty('weight');

        $validator
            ->numeric('height')
            ->allowEmpty('height');

        $validator
            ->allowEmpty('systemic_diagnosis');

        $validator
            ->allowEmpty('numero_do_prontuario');

        $validator
            ->numeric('imc')
            ->allowEmpty('imc');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['patient_id'], 'Patients'));
        $rules->add($rules->existsIn(['screening_id'], 'Screenings'));
        $rules->add($rules->existsIn(['origin_id'], 'Origins'));
        $rules->add($rules->existsIn(['unit_id'], 'Units'));
        $rules->add($rules->existsIn(['sector_id'], 'Sectors'));
        $rules->add($rules->existsIn(['medical_care_id'], 'MedicalCares'));
        return $rules;
    }
}
