<?php
namespace App\Model\Table;

use App\Model\Entity\ApacheIiScore;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ApacheIiScores Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class ApacheIiScoresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('apache_ii_scores');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType'   => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('temperatura_retal');

        $validator
            ->allowEmpty('pressao_arterial_media_mmhg');

        $validator
            ->allowEmpty('frequencia_cardiaca_bpm');

        $validator
            ->allowEmpty('frequencia_respiratoria_irpm');

        $validator
            ->allowEmpty('apache_ii_scorescol');

        $validator
            ->allowEmpty('oxigenacao');

        $validator
            ->allowEmpty('fio2_maior_que_0_5_a_ado2');

        $validator
            ->allowEmpty('fio2_menor_que_pao2');

        $validator
            ->allowEmpty('ph_arterial');

        $validator
            ->allowEmpty('sodio_serico');

        $validator
            ->allowEmpty('potassio_serico');

        $validator
            ->allowEmpty('creatinina_serica_dobrar_pontos_se_ira');

        $validator
            ->allowEmpty('hematocrito');

        $validator
            ->allowEmpty('numero_de_leucocitos');

        $validator
            ->allowEmpty('escala_de_glasgow_para_o_coma_escore');

        $validator
            ->allowEmpty('total_do_escore_fisiologico_agudo');

        $validator
            ->allowEmpty('bicarbonato_serico');

        $validator
            ->allowEmpty('paciente_nao_cirurgicos_ou_pos_operatorios');

        $validator
            ->boolean('active')
            ->allowEmpty('active');

        $validator
            ->requirePresence('data_realizacao', 'create')
            ->notEmpty('data_realizacao');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
