<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * SepseProtocol Entity.
 *
 * @property int $id
 * @property string $leucocitos
 * @property string $sepse_protocolscol
 * @property bool $alteracao_estado_geral
 * @property bool $edema_generalizado
 * @property bool $glicose_maior_que_140
 * @property bool $pcr_maior_que_2
 * @property bool $paco2_menor_que_32
 * @property string $temperatura
 * @property string $taquicardia
 * @property string $pressao
 * @property bool $respiratorio
 * @property bool $urinario
 * @property bool $cutaneo
 * @property bool $endocardite
 * @property bool $articular
 * @property bool $infeccao_de_cateter
 * @property bool $sistema_nervoso_central
 * @property bool $abdominal
 * @property string $outros_procedimentos
 * @property \Cake\I18n\Time $cultura_hora
 * @property string $lactato
 * @property bool $urina
 * @property bool $seq_traqueal
 * @property bool $liquor
 * @property bool $liquido_asotico
 * @property bool $liq_pleural
 * @property string $abordagem_inicial_outros
 * @property string $atb
 * @property \Cake\I18n\Time $atb_hora
 * @property bool $foco_presumido_infeccao
 * @property bool $2_criterios_de_sepse
 * @property bool $sepse
 * @property bool $disfuncao_organica
 * @property bool $is_active
 * @property \Cake\I18n\Time $created
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 */
class SepseProtocol extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
