<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * RiskFactors Controller
 *
 * @property \App\Model\Table\RiskFactorsTable $RiskFactors
 */
class RiskFactorsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $riskFactors = $this->paginate($this->RiskFactors);

        $this->set(compact('riskFactors'));
        $this->set('_serialize', ['riskFactors']);
    }

    /**
     * View method
     *
     * @param string|null $id Risk Factor id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $riskFactor = $this->RiskFactors->get($id, [
            'contain' => ['ClinicTevProtocols']
        ]);

        $this->set('riskFactor', $riskFactor);
        $this->set('_serialize', ['riskFactor']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $riskFactor = $this->RiskFactors->newEntity();
        if ($this->request->is('post')) {
            $riskFactor = $this->RiskFactors->patchEntity($riskFactor, $this->request->data);
            if ($this->RiskFactors->save($riskFactor)) {
                $this->Flash->success(__('The risk factor has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The risk factor could not be saved. Please, try again.'));
            }
        }
        $clinicTevProtocols = $this->RiskFactors->ClinicTevProtocols->find('list', ['limit' => 200]);
        $this->set(compact('riskFactor', 'clinicTevProtocols'));
        $this->set('_serialize', ['riskFactor']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Risk Factor id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $riskFactor = $this->RiskFactors->get($id, [
            'contain' => ['ClinicTevProtocols']
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $riskFactor = $this->RiskFactors->patchEntity($riskFactor, $this->request->data);
            if ($this->RiskFactors->save($riskFactor)) {
                $this->Flash->success(__('The risk factor has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The risk factor could not be saved. Please, try again.'));
            }
        }
        $clinicTevProtocols = $this->RiskFactors->ClinicTevProtocols->find('list', ['limit' => 200]);
        $this->set(compact('riskFactor', 'clinicTevProtocols'));
        $this->set('_serialize', ['riskFactor']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Risk Factor id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $riskFactor = $this->RiskFactors->get($id);
        if ($this->RiskFactors->delete($riskFactor)) {
            $this->Flash->success(__('The risk factor has been deleted.'));
        } else {
            $this->Flash->error(__('The risk factor could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
