<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * PavPreventionBundles Controller
 *
 * @property \App\Model\Table\PavPreventionBundlesTable $PavPreventionBundles
 */
class PavPreventionBundlesController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Permission');
        $this->set('title', 'Bundles');

        $session       = $this->request->session();
        $current_state = $session->read('current-state');
        $this->set('current_state', $current_state);

        $screening_id = $session->read('screening_id');
        $this->set('screening_id', $screening_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'PavPreventionBundles', $action);

        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations', 'Professionals'],
        ];
        $pavPreventionBundles = $this->paginate($this->PavPreventionBundles);

        $this->set(compact('pavPreventionBundles'));
        $this->set('_serialize', ['pavPreventionBundles']);
    }

    /**
     * View method
     *
     * @param string|null $id Pav Prevention Bundle id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $pavPreventionBundle = $this->PavPreventionBundles->get($id, [
            'contain' => ['Hospitalizations', 'Professionals'],
        ]);

        $this->set('pavPreventionBundle', $pavPreventionBundle);
        $this->set('_serialize', ['pavPreventionBundle']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $pavPreventionBundle = $this->PavPreventionBundles->newEntity();
        if ($this->request->is('post')) {
            $pavPreventionBundle = $this->PavPreventionBundles->patchEntity($pavPreventionBundle, $this->request->data);
            if ($this->PavPreventionBundles->save($pavPreventionBundle)) {
                $this->Flash->success(__('The pav prevention bundle has been saved.'));
                return $this->redirect(['controller' => 'Bundles', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The pav prevention bundle could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->PavPreventionBundles->Hospitalizations->find('list', ['limit' => 200]);
        $professionals    = $this->PavPreventionBundles->Professionals->find('list', ['limit' => 200]);
        $this->set(compact('pavPreventionBundle', 'hospitalizations', 'professionals'));
        $this->set('_serialize', ['pavPreventionBundle']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Pav Prevention Bundle id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {

        $session    = $this->request->session();
        $pacient_id = $session->write('bundle_id', $id);

        $pavPreventionBundle = $this->PavPreventionBundles->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $pavPreventionBundle = $this->PavPreventionBundles->patchEntity($pavPreventionBundle, $this->request->data);
            if ($this->PavPreventionBundles->save($pavPreventionBundle)) {
                $this->Flash->success(__('The pav prevention bundle has been saved.'));
                return $this->redirect(['controller' => 'Bundles', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The pav prevention bundle could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->PavPreventionBundles->Hospitalizations->find('list', ['limit' => 200]);
        $professionals    = $this->PavPreventionBundles->Professionals->find('list', ['limit' => 200]);
        $this->set(compact('pavPreventionBundle', 'hospitalizations', 'professionals'));
        $this->set('_serialize', ['pavPreventionBundle']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Pav Prevention Bundle id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $pavPreventionBundle = $this->PavPreventionBundles->get($id);
        if ($this->PavPreventionBundles->delete($pavPreventionBundle)) {
            $this->Flash->success(__('The pav prevention bundle has been deleted.'));
        } else {
            $this->Flash->error(__('The pav prevention bundle could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'Bundles', 'action' => 'index']);
    }
}
