<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Saps Iii Score']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="sapsIiiScores index col-md-10 columns content">
    <h3>Saps Iii Scores</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('data_de_realizacao') ?></th>
                <th><?= $this->Paginator->sort('created') ?></th>
                <th><?= $this->Paginator->sort('active') ?></th>
                <th><?= $this->Paginator->sort('tempo_de_estadia_antes_a_adimissao_na_uti') ?></th>
                <th><?= $this->Paginator->sort('origem_intra_hospitalar_antes_da_admissao_na_uti') ?></th>
                <th><?= $this->Paginator->sort('terapia_de_cancer') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($sapsIiiScores as $sapsIiiScore): ?>
            <tr>
                <td><?= $this->Number->format($sapsIiiScore->id) ?></td>
                <td><?= h($sapsIiiScore->data_de_realizacao) ?></td>
                <td><?= h($sapsIiiScore->created) ?></td>
                <td><?= h($sapsIiiScore->active) ?></td>
                <td><?= h($sapsIiiScore->tempo_de_estadia_antes_a_adimissao_na_uti) ?></td>
                <td><?= h($sapsIiiScore->origem_intra_hospitalar_antes_da_admissao_na_uti) ?></td>
                <td><?= h($sapsIiiScore->terapia_de_cancer) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $sapsIiiScore->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $sapsIiiScore->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $sapsIiiScore->id], ['confirm' => __('Are you sure you want to delete # {0}?', $sapsIiiScore->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>