<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * MedicalOpinionRequest Entity.
 *
 * @property int $id
 * @property string $requested_specialty_id
 * @property \App\Model\Entity\RequestedSpecialty $requested_specialty
 * @property string $motive
 * @property \Cake\I18n\Time $created
 * @property \Cake\I18n\Time $modified
 * @property int $professional_id
 * @property \App\Model\Entity\Professional $professional
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 * @property \App\Model\Entity\MedicalOpinionAnswer[] $medical_opinion_answer
 */
class MedicalOpinionRequest extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
